/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.pdmodel.graphics.color.PDJPXColorSpace;

public final class JPXFilter
extends Filter {
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index, DecodeOptions options) throws IOException {
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        BufferedImage image = this.readJPX(encoded, options, result);
        WritableRaster raster = image.getRaster();
        switch (raster.getDataBuffer().getDataType()) {
            case 0: {
                DataBufferByte byteBuffer = (DataBufferByte)raster.getDataBuffer();
                decoded.write(byteBuffer.getData());
                return result;
            }
            case 1: {
                DataBufferUShort wordBuffer = (DataBufferUShort)raster.getDataBuffer();
                for (short w : wordBuffer.getData()) {
                    decoded.write(w >> 8);
                    decoded.write(w);
                }
                return result;
            }
        }
        throw new IOException("Data type " + raster.getDataBuffer().getDataType() + " not implemented");
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        return this.decode(encoded, decoded, parameters, index, DecodeOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPX(InputStream input, DecodeOptions options, DecodeResult result) throws IOException {
        ImageReader reader = JPXFilter.findImageReader("JPEG2000", "Java Advanced Imaging (JAI) Image I/O Tools are not installed");
        MemoryCacheImageInputStream iis = null;
        try {
            BufferedImage image;
            iis = new MemoryCacheImageInputStream(input);
            reader.setInput(iis, true, true);
            ImageReadParam irp = reader.getDefaultReadParam();
            irp.setSourceRegion(options.getSourceRegion());
            irp.setSourceSubsampling(options.getSubsamplingX(), options.getSubsamplingY(), options.getSubsamplingOffsetX(), options.getSubsamplingOffsetY());
            options.setFilterSubsampled(true);
            try {
                image = reader.read(0, irp);
            }
            catch (Exception e) {
                throw new IOException("Could not read JPEG 2000 (JPX) image", e);
            }
            COSDictionary parameters = result.getParameters();
            int bpc = image.getColorModel().getPixelSize() / image.getRaster().getNumBands();
            parameters.setInt(COSName.BITS_PER_COMPONENT, bpc);
            if (!parameters.getBoolean(COSName.IMAGE_MASK, false)) {
                parameters.setItem(COSName.DECODE, null);
            }
            parameters.setInt(COSName.WIDTH, reader.getWidth(0));
            parameters.setInt(COSName.HEIGHT, reader.getHeight(0));
            if (!parameters.containsKey(COSName.COLORSPACE)) {
                result.setColorSpace(new PDJPXColorSpace(image.getColorModel().getColorSpace()));
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        throw new UnsupportedOperationException("JPX encoding not implemented");
    }
}

