/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNProcess;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;

public class StandardColorSpaceHelper
implements ColorSpaceHelper {
    protected PreflightContext context = null;
    protected ICCProfileWrapper iccpw = null;
    protected PDColorSpace pdcs = null;

    protected StandardColorSpaceHelper(PreflightContext _context, PDColorSpace _cs) {
        this.context = _context;
        this.pdcs = _cs;
    }

    @Override
    public final void validate() throws ValidationException {
        if (this.pdcs == null) {
            throw new ValidationException("Unable to create a PDColorSpace with the value null");
        }
        this.iccpw = ICCProfileWrapper.getOrSearchICCProfile(this.context);
        this.processAllColorSpace(this.pdcs);
    }

    protected final void processAllColorSpace(PDColorSpace colorSpace) {
        ColorSpaces cs = ColorSpaces.valueOf(colorSpace.getName());
        switch (cs) {
            case DeviceRGB: 
            case RGB: {
                this.processRGBColorSpace(colorSpace);
                break;
            }
            case DeviceCMYK: 
            case CMYK: {
                this.processCYMKColorSpace(colorSpace);
                break;
            }
            case CalRGB: 
            case CalGray: 
            case Lab: {
                this.processCalibratedColorSpace(colorSpace);
                break;
            }
            case DeviceGray: 
            case G: {
                this.processGrayColorSpace(colorSpace);
                break;
            }
            case ICCBased: {
                this.processICCBasedColorSpace(colorSpace);
                break;
            }
            case DeviceN: {
                this.processDeviceNColorSpace(colorSpace);
                break;
            }
            case Indexed: 
            case I: {
                this.processIndexedColorSpace(colorSpace);
                break;
            }
            case Separation: {
                this.processSeparationColorSpace(colorSpace);
                break;
            }
            case Pattern: {
                this.processPatternColorSpace(colorSpace);
                break;
            }
            default: {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.4", cs.getLabel() + " is unknown as ColorSpace"));
            }
        }
    }

    protected void processRGBColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isRGBColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.1", "DestOutputProfile isn't RGB ColorSpace"));
            }
        }
    }

    protected void processCYMKColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isCMYKColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.2", "DestOutputProfile isn't CMYK ColorSpace"));
            }
        }
    }

    protected void processPatternColorSpace(PDColorSpace colorSpace) {
        if (this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processGrayColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace) && this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processCalibratedColorSpace(PDColorSpace colorSpace) {
    }

    protected void processICCBasedColorSpace(PDColorSpace colorSpace) {
        PDICCBased iccBased = (PDICCBased)colorSpace;
        try {
            COSInputStream is = iccBased.getPDStream().createInputStream();
            ICC_Profile iccp = ICC_Profile.getInstance(is);
            ((InputStream)is).close();
            PDColorSpace altpdcs = iccBased.getAlternateColorSpace();
            if (altpdcs != null) {
                ColorSpaces altCsId = ColorSpaces.valueOf(altpdcs.getName());
                if (altCsId == ColorSpaces.Pattern) {
                    this.context.addValidationError(new ValidationResult.ValidationError("2.4.5", "Pattern is forbidden as AlternateColorSpace of a ICCBased"));
                }
                if (!this.validateICCProfileNEntry(iccBased.getPDStream().getCOSObject(), iccp)) {
                    return;
                }
                if (!this.validateICCProfileVersion(iccp)) {
                    return;
                }
                this.validateICCProfileAlternateEntry(iccBased);
            }
        }
        catch (IllegalArgumentException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.11", "ICCBased color space is invalid: " + e.getMessage(), e));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.11", "ICCBased color space is invalid: " + e.getMessage(), e));
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read ICCBase color space: " + e.getMessage(), e));
        }
    }

    protected void processDeviceNColorSpace(PDColorSpace colorSpace) {
        PDDeviceN deviceN = (PDDeviceN)colorSpace;
        try {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
                return;
            }
            COSBase cosAlt = ((COSArray)colorSpace.getCOSObject()).getObject(2);
            PDColorSpace altColor = PDColorSpace.create(cosAlt);
            if (altColor != null) {
                this.processAllColorSpace(altColor);
            }
            int numberOfColorants = 0;
            PDDeviceNAttributes attr = deviceN.getAttributes();
            if (attr != null) {
                Map<String, PDSeparation> colorants = attr.getColorants();
                numberOfColorants = colorants.size();
                for (PDSeparation col : colorants.values()) {
                    if (col == null) continue;
                    this.processAllColorSpace(col);
                }
                PDDeviceNProcess process = attr.getProcess();
                if (process != null) {
                    this.processAllColorSpace(process.getColorSpace());
                }
            }
            int numberOfComponents = deviceN.getNumberOfComponents();
            if (numberOfColorants > 8 || numberOfComponents > 8) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.10", "DeviceN has too many tint components or colorants"));
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read DeviceN color space : " + e.getMessage(), e));
        }
    }

    protected void processIndexedColorSpace(PDColorSpace colorSpace) {
        PDIndexed indexed = (PDIndexed)colorSpace;
        PDColorSpace based = indexed.getBaseColorSpace();
        ColorSpaces cs = ColorSpaces.valueOf(based.getName());
        if (cs == ColorSpaces.Indexed || cs == ColorSpaces.I) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Indexed color space can't be used as Base color space"));
            return;
        }
        if (cs == ColorSpaces.Pattern) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Pattern color space can't be used as Base color space"));
            return;
        }
        this.processAllColorSpace(based);
    }

    protected void processSeparationColorSpace(PDColorSpace colorSpace) {
        try {
            COSBase cosAlt = ((COSArray)colorSpace.getCOSObject()).getObject(2);
            PDColorSpace altCol = PDColorSpace.create(cosAlt);
            if (altCol != null) {
                ColorSpaces acs = ColorSpaces.valueOf(altCol.getName());
                switch (acs) {
                    case DeviceN: 
                    case Indexed: 
                    case I: 
                    case Separation: 
                    case Pattern: {
                        this.context.addValidationError(new ValidationResult.ValidationError("2.4.7", acs.getLabel() + " color space can't be used as alternate color space"));
                        break;
                    }
                    default: {
                        this.processAllColorSpace(altCol);
                    }
                }
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read Separation color space : " + e.getMessage(), e));
        }
    }

    protected boolean processDefaultColorSpace(PDColorSpace colorSpace) {
        boolean result = false;
        PreflightPath vPath = this.context.getValidationPath();
        PDResources resources = vPath.getClosestPathElement(PDResources.class);
        if (resources != null) {
            PDColorSpace defaultCS = null;
            try {
                if (colorSpace.getName().equals(ColorSpaces.DeviceCMYK.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_CMYK)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_CMYK);
                } else if (colorSpace.getName().equals(ColorSpaces.DeviceRGB.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_RGB)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_RGB);
                } else if (colorSpace.getName().equals(ColorSpaces.DeviceGray.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_GRAY)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_GRAY);
                }
            }
            catch (IOException e) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read default color space : " + e.getMessage(), e));
            }
            if (defaultCS != null) {
                int nbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                this.processAllColorSpace(defaultCS);
                int newNbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                result = nbOfErrors == newNbOfErrors;
            }
        }
        return result;
    }

    private boolean validateICCProfileVersion(ICC_Profile iccp) {
        PreflightConfiguration config = this.context.getConfig();
        if (iccp.getMajorVersion() == 2) {
            if (iccp.getMinorVersion() > 64) {
                ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.6", "Invalid version of the ICCProfile");
                error.setWarning(config.isLazyValidation());
                this.context.addValidationError(error);
                return false;
            }
        } else if (iccp.getMajorVersion() > 2) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.6", "Invalid version of the ICCProfile");
            error.setWarning(config.isLazyValidation());
            this.context.addValidationError(error);
            return false;
        }
        return true;
    }

    private boolean validateICCProfileNEntry(COSStream stream, ICC_Profile iccp) {
        COSDictionary streamDict = (COSDictionary)stream.getCOSObject();
        if (!streamDict.containsKey(COSName.N)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.2", "/N entry of ICC profile is mandatory"));
            return false;
        }
        COSBase nValue = streamDict.getItem(COSName.N);
        if (!(nValue instanceof COSNumber)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.2", "/N entry of ICC profile must be a number, but is " + nValue));
            return false;
        }
        int nNumberValue = ((COSNumber)nValue).intValue();
        if (nNumberValue != 1 && nNumberValue != 3 && nNumberValue != 4) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.2", "/N entry of ICC profile must be 1, 3 or 4, but is " + nNumberValue));
            return false;
        }
        if (iccp.getNumComponents() != nNumberValue) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.2", "/N entry of ICC profile is " + nNumberValue + " but the ICC profile has " + iccp.getNumComponents() + " components"));
            return false;
        }
        return true;
    }

    private void validateICCProfileAlternateEntry(PDICCBased iccBased) throws IOException {
        PDColorSpace altCS = iccBased.getAlternateColorSpace();
        if (altCS != null && altCS.getNumberOfComponents() != iccBased.getNumberOfComponents()) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.2", "/N entry of ICC profile is different (" + iccBased.getNumberOfComponents() + ") than alternate entry colorspace component count (" + altCS.getNumberOfComponents() + ")"));
        }
    }
}

