/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.ValidationProcess;

public final class ContextHelper {
    private ContextHelper() {
    }

    public static void validateElement(PreflightContext context, Object element, String processName) throws ValidationException {
        if (element == null) {
            context.addValidationError(new ValidationResult.ValidationError("8.1", "Unable to process an element if it is null."));
        } else {
            ContextHelper.callValidation(context, element, processName);
        }
    }

    private static void callValidation(PreflightContext context, Object element, String processName) throws ValidationException {
        PreflightPath validationPath = context.getValidationPath();
        if (ContextHelper.hasRecursion(context, element, validationPath)) {
            return;
        }
        if (element instanceof COSObjectable && ("graphic-process".equals(processName) || "font-process".equals(processName))) {
            COSBase cos = ((COSObjectable)element).getCOSObject();
            if (context.isInProcessedSet(cos)) {
                return;
            }
            context.addToProcessedSet(cos);
        }
        boolean needPop = validationPath.pushObject(element);
        PreflightConfiguration config = context.getConfig();
        ValidationProcess process = config.getInstanceOfProcess(processName);
        process.validate(context);
        if (needPop) {
            validationPath.pop();
        }
    }

    private static boolean hasRecursion(PreflightContext context, Object element, PreflightPath validationPath) {
        if (element instanceof PDResources || element instanceof PDFormXObject) {
            for (int i = 0; i < validationPath.size(); ++i) {
                COSObjectable cos;
                Object obj = validationPath.getPathElement(i, Object.class);
                if (!(obj instanceof COSObjectable) || (cos = (COSObjectable)obj).getCOSObject() != ((COSObjectable)element).getCOSObject()) continue;
                context.addValidationError(new ValidationResult.ValidationError("8", element.getClass().getSimpleName() + " recursion"));
                return true;
            }
        }
        return false;
    }

    public static void validateElement(PreflightContext context, String processName) throws ValidationException {
        ContextHelper.callValidation(context, null, processName);
    }
}

