/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Priority;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.PriorityClasses;

public class DecoratorsManager {
    private List<Class<?>> enabledDecorators = new CopyOnWriteArrayList();
    private final WebBeansContext webBeansContext;
    private List<Class<?>> additionalDecoratorClasses = new ArrayList();
    private Set<javax.enterprise.inject.spi.Decorator<?>> webBeansDecorators = new CopyOnWriteArraySet();
    private final PriorityClasses priorityDecorators = new PriorityClasses();

    public DecoratorsManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void addEnabledDecorator(Class<?> decoratorClazz) {
        Asserts.assertNotNull(decoratorClazz, "decoratorClazz parameter");
        if (!this.enabledDecorators.contains(decoratorClazz)) {
            this.enabledDecorators.add(decoratorClazz);
        }
    }

    public int compare(Class<?> src, Class<?> target) {
        int targetIndex;
        Asserts.assertNotNull(src, "src parameter");
        Asserts.assertNotNull(target, "target parameter");
        int p1 = this.priorityDecorators.getSorted().indexOf(src);
        int p2 = this.priorityDecorators.getSorted().indexOf(target);
        int srcIndex = p1;
        if (srcIndex == -1) {
            int i = this.enabledDecorators.indexOf(src);
            if (i == -1) {
                throw new IllegalArgumentException(src.getName() + " is not contained in the enabled decorators list!");
            }
            srcIndex = this.priorityDecorators.getSorted().size() + i;
        }
        if ((targetIndex = p2) == -1) {
            int i = this.enabledDecorators.indexOf(target);
            if (i == -1) {
                throw new IllegalArgumentException(target.getName() + " is not contained in the enabled decorators list!");
            }
            targetIndex = this.priorityDecorators.getSorted().size() + i;
        }
        if (p1 != -1 && p2 != -1) {
            return p1 - p2;
        }
        if (p1 == -1 && p2 != -1) {
            return 1;
        }
        if (p1 != -1) {
            return -1;
        }
        return srcIndex - targetIndex;
    }

    public boolean isDecoratorEnabled(Class<?> decoratorClazz) {
        Asserts.nullCheckForClass(decoratorClazz, "decoratorClazz can not be null");
        return this.enabledDecorators.contains(decoratorClazz) || this.priorityDecorators.contains(decoratorClazz);
    }

    public void validateDecoratorClasses() {
        for (Class<?> decoratorClazz : this.enabledDecorators) {
            if (decoratorClazz.isAnnotationPresent(Decorator.class) || this.containsCustomDecoratorClass(decoratorClazz)) continue;
            throw new WebBeansDeploymentException("Given class : " + decoratorClazz + " is not a decorator class");
        }
    }

    public void addCustomDecoratorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        this.additionalDecoratorClasses.add(clazz);
    }

    public boolean containsCustomDecoratorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return this.additionalDecoratorClasses.contains(clazz);
    }

    public Set<javax.enterprise.inject.spi.Decorator<?>> getDecorators() {
        return this.webBeansDecorators;
    }

    public void addDecorator(javax.enterprise.inject.spi.Decorator decorator) {
        OwbBean owbBean;
        this.webBeansDecorators.add(decorator);
        if (decorator instanceof OwbBean && (owbBean = (OwbBean)decorator).isPassivationCapable()) {
            this.webBeansContext.getBeanManagerImpl().addPassivationInfo((Bean<?>)decorator);
        }
    }

    public Set<javax.enterprise.inject.spi.Decorator<?>> findDeployedWebBeansDecorator(Set<Type> apiTypes, Annotation ... anns) {
        HashSet set = new HashSet();
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        HashSet<Annotation> listAnnot = new HashSet<Annotation>();
        for (Annotation ann : anns) {
            bindingTypes.add(ann.annotationType());
            listAnnot.add(ann);
        }
        if (listAnnot.isEmpty()) {
            listAnnot.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        }
        for (javax.enterprise.inject.spi.Decorator decorator : this.getDecorators()) {
            if (!this.isDecoratorMatch(decorator, apiTypes, listAnnot)) continue;
            set.add(decorator);
        }
        return set;
    }

    private boolean isDecoratorMatch(javax.enterprise.inject.spi.Decorator<?> decorator, Set<Type> apiTypes, Set<Annotation> annotations) {
        if (!this.apiTypesMatchDelegateType(decorator, apiTypes)) {
            return false;
        }
        for (Annotation bindingType : decorator.getDelegateQualifiers()) {
            if (this.bindingMatchesAnnotations(bindingType, annotations)) continue;
            return false;
        }
        return true;
    }

    private boolean bindingMatchesAnnotations(Annotation bindingType, Set<Annotation> annotations) {
        for (Annotation annot : annotations) {
            if (!AnnotationUtil.isCdiAnnotationEqual(annot, bindingType)) continue;
            return true;
        }
        return false;
    }

    private boolean apiTypesMatchDelegateType(javax.enterprise.inject.spi.Decorator<?> decorator, Set<Type> apiTypes) {
        boolean ok = false;
        for (Type apiType : apiTypes) {
            if (!GenericsUtil.satisfiesDependency(true, false, decorator.getDelegateType(), apiType)) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public void clear() {
        this.additionalDecoratorClasses.clear();
        this.webBeansDecorators.clear();
        this.priorityDecorators.clear();
    }

    public List<Class<?>> getPrioritizedDecorators() {
        return this.priorityDecorators.getSorted();
    }

    public void addPriorityClazzDecorator(Class<?> javaClass, Priority priority) {
        this.priorityDecorators.add(javaClass, priority);
    }
}

