/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.AbstractProxyFactory;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.proxy.OwbInterceptorProxy;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.xbean.asm6.ClassWriter;
import org.apache.xbean.asm6.Label;
import org.apache.xbean.asm6.MethodVisitor;
import org.apache.xbean.asm6.Type;

public class InterceptorDecoratorProxyFactory
extends AbstractProxyFactory {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(InterceptorDecoratorProxyFactory.class);
    public static final String FIELD_PROXIED_INSTANCE = "owbIntDecProxiedInstance";
    public static final String FIELD_INTERCEPTOR_HANDLER = "owbIntDecHandler";
    public static final String FIELD_INTERCEPTED_METHODS = "owbIntDecMethods";
    private ConcurrentMap<Bean<?>, Class<?>> cachedProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<AnnotatedType<?>, Class<?>> cachedProxyClassesByAt = new ConcurrentHashMap();

    public InterceptorDecoratorProxyFactory(WebBeansContext webBeansContext) {
        super(webBeansContext);
    }

    public <T> T createProxyInstance(Class<? extends T> proxyClass, T instance, InterceptorHandler interceptorDecoratorStack) throws ProxyGenerationException {
        Asserts.assertNotNull(instance);
        try {
            T proxy = this.unsafeNewInstance(proxyClass);
            Field delegateField = proxy.getClass().getDeclaredField(FIELD_PROXIED_INSTANCE);
            delegateField.setAccessible(true);
            delegateField.set(proxy, instance);
            Field invocationHandlerField = proxy.getClass().getDeclaredField(FIELD_INTERCEPTOR_HANDLER);
            invocationHandlerField.setAccessible(true);
            invocationHandlerField.set(proxy, interceptorDecoratorStack);
            return proxy;
        }
        catch (IllegalAccessException e) {
            throw new ProxyGenerationException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ProxyGenerationException(e);
        }
    }

    public <T> T unwrapInstance(T proxyInstance) {
        try {
            if (proxyInstance instanceof OwbInterceptorProxy) {
                Field internalInstanceField = proxyInstance.getClass().getDeclaredField(FIELD_PROXIED_INSTANCE);
                internalInstanceField.setAccessible(true);
                return (T)internalInstanceField.get(proxyInstance);
            }
            return proxyInstance;
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public InterceptorHandler getInterceptorHandler(OwbInterceptorProxy proxyInstance) {
        try {
            Field internalInstanceField = proxyInstance.getClass().getDeclaredField(FIELD_INTERCEPTOR_HANDLER);
            internalInstanceField.setAccessible(true);
            return (InterceptorHandler)internalInstanceField.get(proxyInstance);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public synchronized <T> Class<T> createProxyClass(Bean<T> bean, ClassLoader classLoader, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods) throws ProxyGenerationException {
        Class<T> proxyClass = this.createProxyClass(classLoader, classToProxy, interceptedMethods, nonInterceptedMethods);
        this.cachedProxyClasses.put(bean, proxyClass);
        return proxyClass;
    }

    public synchronized <T> Class<T> createProxyClass(InterceptorResolutionService.BeanInterceptorInfo interceptorInfo, AnnotatedType<T> at, ClassLoader classLoader) throws ProxyGenerationException {
        Set<Method> intercepted = interceptorInfo.getBusinessMethodsInfo().keySet();
        List<Method> others = interceptorInfo.getNonInterceptedMethods();
        Class<T> proxyClass = this.createProxyClass(classLoader, at.getJavaClass(), intercepted.toArray(new Method[intercepted.size()]), others.toArray(new Method[others.size()]));
        this.cachedProxyClassesByAt.put(at, proxyClass);
        return proxyClass;
    }

    private <T> Class<T> createProxyClass(ClassLoader classLoader, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods) throws ProxyGenerationException {
        String proxyClassName = this.getUnusedProxyClassName(classLoader, (classToProxy.getSigners() != null ? this.getSignedClassProxyName(classToProxy) : classToProxy.getName()) + "$$OwbInterceptProxy");
        Class<T> clazz = this.createProxyClass(classLoader, proxyClassName, classToProxy, interceptedMethods, nonInterceptedMethods);
        try {
            Field interceptedMethodsField = clazz.getDeclaredField(FIELD_INTERCEPTED_METHODS);
            interceptedMethodsField.setAccessible(true);
            interceptedMethodsField.set(null, interceptedMethods);
        }
        catch (Exception e) {
            throw new ProxyGenerationException(e);
        }
        return clazz;
    }

    public <T> Class<T> getCachedProxyClass(InterceptorResolutionService.BeanInterceptorInfo interceptorInfo, AnnotatedType<T> at, ClassLoader classLoader) {
        Class<T> value = (Class<T>)this.cachedProxyClassesByAt.get(at);
        if (value == null) {
            value = this.createProxyClass(interceptorInfo, at, classLoader);
        }
        return value;
    }

    public <T> Class<T> getCachedProxyClass(Bean<T> bean) {
        return (Class)this.cachedProxyClasses.get(bean);
    }

    @Override
    protected Class getMarkerInterface() {
        return OwbInterceptorProxy.class;
    }

    @Override
    protected void createInstanceVariables(ClassWriter cw, Class<?> classToProxy, String classFileName) {
        cw.visitField(2, FIELD_PROXIED_INSTANCE, Type.getDescriptor(classToProxy), null, null).visitEnd();
        cw.visitField(2, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class), null, null).visitEnd();
        cw.visitField(10, FIELD_INTERCEPTED_METHODS, Type.getDescriptor(Method[].class), null, null).visitEnd();
    }

    @Override
    protected void createSerialisation(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName) {
        String[] exceptionTypeNames = new String[]{Type.getType(ObjectStreamException.class).getInternalName()};
        MethodVisitor mv = cw.visitMethod(1, "writeReplace", "()Ljava/lang/Object;", null, exceptionTypeNames);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassFileName, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    @Override
    protected void createConstructor(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName, Constructor<?> ignored) throws ProxyGenerationException {
        String parentClassFileName = classFileName;
        String descriptor = "()V";
        try {
            if (classToProxy.isInterface()) {
                parentClassFileName = Type.getInternalName(Object.class);
                Constructor superDefaultCt = Object.class.getConstructor(null);
                descriptor = Type.getConstructorDescriptor(superDefaultCt);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parentClassFileName, "<init>", descriptor, false);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, proxyClassFileName, FIELD_PROXIED_INSTANCE, Type.getDescriptor(classToProxy));
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, proxyClassFileName, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class));
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    @Override
    protected void delegateNonInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] noninterceptedMethods) {
        for (Method delegatedMethod : noninterceptedMethods) {
            int modifiers;
            if (this.unproxyableMethod(delegatedMethod) || Modifier.isProtected(modifiers = delegatedMethod.getModifiers()) && !delegatedMethod.getDeclaringClass().getPackage().getName().equals(classToProxy.getPackage().getName())) continue;
            String methodDescriptor = Type.getMethodDescriptor((Method)delegatedMethod);
            Class<?>[] exceptionTypes = delegatedMethod.getExceptionTypes();
            String[] exceptionTypeNames = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptionTypeNames[i] = Type.getType(exceptionTypes[i]).getInternalName();
            }
            int targetModifiers = modifiers & 0x85;
            MethodVisitor mv = cw.visitMethod(targetModifiers, delegatedMethod.getName(), methodDescriptor, null, exceptionTypeNames);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, proxyClassFileName, FIELD_PROXIED_INSTANCE, Type.getDescriptor(classToProxy));
            int offset = 1;
            for (Class<?> aClass : delegatedMethod.getParameterTypes()) {
                Type type = Type.getType(aClass);
                mv.visitVarInsn(type.getOpcode(21), offset);
                offset += type.getSize();
            }
            Type declaringClass = Type.getType(delegatedMethod.getDeclaringClass());
            boolean isItf = delegatedMethod.getDeclaringClass().isInterface();
            mv.visitMethodInsn(isItf ? 185 : 182, declaringClass.getInternalName(), delegatedMethod.getName(), methodDescriptor, isItf);
            this.generateReturn(mv, delegatedMethod);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    @Override
    protected void delegateInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] interceptedMethods) throws ProxyGenerationException {
        for (int i = 0; i < interceptedMethods.length; ++i) {
            Method proxiedMethod = interceptedMethods[i];
            this.generateInterceptorHandledMethod(cw, proxiedMethod, i, classToProxy, proxyClassFileName);
        }
    }

    private void generateInterceptorHandledMethod(ClassWriter cw, Method method, int methodIndex, Class<?> classToProxy, String proxyClassFileName) throws ProxyGenerationException {
        if ("<init>".equals(method.getName())) {
            return;
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        int modifiers = method.getModifiers();
        if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) {
            throw new WebBeansConfigurationException("It's not possible to proxy a final or static method: " + classToProxy.getName() + " " + method.getName());
        }
        int modifier = modifiers & 0x85;
        MethodVisitor mv = cw.visitMethod(modifier, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        if (exceptionTypes.length > 0) {
            mv.visitTryCatchBlock(l0, l1, l2, "java/lang/reflect/InvocationTargetException");
        }
        mv.visitLabel(l0);
        String classNameToOverride = method.getDeclaringClass().getName().replace('.', '/');
        mv.visitLdcInsn((Object)Type.getType((String)("L" + classNameToOverride + ";")));
        mv.visitLdcInsn((Object)method.getName());
        this.createArrayDefinition(mv, parameterTypes.length, Class.class);
        int length = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitFieldInsn(178, wrapperType, "TYPE", "Ljava/lang/Class;");
            } else {
                mv.visitLdcInsn((Object)Type.getType(parameterType));
            }
            mv.visitInsn(83);
            if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                length += 2;
                continue;
            }
            ++length;
        }
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassFileName, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class));
        mv.visitFieldInsn(178, proxyClassFileName, FIELD_INTERCEPTED_METHODS, Type.getDescriptor(Method[].class));
        if (methodIndex < 128) {
            mv.visitIntInsn(16, methodIndex);
        } else if (methodIndex < 32267) {
            mv.visitIntInsn(17, methodIndex);
        } else {
            throw new ProxyGenerationException("Sorry, we only support Classes with 2^15 methods...");
        }
        mv.visitInsn(50);
        this.pushMethodParameterArray(mv, parameterTypes);
        mv.visitMethodInsn(185, Type.getInternalName(InterceptorHandler.class), "invoke", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true);
        mv.visitTypeInsn(192, this.getCastType(returnType));
        if (returnType.isPrimitive() && !Void.TYPE.equals(returnType)) {
            mv.visitMethodInsn(182, this.getWrapperType(returnType), this.getPrimitiveMethod(returnType), "()" + Type.getDescriptor(returnType), false);
        }
        mv.visitLabel(l1);
        if (!Void.TYPE.equals(returnType)) {
            mv.visitInsn(this.getReturnInsn(returnType));
        } else {
            mv.visitInsn(87);
            mv.visitInsn(177);
        }
        if (exceptionTypes.length > 0) {
            mv.visitLabel(l2);
            mv.visitVarInsn(58, length);
            Label l5 = new Label();
            mv.visitLabel(l5);
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                mv.visitLdcInsn((Object)Type.getType((String)("L" + exceptionType.getCanonicalName().replace('.', '/') + ";")));
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
                mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                Label l7 = new Label();
                mv.visitLabel(l7);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitTypeInsn(192, this.getCastType(exceptionType));
                mv.visitInsn(191);
                mv.visitLabel(l6);
                if (i != exceptionTypes.length - 1) continue;
                mv.visitTypeInsn(187, "java/lang/reflect/UndeclaredThrowableException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(183, "java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

