/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.configurator.ProducerConfigurator;

public class ProducerConfiguratorImpl<T>
implements ProducerConfigurator<T> {
    private Function produceWithCallback;
    private Consumer disposeWithCallback;
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    public <U extends T> ProducerConfigurator<T> produceWith(Function<CreationalContext<U>, U> callback) {
        this.produceWithCallback = callback;
        return this;
    }

    public ProducerConfigurator<T> disposeWith(Consumer<T> callback) {
        this.disposeWithCallback = callback;
        return this;
    }

    public ProducerConfigurator<T> addInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    public <T> Producer<T> getProducer() {
        return new ConfiguredProducer();
    }

    public class ConfiguredProducer<T>
    implements Producer<T> {
        public T produce(CreationalContext<T> creationalContext) {
            return (T)ProducerConfiguratorImpl.this.produceWithCallback.apply(creationalContext);
        }

        public void dispose(T instance) {
            ProducerConfiguratorImpl.this.disposeWithCallback.accept(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return ProducerConfiguratorImpl.this.injectionPoints;
        }
    }
}

