/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.ContainerEventObserverMethodImpl;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.ProcessSessionBeanImpl;
import org.apache.webbeans.portable.events.generics.GProcessObserverMethod;
import org.apache.webbeans.portable.events.generics.GenericBeanEvent;
import org.apache.webbeans.portable.events.generics.GenericProducerObserverEvent;
import org.apache.webbeans.portable.events.generics.TwoParametersGenericBeanEvent;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class NotificationManager {
    private final Map<Type, Set<ObserverMethod<?>>> observers = new ConcurrentHashMap();
    private final WebBeansContext webBeansContext;
    private final NotificationOptions defaultNotificationOptions;
    private final ConcurrentMap<Annotation, Boolean> hasContextLifecycleEventObservers = new ConcurrentHashMap<Annotation, Boolean>();
    private final ConcurrentHashMap<Class<?>, Set<ObserverMethod<?>>> observersByRawType = new ConcurrentHashMap();
    public static final Set<Class> CONTAINER_EVENT_CLASSES = new HashSet<Class>(Arrays.asList(AfterBeanDiscovery.class, AfterDeploymentValidation.class, AfterTypeDiscovery.class, BeforeBeanDiscovery.class, BeforeShutdown.class, ProcessAnnotatedType.class, ProcessBean.class, ProcessBeanAttributes.class, ProcessSyntheticBean.class, ProcessInjectionPoint.class, ProcessInjectionTarget.class, ProcessManagedBean.class, ProcessObserverMethod.class, ProcessProducer.class, ProcessProducerField.class, ProcessProducerMethod.class, ProcessSessionBeanImpl.class, ProcessSyntheticAnnotatedType.class));

    public NotificationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.defaultNotificationOptions = NotificationOptions.ofExecutor((Executor)this.getDefaultExecutor());
    }

    private Executor getDefaultExecutor() {
        Executor service = this.webBeansContext.getService(Executor.class);
        return service != null ? service : new CloseableExecutor();
    }

    public void clearCaches() {
        this.observersByRawType.clear();
        this.hasContextLifecycleEventObservers.clear();
    }

    public boolean hasContextLifecycleObserver(Annotation lifecycleEvent) {
        Boolean hasObserver = (Boolean)this.hasContextLifecycleEventObservers.get(lifecycleEvent);
        if (hasObserver == null) {
            hasObserver = Boolean.FALSE;
            for (ObserverMethod<?> observerMethod : this.getObserverMethods()) {
                if (!observerMethod.getObservedQualifiers().contains(lifecycleEvent)) continue;
                hasObserver = Boolean.TRUE;
                break;
            }
            this.hasContextLifecycleEventObservers.putIfAbsent(lifecycleEvent, hasObserver);
        }
        return hasObserver;
    }

    public List<ObserverMethod<?>> getObserverMethods() {
        ArrayList observerMethods = new ArrayList();
        for (Set<ObserverMethod<?>> methods : this.observers.values()) {
            for (ObserverMethod<?> method : methods) {
                observerMethods.add(method);
            }
        }
        return observerMethods;
    }

    public <T> void addObserver(ObserverMethod<T> observer) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(observer.getObservedQualifiers());
        Set<ObserverMethod<?>> set = this.observers.get(observer.getObservedType());
        if (set == null) {
            set = new HashSet();
            this.observers.put(observer.getObservedType(), set);
        }
        set.add(observer);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObservers(T event, EventMetadataImpl metadata, boolean isLifecycleEvent) {
        Type eventType = metadata.validatedType();
        Set<ObserverMethod<T>> observersMethods = this.filterByType(event, eventType, isLifecycleEvent);
        observersMethods = this.filterByQualifiers(observersMethods, metadata.getQualifiers());
        if (isLifecycleEvent && event instanceof ProcessAnnotatedType) {
            observersMethods = this.filterByWithAnnotations(observersMethods, ((ProcessAnnotatedType)event).getAnnotatedType());
        }
        if (!isLifecycleEvent && observersMethods.isEmpty()) {
            EventUtil.checkEventBindings(this.webBeansContext, metadata.getQualifiers());
            EventUtil.checkQualifierImplementations(metadata.getQualifiers());
        }
        return observersMethods;
    }

    private <T> Set<ObserverMethod<? super T>> filterByWithAnnotations(Set<ObserverMethod<? super T>> observersMethods, AnnotatedType annotatedType) {
        HashSet<ObserverMethod<T>> observerMethodsWithAnnotations = new HashSet<ObserverMethod<T>>();
        for (ObserverMethod<T> observerMethod : observersMethods) {
            Class[] withAnnotations = ((ContainerEventObserverMethodImpl)observerMethod).getWithAnnotations();
            if (withAnnotations != null && withAnnotations.length > 0) {
                if (!this.annotatedTypeHasAnnotations(annotatedType, withAnnotations)) continue;
                observerMethodsWithAnnotations.add(observerMethod);
                continue;
            }
            observerMethodsWithAnnotations.add(observerMethod);
        }
        return observerMethodsWithAnnotations;
    }

    private boolean annotatedTypeHasAnnotations(AnnotatedType annotatedType, Class<? extends Annotation>[] withAnnotations) {
        if (this.hasAnnotation(annotatedType.getAnnotations(), withAnnotations)) {
            return true;
        }
        Set fields = annotatedType.getFields();
        for (Object annotatedField : fields) {
            if (!this.hasAnnotation(annotatedField.getAnnotations(), withAnnotations)) continue;
            return true;
        }
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (this.hasAnnotation(annotatedMethod.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        Set annotatedConstructors = annotatedType.getConstructors();
        for (AnnotatedConstructor annotatedConstructor : annotatedConstructors) {
            if (this.hasAnnotation(annotatedConstructor.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnnotation(Set<Annotation> annotations, Class<? extends Annotation>[] withAnnotations) {
        for (Class<? extends Annotation> withAnnotation : withAnnotations) {
            for (Annotation annotation : annotations) {
                if (withAnnotation.isAssignableFrom(annotation.annotationType())) {
                    return true;
                }
                for (Annotation meta : annotation.annotationType().getAnnotations()) {
                    if (!withAnnotation.isAssignableFrom(meta.annotationType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private <T> Set<ObserverMethod<? super T>> filterByType(T event, Type declaredEventType, boolean isLifecycleEvent) {
        Set<ObserverMethod<? super T>> rawTypeObservers;
        if (isLifecycleEvent) {
            return this.filterByExtensionEventType(event, declaredEventType);
        }
        Class<?> eventClass = event.getClass();
        boolean isRawEvent = declaredEventType instanceof Class;
        if (isRawEvent && (rawTypeObservers = this.observersByRawType.get(eventClass)) != null) {
            return rawTypeObservers;
        }
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        Set<Type> eventTypes = GenericsUtil.getTypeClosure(declaredEventType, eventClass);
        if (GenericsUtil.containTypeVariable(eventTypes)) {
            throw new IllegalArgumentException("event type may not contain unbound type variable: " + eventTypes);
        }
        block0: for (Map.Entry<Type, Set<ObserverMethod<?>>> observerEntry : this.observers.entrySet()) {
            Type observedType = observerEntry.getKey();
            for (Type eventType : eventTypes) {
                if ((!ParameterizedType.class.isInstance(eventType) || !Class.class.isInstance(observedType) || !GenericsUtil.isAssignableFrom(true, false, observedType, ((ParameterizedType)ParameterizedType.class.cast(eventType)).getRawType())) && !GenericsUtil.isAssignableFrom(true, false, observedType, eventType)) continue;
                Set<ObserverMethod<?>> observerMethods = observerEntry.getValue();
                for (ObserverMethod<?> observerMethod : observerMethods) {
                    matching.add(observerMethod);
                }
                continue block0;
            }
        }
        if (isRawEvent) {
            this.observersByRawType.putIfAbsent(eventClass, matching);
        }
        return matching;
    }

    private <T> Set<ObserverMethod<? super T>> filterByExtensionEventType(T event, Type eventType) {
        Class<?> eventClass = ClassUtil.getClazz(eventType);
        HashSet<ObserverMethod<? super T>> matching = new HashSet<ObserverMethod<? super T>>();
        Set<Type> keySet = this.observers.keySet();
        for (Type type : keySet) {
            Class<?> beanClass;
            Object genericBeanEvent;
            Class<?> observerClass = ClassUtil.getClazz(type);
            if (observerClass == null || !observerClass.isAssignableFrom(eventClass)) continue;
            if (WebBeansUtil.isExtensionBeanEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionBeanEventType(observerClass)) continue;
                genericBeanEvent = (GenericBeanEvent)event;
                beanClass = genericBeanEvent.getBeanClassFor(observerClass);
                if (ClassUtil.isParametrizedType(type)) {
                    Type secondParam = null;
                    if (TwoParametersGenericBeanEvent.class.isInstance(event)) {
                        secondParam = ((TwoParametersGenericBeanEvent)TwoParametersGenericBeanEvent.class.cast(event)).getInjectionType();
                    }
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, secondParam);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (WebBeansUtil.isExtensionProducerOrObserverEventType(eventType)) {
                genericBeanEvent = (GenericProducerObserverEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                Class<?> producerOrObserverReturnClass = genericBeanEvent.getProducerOrObserverType();
                if (WebBeansUtil.isDefaultExtensionProducerOrObserverEventType(observerClass)) {
                    boolean processProducerEvent = false;
                    if (observerClass.equals(ProcessProducer.class)) {
                        processProducerEvent = true;
                    }
                    if (ClassUtil.isParametrizedType(type)) {
                        this.addToMatchingWithParametrizedForProducers(processProducerEvent, type, beanClass, producerOrObserverReturnClass, matching);
                        continue;
                    }
                    this.addToMatching(type, matching);
                    continue;
                }
                if (!observerClass.isAssignableFrom(eventClass)) continue;
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, null);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (!observerClass.isAssignableFrom(eventClass)) continue;
            this.addToMatching(type, matching);
        }
        return matching;
    }

    private boolean checkEventTypeParameterForExtensions(Type beanClass, Type observerTypeActualArg) {
        if (ClassUtil.isTypeVariable(observerTypeActualArg)) {
            TypeVariable tv = (TypeVariable)observerTypeActualArg;
            Type tvBound = tv.getBounds()[0];
            if (tvBound instanceof Class) {
                Class clazzTvBound = (Class)tvBound;
                if (Class.class.isInstance(beanClass) && clazzTvBound.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            }
        } else {
            if (ClassUtil.isWildCardType(observerTypeActualArg)) {
                return ClassUtil.checkRequiredTypeIsWildCard(beanClass, observerTypeActualArg);
            }
            if (observerTypeActualArg instanceof Class) {
                Class observerClass = (Class)observerTypeActualArg;
                if (Class.class.isInstance(beanClass) && observerClass.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            }
        }
        return false;
    }

    private <T> void addToMatching(Type type, Set<ObserverMethod<? super T>> matching) {
        Set<ObserverMethod<?>> wrappers = this.observers.get(type);
        for (ObserverMethod<?> wrapper : wrappers) {
            matching.add(wrapper);
        }
    }

    private <T> void addToMatchingWithParametrizedForBeans(Type type, Set<ObserverMethod<? super T>> matching, Class<?> beanClass, Type secondParam) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else if (this.checkEventTypeParameterForExtensions(beanClass, actualArgs[0]) && (secondParam == null || actualArgs.length == 1 || this.checkEventTypeParameterForExtensions(secondParam, actualArgs[1]) || GenericsUtil.isAssignableFrom(true, false, actualArgs[1], secondParam))) {
            this.addToMatching(type, matching);
        }
    }

    private <T> void addToMatchingWithParametrizedForProducers(boolean processProducer, Type type, Class<?> beanClass, Class<?> producerOrObserverReturnClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else {
            Type beanClassArg = actualArgs[1];
            Type returnClassArg = actualArgs[0];
            if (processProducer) {
                beanClassArg = actualArgs[0];
                returnClassArg = actualArgs[1];
            }
            if (this.checkEventTypeParameterForExtensions(beanClass, beanClassArg) && this.checkEventTypeParameterForExtensions(producerOrObserverReturnClass, returnClassArg)) {
                this.addToMatching(type, matching);
            }
        }
    }

    private <T> Set<ObserverMethod<? super T>> filterByQualifiers(Set<ObserverMethod<? super T>> observers, Set<Annotation> eventQualifiers) {
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        block0: for (ObserverMethod<T> observerMethod : observers) {
            Set qualifiers = observerMethod.getObservedQualifiers();
            if (qualifiers.size() > eventQualifiers.size()) continue;
            for (Annotation qualifier : qualifiers) {
                boolean found = false;
                for (Annotation inList : eventQualifiers) {
                    if (!AnnotationUtil.isCdiAnnotationEqual(inList, qualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            matching.add(observerMethod);
        }
        return matching;
    }

    public NotificationOptions getDefaultNotificationOptions() {
        return this.defaultNotificationOptions;
    }

    public <T> CompletionStage<T> fireEvent(Object event, EventMetadataImpl metadata, boolean isLifecycleEvent, NotificationOptions notificationOptions) {
        boolean async;
        boolean bl = async = notificationOptions != null;
        if (!isLifecycleEvent && this.webBeansContext.getWebBeansUtil().isContainerEventType(event)) {
            throw new IllegalArgumentException("Firing container events is forbidden");
        }
        LinkedList<ObserverMethod<Object>> observerMethods = new LinkedList<ObserverMethod<Object>>(this.resolveObservers(event, metadata, isLifecycleEvent));
        Iterator observerMethodIterator = observerMethods.iterator();
        while (observerMethodIterator.hasNext()) {
            if (async == ((ObserverMethod)observerMethodIterator.next()).isAsync()) continue;
            observerMethodIterator.remove();
        }
        observerMethods.sort(Comparator.comparingInt(ObserverMethod::getPriority));
        ArrayList<CompletableFuture<Void>> completableFutures = async ? new ArrayList<CompletableFuture<Void>>() : null;
        for (ObserverMethod observerMethod : observerMethods) {
            try {
                if (isLifecycleEvent && !Extension.class.isAssignableFrom(observerMethod.getBeanClass())) continue;
                TransactionPhase phase = observerMethod.getTransactionPhase();
                if (phase != null && phase != TransactionPhase.IN_PROGRESS) {
                    if (async) {
                        throw new WebBeansConfigurationException("Async Observer Methods can only use TransactionPhase.IN_PROGRESS!");
                    }
                    TransactionService transactionService = this.webBeansContext.getService(TransactionService.class);
                    if (transactionService != null) {
                        transactionService.registerTransactionSynchronization(phase, observerMethod, event);
                        continue;
                    }
                    this.invokeObserverMethod(event, metadata, observerMethod);
                    continue;
                }
                if (async) {
                    completableFutures.add(this.invokeObserverMethodAsync(event, metadata, (ObserverMethod<? super Object>)observerMethod, notificationOptions));
                    continue;
                }
                this.invokeObserverMethod(event, metadata, observerMethod);
            }
            catch (WebBeansException e) {
                Throwable exc = e.getCause();
                if (exc instanceof InvocationTargetException) {
                    InvocationTargetException invt = (InvocationTargetException)exc;
                    exc = invt.getCause();
                }
                if (isLifecycleEvent) {
                    if (event instanceof AfterDeploymentValidation) {
                        throw new WebBeansDeploymentException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
                    }
                    throw new WebBeansConfigurationException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
                }
                if (!RuntimeException.class.isAssignableFrom(exc.getClass())) {
                    throw new ObserverException(WebBeansLoggerFacade.getTokenString("EXCEPT_0008") + event.getClass().getName(), (Throwable)e);
                }
                RuntimeException rte = (RuntimeException)exc;
                throw rte;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
        return async ? this.complete(completableFutures, event) : null;
    }

    private <T> CompletableFuture<T> complete(List<CompletableFuture<Void>> completableFutures, T event) {
        if (completableFutures == null) {
            return null;
        }
        CDICompletionFuture future = new CDICompletionFuture(event, completableFutures.size());
        completableFutures.forEach(f -> f.handle((t, e) -> {
            future.addResult((Throwable)e);
            return null;
        }));
        return future;
    }

    private CompletableFuture invokeObserverMethodAsync(Object event, EventMetadataImpl metadata, ObserverMethod<? super Object> observer, NotificationOptions notificationOptions) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                this.runAsync(event, metadata, observer);
                future.complete(null);
            }
            catch (WebBeansException wbe) {
                future.completeExceptionally(wbe.getCause());
            }
        }, notificationOptions.getExecutor() == null ? this.defaultNotificationOptions.getExecutor() : notificationOptions.getExecutor());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsync(Object event, EventMetadataImpl metadata, ObserverMethod<? super Object> observer) {
        this.webBeansContext.getContextsService().startContext(RequestScoped.class, null);
        try {
            this.invokeObserverMethod(event, metadata, observer);
        }
        finally {
            this.webBeansContext.getContextsService().endContext(RequestScoped.class, null);
        }
    }

    private <T> void invokeObserverMethod(T event, EventMetadataImpl metadata, ObserverMethod<?> observer) {
        observer.notify(new EventContextImpl<T>(event, metadata));
    }

    public <T> ObserverMethod<?> getObservableMethodForAnnotatedMethod(AnnotatedMethod<?> annotatedMethod, AnnotatedParameter<?> annotatedParameter, AbstractOwbBean<T> ownerBean) {
        Asserts.assertNotNull(annotatedParameter, "annotatedParameter");
        ObserverMethodImpl observer = null;
        if (this.isContainerEvent(annotatedParameter)) {
            observer = new ContainerEventObserverMethodImpl(ownerBean, annotatedMethod, annotatedParameter);
            this.addObserver(observer);
        } else {
            observer = new ObserverMethodImpl(ownerBean, annotatedMethod, annotatedParameter);
            GProcessObserverMethod event = new GProcessObserverMethod(this.webBeansContext, annotatedMethod, (ObserverMethod<?>)observer);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
            this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
            if (!event.isVetoed()) {
                this.addObserver(event.getObserverMethod());
            } else {
                observer = null;
            }
            event.setStarted();
        }
        return observer;
    }

    public boolean isContainerEvent(AnnotatedParameter<?> annotatedParameter) {
        AnnotatedCallable method = annotatedParameter.getDeclaringCallable();
        if (!AnnotatedMethod.class.isInstance(method) || method.getParameters().size() == 0) {
            return false;
        }
        Class<?> paramType = ((AnnotatedMethod)AnnotatedMethod.class.cast(method)).getJavaMember().getParameterTypes()[0];
        return CONTAINER_EVENT_CLASSES.contains(paramType);
    }

    private static final class CloseableExecutor
    implements Executor,
    Closeable {
        private final Collection<Runnable> tracker = new CopyOnWriteArrayList<Runnable>();
        private volatile boolean reject;

        private CloseableExecutor() {
        }

        @Override
        public void close() throws IOException {
            this.reject = true;
            this.tracker.forEach(r -> {
                try {
                    r.run();
                }
                catch (RuntimeException re) {
                    WebBeansLoggerFacade.getLogger(NotificationManager.class).warning(re.getMessage());
                }
            });
        }

        @Override
        public void execute(Runnable command) {
            if (this.reject) {
                throw new RejectedExecutionException("CDI executor is shutdown");
            }
            this.tracker.add(command);
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    command.run();
                }
                finally {
                    this.tracker.remove(command);
                }
            });
        }
    }

    private static final class CDICompletionFuture<T>
    extends CompletableFuture<T> {
        private final T event;
        private final AtomicInteger counter;
        private AtomicReference<CompletionException> error = new AtomicReference();

        private CDICompletionFuture(T event, int total) {
            this.event = event;
            this.counter = new AtomicInteger(total);
        }

        CDICompletionFuture<T> addResult(Throwable t) {
            if (t != null) {
                if (this.error.get() == null) {
                    this.error.compareAndSet(null, new CompletionException(t));
                }
                this.error.get().addSuppressed(t);
            }
            if (this.counter.decrementAndGet() == 0) {
                if (this.error.get() != null) {
                    this.completeExceptionally(this.error.get());
                } else {
                    this.complete(this.event);
                }
            }
            return this;
        }
    }
}

