/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.tomcat7;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.web.tomcat7.TomcatSecurityService;

public class TomcatWebPlugin
extends AbstractOwbPlugin {
    private final TomcatSecurityService securityService = new TomcatSecurityService();

    public <T> T getSupportedService(Class<T> serviceClass) {
        if (serviceClass.equals(SecurityService.class)) {
            return serviceClass.cast((Object)this.securityService);
        }
        return null;
    }

    public void isManagedBean(Class<?> clazz) {
        if (this.isServletSpecClass(clazz)) {
            throw new WebBeansConfigurationException("Given class  : " + clazz.getName() + " is not managed bean");
        }
    }

    public boolean supportsJavaEeComponentInjections(Class<?> clazz) {
        return this.isServletSpecClass(clazz);
    }

    private boolean isServletSpecClass(Class<?> clazz) {
        if (Servlet.class.isAssignableFrom(clazz) || Filter.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (EventListener.class.isAssignableFrom(clazz)) {
            return ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || HttpSessionActivationListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionBindingListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass.equals(SecurityService.class);
    }
}

