/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.test.configurator;

import static org.junit.Assert.assertEquals;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;

import org.apache.webbeans.test.AbstractUnitTest;
import org.junit.Test;

public class DefaultQualifierTest extends AbstractUnitTest {
    @Test
    public void start() {
        addExtension(new Extension() {
            void addBean(@Observes final AfterBeanDiscovery afterBeanDiscovery) {
                afterBeanDiscovery.addBean()
                        .addTransitiveTypeClosure(String.class)
                        .createWith(cc -> null)
                        .scope(Dependent.class);
            }
        });
        startContainer();
        final Bean<String> bean = getBean(String.class);
        assertEquals(2, bean.getQualifiers().size());
    }
}
