/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.jpql;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.AccessController;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.FillStrategy;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.ResultShape;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.AbstractExpressionBuilder;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.DateTimeExtractField;
import org.apache.openjpa.kernel.exps.DateTimeExtractPart;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Resolver;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.jpql.JPQL;
import org.apache.openjpa.kernel.jpql.JPQLTreeConstants;
import org.apache.openjpa.kernel.jpql.Node;
import org.apache.openjpa.kernel.jpql.ParseException;
import org.apache.openjpa.kernel.jpql.Token;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

public class JPQLExpressionBuilder
extends AbstractExpressionBuilder
implements JPQLTreeConstants {
    private static final int VAR_PATH = 1;
    private static final int VAR_ERROR = 2;
    private static final Localizer _loc = Localizer.forPackage(JPQLExpressionBuilder.class);
    private final Stack<Context> contexts = new Stack();
    private OrderedMap<Object, Class<?>> parameterTypes;
    private int aliasCount = 0;
    private boolean inAssignSubselectProjection = false;
    private boolean hasParameterizedInExpression = false;

    public JPQLExpressionBuilder(ExpressionFactory factory, ExpressionStoreQuery query, Object parsedQuery) {
        super(factory, query.getResolver());
        this.contexts.push(new Context(parsedQuery instanceof ParsedJPQL ? (ParsedJPQL)parsedQuery : (parsedQuery instanceof String ? this.getParsedQuery((String)parsedQuery) : null), null, null));
        if (this.ctx().parsed == null) {
            throw new InternalException("" + parsedQuery);
        }
    }

    @Override
    protected Localizer getLocalizer() {
        return _loc;
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected ParsedJPQL getParsedQuery() {
        return this.ctx().parsed;
    }

    protected ParsedJPQL getParsedQuery(String jpql) {
        return new ParsedJPQL(jpql);
    }

    private void setCandidate(ClassMetaData cmd, String schemaAlias) {
        this.addAccessPath(cmd);
        if (cmd != null) {
            this.ctx().meta = cmd;
        }
        if (schemaAlias != null) {
            this.ctx().schemaAlias = schemaAlias;
        }
    }

    private String nextAlias() {
        return "jpqlalias" + ++this.aliasCount;
    }

    protected ClassMetaData resolveClassMetaData(JPQLNode node) {
        String schemaName = this.assertSchemaName(node);
        ClassMetaData cmd = this.getClassMetaData(schemaName, false);
        if (cmd != null) {
            return cmd;
        }
        if (this.isPath(node)) {
            Path path = this.getPath(node);
            FieldMetaData fmd = path.last();
            cmd = JPQLExpressionBuilder.getFieldType(fmd);
            if (cmd == null && fmd.isElementCollection()) {
                cmd = fmd.getDefiningMetaData();
            }
            return cmd;
        }
        return this.getClassMetaData(schemaName, true);
    }

    private ClassMetaData getClassMetaData(String alias, boolean assertValid) {
        ClassLoader loader = this.getClassLoader();
        MetaDataRepository repos = this.resolver.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData cmd = repos.getMetaData(alias, loader, false);
        if (cmd != null) {
            return cmd;
        }
        Class c = this.resolver.classForName(alias, null);
        if (c != null) {
            cmd = repos.getMetaData(c, loader, assertValid);
        } else if (assertValid) {
            cmd = repos.getMetaData(alias, loader, false);
        }
        if (cmd == null && assertValid) {
            String close = repos.getClosestAliasName(alias);
            if (close != null) {
                throw this.parseException(0, "not-schema-name-hint", new Object[]{alias, close, repos.getAliasNames()}, null);
            }
            throw this.parseException(0, "not-schema-name", new Object[]{alias, repos.getAliasNames()}, null);
        }
        return cmd;
    }

    private Class<?> getCandidateType() {
        return this.getCandidateMetaData().getDescribedType();
    }

    private ClassMetaData getCandidateMetaData() {
        if (this.ctx().meta != null) {
            return this.ctx().meta;
        }
        ClassMetaData cls = this.getCandidateMetaData(this.root());
        if (cls == null) {
            throw this.parseException(0, "not-schema-name", new Object[]{this.root()}, null);
        }
        this.setCandidate(cls, null);
        return cls;
    }

    protected ClassMetaData getCandidateMetaData(JPQLNode node) {
        JPQLNode from = node.findChildByID(5, true);
        if (from == null) {
            if (node.id == 33) {
                from = node.findChildByID(4, true);
            } else {
                throw this.parseException(0, "no-from-clause", null, null);
            }
        }
        for (int i = 0; i < from.children.length; ++i) {
            JPQLNode n = from.children[i];
            if (n.id == 118) {
                ClassMetaData cmd = this.resolveClassMetaData(n);
                if (cmd != null) {
                    return cmd;
                }
                String cls = this.assertSchemaName(n);
                if (cls == null) {
                    throw this.parseException(0, "not-schema-name", new Object[]{this.root()}, null);
                }
                return this.getClassMetaData(cls, true);
            }
            if (node.id != 33) continue;
            if (n.id == 6) {
                n = n.getChild(0);
            }
            if (n.id != 10) continue;
            Path path = this.getPath(n);
            FieldMetaData fmd = path.last();
            ClassMetaData cmd = JPQLExpressionBuilder.getFieldType(fmd);
            if (cmd == null && fmd.isElementCollection()) {
                cmd = fmd.getDefiningMetaData();
            }
            if (cmd != null) {
                return cmd;
            }
            throw this.parseException(0, "no-alias", new Object[]{n}, null);
        }
        return null;
    }

    @Override
    protected String currentQuery() {
        return this.ctx().parsed == null || this.root().parser == null ? null : this.root().parser.jpql;
    }

    QueryExpressions getQueryExpressions() {
        QueryExpressions exps = new QueryExpressions();
        exps.setContexts(this.contexts);
        this.evalQueryOperation(exps);
        Expression filter = null;
        Expression from = this.ctx().from;
        if (from == null) {
            from = this.evalFromClause(this.root().id == 1);
        }
        filter = this.and(from, filter);
        filter = this.and(this.evalWhereClause(), filter);
        filter = this.and(this.evalSelectClause(exps), filter);
        exps.filter = filter == null ? this.factory.emptyExpression() : filter;
        this.evalGroupingClause(exps);
        this.evalHavingClause(exps);
        this.evalFetchJoins(exps);
        this.evalSetClause(exps);
        this.evalOrderingClauses(exps);
        if (this.parameterTypes != null) {
            exps.parameterTypes = this.parameterTypes;
        }
        exps.accessPath = this.getAccessPath();
        exps.hasInExpression = this.hasParameterizedInExpression;
        this.validateParameters();
        return exps;
    }

    private Expression and(Expression e1, Expression e2) {
        return e1 == null ? e2 : (e2 == null ? e1 : this.factory.and(e1, e2));
    }

    private static String assemble(JPQLNode node) {
        return JPQLExpressionBuilder.assemble(node, ".", 0);
    }

    private static String assemble(JPQLNode node, String delimiter, int last) {
        StringBuilder result = new StringBuilder();
        JPQLNode[] parts = node.children;
        for (int i = 0; parts != null && i < parts.length - last; ++i) {
            result.append(result.length() > 0 ? delimiter : "").append(parts[i].text);
        }
        return result.toString();
    }

    private Expression assignSubselectProjection(JPQLNode node, QueryExpressions exps) {
        Value val;
        this.inAssignSubselectProjection = true;
        exps.projections = new Value[1];
        exps.projectionClauses = new String[1];
        exps.projectionAliases = new String[1];
        exps.projections[0] = val = this.getValue(node);
        exps.projectionClauses[0] = this.projectionClause(node.id == 64 ? this.firstChild(node) : node);
        this.inAssignSubselectProjection = false;
        return null;
    }

    private Expression assignProjections(JPQLNode parametersNode, QueryExpressions exps, List<Value> projections, List<String> projectionClauses, List<String> projectionAliases) {
        int count = parametersNode.getChildCount();
        Expression exp = null;
        for (int i = 0; i < count; ++i) {
            String alias;
            JPQLNode parent = parametersNode.getChild(i);
            JPQLNode node = this.firstChild(parent);
            JPQLNode aliasNode = parent.children.length > 1 ? this.right(parent) : null;
            Value proj = this.getValue(node);
            String string = aliasNode != null ? aliasNode.text : (alias = this.projectionClause(node.id == 64 ? this.firstChild(node) : node));
            if (aliasNode != null) {
                proj.setAlias(alias);
            }
            projections.add(proj);
            projectionClauses.add(alias);
            projectionAliases.add(alias);
        }
        return exp;
    }

    private void evalProjectionsResultShape(JPQLNode selectionsNode, QueryExpressions exps, List<Value> projections, List<String> projectionClauses, List<String> projectionAliases) {
        int count = selectionsNode.getChildCount();
        Class<Object> resultClass = null;
        ResultShape<Object> resultShape = null;
        if (count > 1) {
            resultClass = Object[].class;
            resultShape = new ResultShape<Object[]>(resultClass, new FillStrategy.Array<Object[]>(Object[].class));
        }
        for (int i = 0; i < count; ++i) {
            String alias;
            JPQLNode parent = selectionsNode.getChild(i);
            JPQLNode node = this.firstChild(parent);
            if (node.id == 17) {
                String resultClassName = JPQLExpressionBuilder.assemble(this.left(node));
                Class<Object> constructor = this.resolver.classForName(resultClassName, null);
                if (constructor == null) {
                    int n = this.left(node).getChildCount();
                    String baseName = this.left((JPQLNode)node).getChild((int)(n - 1)).text;
                    constructor = this.resolver.classForName(baseName, null);
                }
                if (constructor == null && this.resolver.getConfiguration().getUseTCCLinSelectNew()) {
                    try {
                        constructor = System.getSecurityManager() != null ? AccessController.doPrivileged(J2DoPrivHelper.getForNameAction(resultClassName, false, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()))) : Thread.currentThread().getContextClassLoader().loadClass(resultClassName);
                    }
                    catch (Exception n) {
                        // empty catch block
                    }
                }
                if (constructor == null) {
                    throw this.parseException(0, "no-constructor", new Object[]{resultClassName}, null);
                }
                ArrayList<Value> terms = new ArrayList<Value>();
                ArrayList<String> aliases = new ArrayList<String>();
                ArrayList<String> clauses = new ArrayList<String>();
                this.assignProjections(this.right(node), exps, terms, aliases, clauses);
                FillStrategy.NewInstance fill = new FillStrategy.NewInstance(constructor);
                ResultShape cons = new ResultShape(constructor, fill);
                for (Value val : terms) {
                    Class type = val.getType();
                    cons.nest(new ResultShape(type, new FillStrategy.Assign(), type.isPrimitive()));
                }
                if (count == 1) {
                    resultClass = constructor;
                    resultShape = cons;
                } else {
                    resultShape.nest(cons);
                }
                projections.addAll(terms);
                projectionAliases.addAll(aliases);
                projectionClauses.addAll(clauses);
                continue;
            }
            JPQLNode aliasNode = parent.children.length > 1 ? this.right(parent) : null;
            Value proj = this.getValue(node);
            String string = aliasNode != null ? aliasNode.text : (alias = this.projectionClause(node.id == 64 ? this.firstChild(node) : node));
            if (aliasNode != null) {
                proj.setAlias(alias);
            }
            projections.add(proj);
            projectionClauses.add(alias);
            projectionAliases.add(alias);
            Class type = proj.getType();
            ResultShape projShape = new ResultShape(type, new FillStrategy.Assign(), type.isPrimitive());
            if (count == 1) {
                resultShape = projShape;
                continue;
            }
            resultShape.nest(projShape);
        }
        exps.shape = resultShape;
        exps.resultClass = resultClass;
    }

    private String projectionClause(JPQLNode node) {
        switch (node.id) {
            case 63: {
                return this.projectionClause(this.firstChild(node));
            }
        }
        return JPQLExpressionBuilder.assemble(node);
    }

    private void evalQueryOperation(QueryExpressions exps) {
        if (this.root().id == 1 || this.root().id == 33) {
            exps.operation = 1;
        } else if (this.root().id == 3) {
            exps.operation = 2;
        } else if (this.root().id == 2) {
            exps.operation = 3;
        } else {
            throw this.parseException(2, "unrecognized-operation", new Object[]{this.root()}, null);
        }
    }

    private void evalGroupingClause(QueryExpressions exps) {
        JPQLNode groupByNode = this.root().findChildByID(30, false);
        if (groupByNode == null) {
            return;
        }
        int groupByCount = groupByNode.getChildCount();
        exps.grouping = new Value[groupByCount];
        for (int i = 0; i < groupByCount; ++i) {
            FieldMetaData fmd;
            JPQLNode node = groupByNode.getChild(i);
            Value val = this.getValue(node);
            if (val instanceof Path && (fmd = ((Path)val).last()) != null && fmd.getValue().getTypeMetaData() != null && fmd.getValue().isEmbedded()) {
                throw this.parseException(0, "cant-groupby-embeddable", new Object[]{node.getChildCount() > 1 ? JPQLExpressionBuilder.assemble(node) : node.text}, null);
            }
            exps.grouping[i] = val;
        }
    }

    private void evalHavingClause(QueryExpressions exps) {
        JPQLNode havingNode = this.root().findChildByID(32, false);
        if (havingNode == null) {
            return;
        }
        exps.having = this.getExpression(this.onlyChild(havingNode));
    }

    private void evalOrderingClauses(QueryExpressions exps) {
        JPQLNode orderby = this.root().findChildByID(113, false);
        if (orderby != null) {
            int i;
            int ordercount = orderby.getChildCount();
            exps.ordering = new Value[ordercount];
            exps.orderingClauses = new String[ordercount];
            exps.orderingAliases = new String[ordercount];
            exps.ascending = new boolean[ordercount];
            for (i = 0; i < ordercount; ++i) {
                JPQLNode node = orderby.getChild(i);
                JPQLNode firstChild = this.firstChild(node);
                exps.ordering[i] = this.getValue(firstChild);
                exps.orderingClauses[i] = JPQLExpressionBuilder.assemble(firstChild);
                exps.orderingAliases[i] = firstChild.text;
                exps.ascending[i] = node.getChildCount() <= 1 || JPQLExpressionBuilder.lastChild((JPQLNode)node).id == 115;
            }
            block1: for (i = 0; i < ordercount; ++i) {
                if (exps.orderingClauses[i] != null && !exps.orderingClauses[i].equals("")) continue;
                for (int j = 0; j < exps.projections.length; ++j) {
                    if (!exps.projectionAliases[j].equalsIgnoreCase(exps.orderingAliases[i])) continue;
                    exps.ordering[i] = exps.projections[j];
                    continue block1;
                }
            }
        }
    }

    private Expression evalSelectClause(QueryExpressions exps) {
        if (exps.operation != 1) {
            return null;
        }
        JPQLNode selectNode = this.root();
        JPQLNode selectClause = selectNode.findChildByID(13, false);
        exps.distinct = selectClause != null && selectClause.hasChildID(22) ? 6 : 8;
        JPQLNode expNode = selectNode.findChildByID(14, true);
        if (expNode == null) {
            return null;
        }
        int selectCount = expNode.getChildCount();
        JPQLNode selectChild = this.firstChild(expNode);
        if (selectClause.parent.id == 33) {
            exps.distinct &= 0xFFFFFFFD;
            return this.assignSubselectProjection(this.onlyChild(selectChild), exps);
        }
        if (selectCount == 1 && selectChild != null && selectChild.getChildCount() == 1 && this.onlyChild(selectChild) != null) {
            JPQLNode child = this.onlyChild(selectChild);
            if (child.id == 64) {
                child = this.onlyChild(child);
            }
            if (this.assertSchemaAlias().equalsIgnoreCase(child.text)) {
                return null;
            }
        }
        exps.distinct &= 0xFFFFFFFD;
        exps.projections = new Value[selectCount];
        ArrayList<Value> projections = new ArrayList<Value>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> clauses = new ArrayList<String>();
        this.evalProjectionsResultShape(expNode, exps, projections, aliases, clauses);
        exps.projections = projections.toArray(new Value[projections.size()]);
        exps.projectionAliases = aliases.toArray(new String[aliases.size()]);
        exps.projectionClauses = clauses.toArray(new String[clauses.size()]);
        return null;
    }

    private String assertSchemaAlias() {
        String alias = this.ctx().schemaAlias;
        if (alias == null) {
            throw this.parseException(0, "alias-required", new Object[]{this.ctx().meta}, null);
        }
        return alias;
    }

    protected Expression evalFetchJoins(QueryExpressions exps) {
        Expression filter = null;
        TreeSet<String> joins = null;
        TreeSet<String> innerJoins = null;
        JPQLNode[] outers = this.root().findChildrenByID(8);
        for (int i = 0; outers != null && i < outers.length; ++i) {
            (joins == null ? new TreeSet<String>() : joins).add(this.getPath(this.onlyChild(outers[i])).last().getFullName(false));
        }
        JPQLNode[] inners = this.root().findChildrenByID(9);
        for (int i = 0; inners != null && i < inners.length; ++i) {
            String path = this.getPath(this.onlyChild(inners[i])).last().getFullName(false);
            (joins == null ? new TreeSet() : joins).add(path);
            (innerJoins == null ? new TreeSet<String>() : innerJoins).add(path);
        }
        if (joins != null) {
            exps.fetchPaths = joins.toArray(new String[joins.size()]);
        }
        if (innerJoins != null) {
            exps.fetchInnerPaths = innerJoins.toArray(new String[innerJoins.size()]);
        }
        return filter;
    }

    protected void evalSetClause(QueryExpressions exps) {
        JPQLNode[] nodes = this.root().findChildrenByID(11);
        for (int i = 0; nodes != null && i < nodes.length; ++i) {
            Path path = this.getPath(this.firstChild(nodes[i]));
            if (path.last().getValue().getEmbeddedMetaData() != null) {
                throw this.parseException(0, "cant-bulk-update-embeddable", new Object[]{JPQLExpressionBuilder.assemble(this.firstChild(nodes[i]))}, null);
            }
            JPQLNode lastChild = JPQLExpressionBuilder.lastChild(nodes[i]);
            Value val = lastChild.children == null ? null : this.getValue(this.onlyChild(lastChild));
            exps.putUpdate(path, val);
        }
    }

    private Expression evalWhereClause() {
        JPQLNode whereNode = this.root().findChildByID(29, false);
        if (whereNode == null) {
            return null;
        }
        return (Expression)this.eval(whereNode);
    }

    private Expression evalFromClause(boolean needsAlias) {
        JPQLNode from = this.root().findChildByID(4, false);
        if (from == null) {
            throw this.parseException(0, "no-from-clause", null, null);
        }
        return this.evalFromClause(from, needsAlias);
    }

    private Expression evalFromClause(JPQLNode from, boolean needsAlias) {
        Expression exp = null;
        for (int i = 0; i < from.children.length; ++i) {
            JPQLNode node = from.children[i];
            if (node.id == 5) {
                exp = this.evalFromItem(exp, node, needsAlias);
                continue;
            }
            if (node.id == 7) {
                exp = this.addJoin(node, false, exp);
                continue;
            }
            if (node.id == 6) {
                exp = this.addJoin(node, true, exp);
                continue;
            }
            if (node.id == 9 || node.id == 8) continue;
            throw this.parseException(0, "not-schema-name", new Object[]{node}, null);
        }
        return exp;
    }

    private Expression getSubquery(String alias, Path path, Expression exp) {
        Value var = this.getVariable(alias, true);
        Expression bindVar = this.factory.bindVariable(var, path);
        FieldMetaData fmd = path.last();
        ClassMetaData candidate = JPQLExpressionBuilder.getFieldType(fmd);
        if (candidate == null && fmd.isElementCollection()) {
            candidate = fmd.getDefiningMetaData();
        }
        this.setCandidate(candidate, alias);
        Context subContext = this.ctx();
        Subquery subquery = this.ctx().getSubquery();
        if (subquery == null) {
            subquery = this.factory.newSubquery(candidate, true, alias);
            subContext.setSubquery(subquery);
        } else {
            subquery.setSubqAlias(alias);
        }
        Path subpath = this.factory.newPath(subquery);
        subpath.setSchemaAlias(path.getCorrelationVar());
        subpath.setMetaData(candidate);
        subquery.setMetaData(candidate);
        exp = fmd.isElementCollection() ? this.and(exp, bindVar) : this.and(exp, this.factory.equal(path, subpath));
        return exp;
    }

    private Expression addJoin(JPQLNode node, boolean inner, Expression exp) {
        JPQLNode alias;
        JPQLNode firstChild = this.firstChild(node);
        Path path = null;
        path = firstChild.id == 57 ? this.getQualifiedPath(firstChild) : this.getPath(firstChild, false, inner);
        JPQLNode jPQLNode = alias = node.getChildCount() >= 2 ? this.right(node) : null;
        if (inner && this.ctx().getParent() != null && this.ctx().schemaAlias == null) {
            return this.getSubquery(alias.text, path, exp);
        }
        return this.addJoin(path, alias, exp);
    }

    private Expression addJoin(Path path, JPQLNode aliasNode, Expression exp) {
        FieldMetaData fmd = path.last();
        if (fmd == null) {
            throw this.parseException(0, "path-no-meta", new Object[]{path, null}, null);
        }
        String alias = aliasNode != null ? aliasNode.text : this.nextAlias();
        Value var = this.getVariable(alias, true);
        var.setMetaData(JPQLExpressionBuilder.getFieldType(fmd));
        Expression join = null;
        boolean bound = this.isBound(var);
        if (bound) {
            var = this.getValue(aliasNode, 1);
        } else {
            this.bind(var);
            join = this.and(join, this.factory.bindVariable(var, path));
        }
        if (!fmd.isTypePC()) {
            if (bound) {
                join = this.and(join, this.factory.contains(path, var));
            }
            this.setImplicitContainsTypes(path, var, 1);
        }
        return this.and(exp, join);
    }

    private Expression evalFromItem(Expression exp, JPQLNode node, boolean needsAlias) {
        ClassMetaData cmd = this.resolveClassMetaData(this.firstChild(node));
        String alias = null;
        if (node.getChildCount() < 2) {
            if (needsAlias) {
                throw this.parseException(0, "alias-required", new Object[]{cmd}, null);
            }
        } else {
            alias = this.right((JPQLNode)node).text;
            JPQLNode left = this.left(node);
            this.addSchemaToContext(alias, cmd);
            if (this.isPath(left)) {
                Path path = this.getPath(left);
                return this.getSubquery(alias, path, exp);
            }
            Value var = this.getVariable(alias, true);
            var.setMetaData(cmd);
            this.bind(var);
        }
        if (this.ctx().schemaAlias == null) {
            this.setCandidate(cmd, alias);
        } else {
            this.addAccessPath(cmd);
        }
        return exp;
    }

    @Override
    protected boolean isDeclaredVariable(String name) {
        return false;
    }

    boolean isPath(JPQLNode node) {
        if (node.getChildCount() < 2) {
            return false;
        }
        String name = this.firstChild((JPQLNode)node).text;
        if (name == null) {
            return false;
        }
        if (this.getMetaDataForAlias(name) != null) {
            return true;
        }
        if (!this.isSeenVariable(name)) {
            return false;
        }
        Value var = this.getVariable(name, false);
        if (var != null) {
            return this.isBound(var);
        }
        return false;
    }

    private static ClassMetaData getFieldType(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        ClassMetaData cmd = null;
        ValueMetaData vmd = fmd.getElement();
        if (vmd != null) {
            cmd = vmd.getDeclaredTypeMetaData();
        } else {
            vmd = fmd.getKey();
            if (vmd != null) {
                cmd = vmd.getDeclaredTypeMetaData();
            } else {
                vmd = fmd.getValue();
                if (vmd != null) {
                    cmd = vmd.getDeclaredTypeMetaData();
                }
            }
        }
        if (cmd == null || cmd.getDescribedType() == Object.class) {
            cmd = fmd.getDeclaredTypeMetaData();
        }
        return cmd;
    }

    @Override
    protected Value getVariable(String id, boolean bind) {
        if (id == null) {
            return null;
        }
        if (bind && this.getDefinedVariable(id) == null) {
            return this.createVariable(id, bind);
        }
        return super.getVariable(id.toLowerCase(), bind);
    }

    protected Value getDefinedVariable(String id) {
        return this.ctx().getVariable(id);
    }

    @Override
    protected boolean isSeenVariable(String var) {
        Context c = this.ctx().findContext(var);
        return c != null;
    }

    private String assertSchemaName(JPQLNode node) {
        if (node.id != 118) {
            throw this.parseException(0, "not-identifer", new Object[]{node}, null);
        }
        return JPQLExpressionBuilder.assemble(node);
    }

    private void checkEmbeddable(Value val) {
        JPQLExpressionBuilder.checkEmbeddable(val, this.currentQuery());
    }

    public static void checkEmbeddable(Value val, String currentQuery) {
        ValueMetaData vm;
        Path path;
        Path path2 = path = val instanceof Path ? (Path)val : null;
        if (path == null) {
            return;
        }
        FieldMetaData fmd = path.last();
        if (fmd == null) {
            return;
        }
        ValueMetaData valueMetaData = vm = fmd.isElementCollection() ? fmd.getElement() : fmd.getValue();
        if (vm.getEmbeddedMetaData() != null) {
            String argStr = _loc.get("bad-predicate", new Object[]{fmd.getName()}).getMessage();
            Localizer.Message msg = _loc.get("parse-error", argStr, currentQuery);
            throw new UserException(msg, null);
        }
    }

    private Object eval(JPQLNode node) {
        Value val1 = null;
        Value val2 = null;
        Value val3 = null;
        boolean not = node.not;
        switch (node.id) {
            case 64: {
                return this.eval(this.onlyChild(node));
            }
            case 63: {
                return this.getType(this.onlyChild(node));
            }
            case 39: {
                return this.getTypeLiteral(node);
            }
            case 18: {
                return this.getPathOrConstant(node);
            }
            case 65: {
                return this.eval(this.onlyChild(node));
            }
            case 68: {
                return this.getSimpleCaseExpression(node);
            }
            case 66: {
                return this.getGeneralCaseExpression(node);
            }
            case 67: {
                return this.getWhenCondition(node);
            }
            case 69: {
                return this.getWhenScalar(node);
            }
            case 70: {
                return this.getCoalesceExpression(node);
            }
            case 71: {
                return this.getNullIfExpression(node);
            }
            case 29: {
                return this.getExpression(this.onlyChild(node));
            }
            case 124: {
                return this.factory.newLiteral("true".equalsIgnoreCase(node.text) ? Boolean.TRUE : Boolean.FALSE, 2);
            }
            case 122: {
                BigDecimal intlit = new BigDecimal(node.text.endsWith("l") || node.text.endsWith("L") ? node.text.substring(0, node.text.length() - 1) : node.text).multiply(new BigDecimal(this.negative(node)));
                return this.factory.newLiteral(intlit.longValue(), 1);
            }
            case 123: {
                BigDecimal declit = new BigDecimal(node.text.endsWith("d") || node.text.endsWith("D") || node.text.endsWith("f") || node.text.endsWith("F") ? node.text.substring(0, node.text.length() - 1) : node.text).multiply(new BigDecimal(this.negative(node)));
                return this.factory.newLiteral(declit, 1);
            }
            case 125: 
            case 134: 
            case 135: {
                return this.factory.newLiteral(this.trimQuotes(node.text), 4);
            }
            case 126: {
                return this.factory.newLiteral(this.trimDoubleQuotes(node.text), 4);
            }
            case 133: {
                return this.eval(this.firstChild(node));
            }
            case 131: {
                return this.getParameter(this.onlyChild((JPQLNode)node).text, false, false);
            }
            case 132: {
                return this.getParameter(node.text, true, false);
            }
            case 130: {
                boolean positional;
                JPQLNode child = this.onlyChild(node);
                boolean bl = positional = child.id == 132;
                if (!positional) {
                    child = this.onlyChild(child);
                }
                return this.getParameter(child.text, positional, true);
            }
            case 34: {
                return this.factory.or(this.getExpression(this.left(node)), this.getExpression(this.right(node)));
            }
            case 35: {
                return this.and(this.getExpression(this.left(node)), this.getExpression(this.right(node)));
            }
            case 47: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.equal(val1, val2);
            }
            case 48: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.notEqual(val1, val2);
            }
            case 51: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.lessThan(val1, val2);
            }
            case 52: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.lessThanEqual(val1, val2);
            }
            case 49: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.greaterThan(val1, val2);
            }
            case 50: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, null);
                return this.factory.greaterThanEqual(val1, val2);
            }
            case 53: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, TYPE_NUMBER);
                return this.factory.add(val1, val2);
            }
            case 54: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, TYPE_NUMBER);
                return this.factory.subtract(val1, val2);
            }
            case 55: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, TYPE_NUMBER);
                return this.factory.multiply(val1, val2);
            }
            case 56: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, TYPE_NUMBER);
                return this.factory.divide(val1, val2);
            }
            case 37: {
                val1 = this.getValue(this.child(node, 0, 3));
                val2 = this.getValue(this.child(node, 1, 3));
                val3 = this.getValue(this.child(node, 2, 3));
                this.setImplicitTypes(val1, val2, null);
                this.setImplicitTypes(val1, val3, null);
                return this.evalNot(not, this.and(this.factory.greaterThanEqual(val1, val2), this.factory.lessThanEqual(val1, val3)));
            }
            case 38: {
                Expression inExp = null;
                Iterator<JPQLNode> inIterator = node.iterator();
                JPQLNode first = inIterator.next();
                val1 = this.getValue(first);
                while (inIterator.hasNext()) {
                    JPQLNode next = inIterator.next();
                    val2 = first.id == 63 && next.id == 39 ? this.getTypeLiteral(next) : this.getValue(next);
                    if (val2 instanceof Parameter) {
                        this.hasParameterizedInExpression = true;
                    }
                    if (this.useContains(not, val1, val2, node)) {
                        return this.evalNot(not, this.factory.contains(val2, val1));
                    }
                    this.setImplicitTypes(val1, val2, null);
                    if (this.isVerticalTypeInExpr(val1, node) && not) {
                        if (inExp == null) {
                            inExp = this.factory.notEqual(val1, val2);
                            continue;
                        }
                        inExp = this.factory.and(inExp, this.factory.notEqual(val1, val2));
                        continue;
                    }
                    if (inExp == null) {
                        inExp = this.factory.equal(val1, val2);
                        continue;
                    }
                    inExp = this.factory.or(inExp, this.factory.equal(val1, val2));
                }
                if (this.isVerticalTypeInExpr(val1, node)) {
                    return inExp;
                }
                return this.and(this.evalNot(not, inExp), this.factory.notEqual(val1, this.factory.getNull()));
            }
            case 41: {
                val1 = this.getValue(this.onlyChild(node));
                this.checkEmbeddable(val1);
                if (not) {
                    return this.factory.notEqual(val1, this.factory.getNull());
                }
                return this.factory.equal(val1, this.factory.getNull());
            }
            case 10: {
                return this.getPathOrConstant(node);
            }
            case 120: 
            case 121: {
                return this.getIdentifier(node);
            }
            case 57: {
                return this.getQualifiedPath(node);
            }
            case 59: {
                return this.getQualifiedIdentifier(node);
            }
            case 62: {
                if (node.parent.parent.id == 29 || node.parent.id == 30) {
                    return this.getGeneralIdentifier(this.onlyChild(node), true);
                }
                return this.getQualifiedIdentifier(this.onlyChild(node));
            }
            case 36: {
                return this.factory.not(this.getExpression(this.onlyChild(node)));
            }
            case 40: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                JPQLExpressionBuilder.setImplicitType(val1, TYPE_STRING);
                JPQLExpressionBuilder.setImplicitType(val2, TYPE_STRING);
                String escape = null;
                JPQLNode escapeNode = this.right(node).findChildByID(134, true);
                if (escapeNode != null) {
                    escape = this.trimQuotes(this.onlyChild((JPQLNode)escapeNode).text);
                }
                if (not) {
                    return this.factory.notMatches(val1, val2, "_", "%", escape);
                }
                return this.factory.matches(val1, val2, "_", "%", escape);
            }
            case 42: {
                return this.evalNot(not, this.factory.isEmpty(this.getValue(this.onlyChild(node))));
            }
            case 93: {
                return this.factory.size(this.getValue(this.onlyChild(node)));
            }
            case 94: {
                return this.factory.index(this.getValue(this.onlyChild(node)));
            }
            case 77: {
                val1 = this.getValue(this.onlyChild(node));
                JPQLExpressionBuilder.setImplicitType(val1, TYPE_STRING);
                return this.factory.toUpperCase(val1);
            }
            case 76: {
                return this.factory.toLowerCase(this.getStringValue(this.onlyChild(node)));
            }
            case 81: {
                return this.factory.stringLength(this.getStringValue(this.onlyChild(node)));
            }
            case 83: {
                return this.factory.abs(this.getNumberValue(this.onlyChild(node)));
            }
            case 84: {
                return this.factory.ceiling(this.getNumberValue(this.onlyChild(node)));
            }
            case 85: {
                return this.factory.exp(this.getNumberValue(this.onlyChild(node)));
            }
            case 86: {
                return this.factory.floor(this.getNumberValue(this.onlyChild(node)));
            }
            case 87: {
                return this.factory.ln(this.getNumberValue(this.onlyChild(node)));
            }
            case 88: {
                return this.factory.sign(this.getNumberValue(this.onlyChild(node)));
            }
            case 89: {
                return this.factory.power(this.getNumberValue(this.firstChild(node)), this.getNumberValue(JPQLExpressionBuilder.secondChild(node)));
            }
            case 90: {
                return this.factory.round(this.getNumberValue(this.firstChild(node)), this.getNumberValue(JPQLExpressionBuilder.secondChild(node)));
            }
            case 91: {
                return this.factory.sqrt(this.getNumberValue(this.onlyChild(node)));
            }
            case 92: {
                val1 = this.getValue(this.left(node));
                val2 = this.getValue(this.right(node));
                this.setImplicitTypes(val1, val2, TYPE_NUMBER);
                return this.factory.mod(val1, val2);
            }
            case 75: {
                val1 = this.getValue(JPQLExpressionBuilder.lastChild(node));
                JPQLExpressionBuilder.setImplicitType(val1, TYPE_STRING);
                Boolean trimWhere = null;
                JPQLNode firstTrimChild = this.firstChild(node);
                if (node.getChildCount() > 1) {
                    Boolean bl = firstTrimChild.id == 78 ? Boolean.TRUE : (trimWhere = firstTrimChild.id == 79 ? Boolean.FALSE : null);
                }
                Value trimChar = node.getChildCount() == 3 ? this.getValue(JPQLExpressionBuilder.secondChild(node)) : (node.getChildCount() == 2 && firstTrimChild.id != 78 && firstTrimChild.id != 79 && firstTrimChild.id != 80 ? this.getValue(this.firstChild(node)) : this.factory.newLiteral(" ", 3));
                return this.factory.trim(val1, trimChar, trimWhere);
            }
            case 73: {
                if (node.children.length < 2) {
                    throw this.parseException(0, "less-child-count", new Object[]{2, node, Arrays.asList(node.children)}, null);
                }
                val1 = this.getValue(this.firstChild(node));
                val2 = this.getValue(JPQLExpressionBuilder.secondChild(node));
                JPQLExpressionBuilder.setImplicitType(val1, TYPE_STRING);
                JPQLExpressionBuilder.setImplicitType(val2, TYPE_STRING);
                Value concat = this.factory.concat(val1, val2);
                for (int i = 2; i < node.children.length; ++i) {
                    val2 = this.getValue(node.children[i]);
                    JPQLExpressionBuilder.setImplicitType(val2, TYPE_STRING);
                    concat = this.factory.concat(concat, val2);
                }
                return concat;
            }
            case 74: {
                val1 = this.getValue(this.firstChild(node));
                JPQLNode child2 = JPQLExpressionBuilder.secondChild(node);
                val2 = child2.id == 122 ? this.getIntegerValue(child2) : this.getValue(child2);
                if (node.getChildCount() == 3) {
                    JPQLNode child3 = JPQLExpressionBuilder.thirdChild(node);
                    val3 = child3.id == 122 ? this.getIntegerValue(child3) : this.getValue(child3);
                }
                JPQLExpressionBuilder.setImplicitType(val1, TYPE_STRING);
                JPQLExpressionBuilder.setImplicitType(val2, Integer.TYPE);
                if (node.children.length == 3) {
                    JPQLExpressionBuilder.setImplicitType(val3, Integer.TYPE);
                }
                return JPQLExpressionBuilder.convertSubstringArguments(this.factory, val1, val2, val3);
            }
            case 82: {
                Value locatePath = this.getValue(this.firstChild(node));
                Value locateSearch = this.getValue(JPQLExpressionBuilder.secondChild(node));
                Value locateFromIndex = null;
                if (node.getChildCount() > 2) {
                    JPQLNode child3 = JPQLExpressionBuilder.thirdChild(node);
                    locateFromIndex = child3.id == 122 ? this.getIntegerValue(child3) : this.getValue(child3);
                }
                JPQLExpressionBuilder.setImplicitType(locatePath, TYPE_STRING);
                JPQLExpressionBuilder.setImplicitType(locateSearch, TYPE_STRING);
                if (locateFromIndex != null) {
                    JPQLExpressionBuilder.setImplicitType(locateFromIndex, Integer.TYPE);
                }
                return this.factory.indexOf(locateSearch, locateFromIndex == null ? locatePath : this.factory.newArgumentList(locatePath, locateFromIndex));
            }
            case 21: {
                return this.eval(this.onlyChild(node));
            }
            case 24: {
                JPQLNode c = JPQLExpressionBuilder.lastChild(node);
                if (c.id == 120) {
                    return this.factory.count(this.getPath(node, false, true));
                }
                return this.factory.count(this.getValue(c));
            }
            case 26: {
                return this.factory.max(this.getNumberValue(this.onlyChild(node)));
            }
            case 27: {
                return this.factory.min(this.getNumberValue(this.onlyChild(node)));
            }
            case 28: {
                return this.factory.sum(this.getNumberValue(this.onlyChild(node)));
            }
            case 25: {
                return this.factory.avg(this.getNumberValue(this.onlyChild(node)));
            }
            case 23: {
                return this.factory.distinct(this.getValue(this.onlyChild(node)));
            }
            case 44: {
                return this.factory.isNotEmpty((Value)this.eval(this.onlyChild(node)));
            }
            case 45: {
                return this.factory.any((Value)this.eval(this.onlyChild(node)));
            }
            case 46: {
                return this.factory.all((Value)this.eval(this.onlyChild(node)));
            }
            case 33: {
                return this.getSubquery(node);
            }
            case 43: {
                val1 = this.getValue(this.left(node), 1);
                val2 = this.getValue(this.right(node), 1);
                this.checkEmbeddable(val2);
                this.setImplicitContainsTypes(val2, val1, 1);
                return this.evalNot(not, this.factory.contains(val2, val1));
            }
            case 107: {
                return this.factory.getCurrentDate(Date.class);
            }
            case 108: {
                return this.factory.getCurrentTime(Time.class);
            }
            case 109: {
                return this.factory.getCurrentTimestamp(Timestamp.class);
            }
            case 110: {
                return this.factory.getCurrentLocalDateTime(LocalDateTime.class);
            }
            case 111: {
                return this.factory.getCurrentLocalDateTime(LocalDate.class);
            }
            case 112: {
                return this.factory.getCurrentLocalDateTime(LocalTime.class);
            }
            case 95: {
                return DateTimeExtractField.YEAR;
            }
            case 96: {
                return DateTimeExtractField.QUARTER;
            }
            case 97: {
                return DateTimeExtractField.MONTH;
            }
            case 98: {
                return DateTimeExtractField.WEEK;
            }
            case 99: {
                return DateTimeExtractField.DAY;
            }
            case 100: {
                return DateTimeExtractField.HOUR;
            }
            case 101: {
                return DateTimeExtractField.MINUTE;
            }
            case 102: {
                return DateTimeExtractField.SECOND;
            }
            case 104: {
                return DateTimeExtractPart.DATE;
            }
            case 105: {
                return DateTimeExtractPart.TIME;
            }
            case 103: {
                return this.factory.getDateTimeField((DateTimeExtractField)((Object)this.eval(this.firstChild(node))), this.getValue(JPQLExpressionBuilder.secondChild(node)));
            }
            case 106: {
                return this.factory.getDateTimePart((DateTimeExtractPart)((Object)this.eval(this.firstChild(node))), this.getValue(JPQLExpressionBuilder.secondChild(node)));
            }
            case 16: {
                this.assertQueryExtensions("SELECT");
                return this.eval(this.onlyChild(node));
            }
            case 31: {
                this.assertQueryExtensions("GROUP BY");
                return this.eval(this.onlyChild(node));
            }
            case 117: {
                this.assertQueryExtensions("ORDER BY");
                return this.eval(this.onlyChild(node));
            }
            case 127: {
                return this.factory.newLiteral(node.text, 8);
            }
            case 128: {
                return this.factory.newLiteral(node.text, 9);
            }
            case 129: {
                return this.factory.newLiteral(node.text, 10);
            }
        }
        throw this.parseException(1, "bad-tree", new Object[]{node}, null);
    }

    private boolean useContains(boolean not, Value val1, Value val2, JPQLNode node) {
        if (this.isVerticalTypeInExpr(val1, node) && not) {
            return false;
        }
        return !(val2 instanceof Literal) && node.getChildCount() == 2;
    }

    private boolean isVerticalTypeInExpr(Value val, JPQLNode node) {
        if (node.id != 38) {
            return false;
        }
        return this.factory.isVerticalType(val);
    }

    private Value getIntegerValue(JPQLNode node) {
        BigDecimal bigdec = new BigDecimal(node.text.endsWith("l") || node.text.endsWith("L") ? node.text.substring(0, node.text.length() - 1) : node.text).multiply(new BigDecimal(this.negative(node)));
        return this.factory.newLiteral(bigdec.intValue(), 1);
    }

    public static Value convertSubstringArguments(ExpressionFactory factory, Value val1, Value val2, Value val3) {
        if (val3 != null) {
            return factory.substring(val1, factory.newArgumentList(val2, val3));
        }
        return factory.substring(val1, val2);
    }

    private void assertQueryExtensions(String clause) {
        OpenJPAConfiguration conf = this.resolver.getConfiguration();
        switch (conf.getCompatibilityInstance().getJPQL()) {
            case 1: {
                Log log;
                StoreContext ctx = this.resolver.getQueryContext().getStoreContext();
                String query = this.currentQuery();
                if (ctx.getBroker() != null && query != null) {
                    String key = this.getClass().getName() + ":" + query;
                    BrokerFactory factory = ctx.getBroker().getBrokerFactory();
                    Object hasWarned = factory.getUserObject(key);
                    if (hasWarned != null) break;
                    factory.putUserObject(key, Boolean.TRUE);
                }
                if (!(log = conf.getLog("openjpa.Query")).isWarnEnabled()) break;
                log.warn(_loc.get("query-extensions-warning", clause, this.currentQuery()));
                break;
            }
            case 0: {
                throw new ParseException(_loc.get("query-extensions-error", clause, this.currentQuery()).getMessage());
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Compatibility.getJPQL() == " + conf.getCompatibilityInstance().getJPQL());
            }
        }
    }

    @Override
    public void setImplicitTypes(Value val1, Value val2, Class<?> expected) {
        String currQuery = this.currentQuery();
        JPQLExpressionBuilder.setImplicitTypes(val1, val2, expected, this.resolver, this.parameterTypes, currQuery);
    }

    public static void setImplicitTypes(Value val1, Value val2, Class<?> expected, Resolver resolver, OrderedMap<Object, Class<?>> parameterTypes, String currentQuery) {
        Class type;
        Path path;
        Parameter param;
        AbstractExpressionBuilder.setImplicitTypes(val1, val2, expected, resolver);
        Parameter parameter = val1 instanceof Parameter ? (Parameter)val1 : (param = val2 instanceof Parameter ? (Parameter)val2 : null);
        Path path2 = val1 instanceof Path ? (Path)val1 : (path = val2 instanceof Path ? (Path)val2 : null);
        if (param == null || path == null || parameterTypes == null) {
            return;
        }
        FieldMetaData fmd = path.last();
        if (fmd == null) {
            return;
        }
        if (expected == null) {
            JPQLExpressionBuilder.checkEmbeddable(path, currentQuery);
        }
        if ((type = path.getType()) == null) {
            return;
        }
        Object paramKey = param.getParameterKey();
        if (paramKey == null) {
            return;
        }
        if (parameterTypes.containsKey(paramKey)) {
            parameterTypes.put(paramKey, type);
        }
    }

    private Value getStringValue(JPQLNode node) {
        return this.getTypeValue(node, TYPE_STRING);
    }

    private Value getNumberValue(JPQLNode node) {
        return this.getTypeValue(node, TYPE_NUMBER);
    }

    private Value getTypeValue(JPQLNode node, Class<?> implicitType) {
        Value val = this.getValue(node);
        JPQLExpressionBuilder.setImplicitType(val, implicitType);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getSubquery(JPQLNode node) {
        boolean subclasses = true;
        ParsedJPQL parsed = new ParsedJPQL(node.parser.jpql, node);
        Context subContext = new Context(parsed, null, this.ctx());
        this.contexts.push(subContext);
        ClassMetaData candidate = this.getCandidateMetaData(node);
        Subquery subq = subContext.getSubquery();
        if (subq == null) {
            subq = this.factory.newSubquery(candidate, true, this.nextAlias());
            subContext.setSubquery(subq);
        }
        subq.setMetaData(candidate);
        JPQLNode from = node.getChild(1);
        subContext.from = this.evalFromClause(from, true);
        try {
            QueryExpressions subexp = this.getQueryExpressions();
            subq.setQueryExpressions(subexp);
            if (subexp.projections.length > 0) {
                this.checkEmbeddable(subexp.projections[0]);
            }
            Subquery subquery = subq;
            return subquery;
        }
        finally {
            this.contexts.pop();
        }
    }

    private Parameter getParameter(String id, boolean positional, boolean isCollectionValued) {
        int index;
        String paramKey;
        if (this.parameterTypes == null) {
            this.parameterTypes = new OrderedMap();
        }
        String string = paramKey = positional ? Integer.valueOf(Integer.parseInt(id)) : id;
        if (!this.parameterTypes.containsKey(paramKey)) {
            this.parameterTypes.put(paramKey, TYPE_OBJECT);
        }
        ClassMetaData meta = null;
        if (positional) {
            try {
                index = Integer.parseInt(id) - 1;
            }
            catch (NumberFormatException e) {
                throw this.parseException(0, "bad-positional-parameter", new Object[]{id}, e);
            }
            if (index < 0) {
                throw this.parseException(0, "bad-positional-parameter", new Object[]{id}, null);
            }
        } else {
            index = this.parameterTypes.indexOf(id);
        }
        Parameter param = isCollectionValued ? this.factory.newCollectionValuedParameter(paramKey, TYPE_OBJECT) : this.factory.newParameter(paramKey, TYPE_OBJECT);
        param.setMetaData(meta);
        param.setIndex(index);
        return param;
    }

    private Expression evalNot(boolean not, Expression exp) {
        return not ? this.factory.not(exp) : exp;
    }

    private String trimQuotes(String str) {
        if (str == null || ((String)str).length() <= 1) {
            return str;
        }
        if (((String)str).startsWith("'") && ((String)str).endsWith("'")) {
            str = ((String)str).substring(1, ((String)str).length() - 1);
        }
        int index = -1;
        while ((index = ((String)str).indexOf("''", index + 1)) != -1) {
            str = ((String)str).substring(0, index + 1) + ((String)str).substring(index + 2);
        }
        return str;
    }

    private String trimDoubleQuotes(String str) {
        if (str == null || str.length() <= 1) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private short negative(JPQLNode node) {
        if (node.children != null && node.children.length == 1 && this.firstChild((JPQLNode)node).id == 72) {
            return -1;
        }
        return 1;
    }

    private Value getIdentifier(JPQLNode node) {
        String name = node.text;
        Value val = this.getVariable(name, false);
        ClassMetaData cmd = this.getMetaDataForAlias(name);
        if (cmd != null) {
            Value thiz = null;
            thiz = this.ctx().subquery == null || this.ctx().getSchema(name.toLowerCase()) == null ? (this.ctx().subquery != null && this.inAssignSubselectProjection ? this.factory.newPath(this.ctx().subquery) : this.factory.getThis()) : this.factory.newPath(this.ctx().subquery);
            ((Path)thiz).setSchemaAlias(name);
            thiz.setMetaData(cmd);
            return thiz;
        }
        if (val instanceof Path) {
            return val;
        }
        if (val instanceof Value) {
            Class c;
            if (val.isVariable() && (c = this.resolver.classForName(name, null)) != null) {
                Literal lit = this.factory.newTypeLiteral(c, 5);
                Class<?> candidate = this.getCandidateType();
                ClassMetaData can = this.getClassMetaData(candidate.getName(), false);
                ClassMetaData meta = this.getClassMetaData(name, false);
                if (candidate.isAssignableFrom(c)) {
                    lit.setMetaData(meta);
                } else {
                    lit.setMetaData(can);
                }
                return lit;
            }
            return val;
        }
        throw this.parseException(0, "unknown-identifier", new Object[]{name}, null);
    }

    private Path validateMapPath(JPQLNode node, JPQLNode id) {
        Value var;
        Path path = (Path)this.getValue(id);
        FieldMetaData fld = path.last();
        if (fld == null && this.ctx().subquery != null && (var = this.getVariable(id.text, false)) != null) {
            path = this.factory.newPath(var);
            fld = path.last();
        }
        if (fld != null) {
            if (fld.getDeclaredTypeCode() != 13) {
                String oper = "VALUE";
                if (node.id == 61) {
                    oper = "ENTRY";
                } else if (node.id == 58) {
                    oper = "KEY";
                }
                throw this.parseException(0, "bad-qualified-identifier", new Object[]{id.text, oper}, null);
            }
        } else {
            throw this.parseException(0, "unknown-type", new Object[]{id.text}, null);
        }
        return path;
    }

    private Value getGeneralIdentifier(JPQLNode node, boolean verifyEmbeddable) {
        JPQLNode id = this.onlyChild(node);
        Path path = this.validateMapPath(node, id);
        if (node.id == 58) {
            path = (Path)this.factory.getKey(path);
        }
        FieldMetaData fld = path.last();
        ClassMetaData meta = fld.getKey().getTypeMetaData();
        if (verifyEmbeddable && node.id == 58 && meta != null && fld.getKey().isEmbedded() || node.id == 60 && fld.isElementCollection() && fld.getElement().getEmbeddedMetaData() != null) {
            if (node.parent.parent.id == 30) {
                throw this.parseException(0, "cant-groupby-key-value-embeddable", new Object[]{node.id == 60 ? "VALUE" : "KEY", id.text}, null);
            }
            throw this.parseException(0, "bad-general-identifier", new Object[]{node.id == 60 ? "VALUE" : "KEY", id.text}, null);
        }
        return path;
    }

    private Value getQualifiedIdentifier(JPQLNode node) {
        JPQLNode id = this.onlyChild(node);
        Path path = this.validateMapPath(node, id);
        if (node.id == 60) {
            return path;
        }
        Value value = this.getValue(id);
        if (node.id == 58) {
            return this.factory.mapKey(path, value);
        }
        return this.factory.mapEntry(path, value);
    }

    private Path getQualifiedPath(JPQLNode node) {
        return this.getQualifiedPath(node, false, true);
    }

    private Path getQualifiedPath(JPQLNode node, boolean pcOnly, boolean inner) {
        int nChild = node.getChildCount();
        JPQLNode firstChild = this.firstChild(node);
        JPQLNode id = firstChild.id == 58 ? this.onlyChild(firstChild) : firstChild;
        Path path = this.validateMapPath(firstChild, id);
        if (firstChild.id == 120) {
            return this.getPath(node);
        }
        FieldMetaData fld = path.last();
        path = (Path)this.factory.getKey(path);
        ClassMetaData meta = fld.getKey().getTypeMetaData();
        if (meta == null) {
            throw this.parseException(0, "bad-qualified-path", new Object[]{id.text}, null);
        }
        path.setMetaData(meta);
        boolean allowNull = !inner;
        for (int i = 1; i < nChild; ++i) {
            path = (Path)this.traversePath(path, node.children[i].text, pcOnly, allowNull);
            allowNull = false;
        }
        return path;
    }

    private Value getTypeLiteral(JPQLNode node) {
        Class c;
        JPQLNode type = this.onlyChild(node);
        String name = type.text;
        Value val = this.getVariable(name, false);
        if (val instanceof Value && val.isVariable() && (c = this.resolver.classForName(name, null)) != null) {
            Literal typeLit = this.factory.newTypeLiteral(c, 5);
            typeLit.setMetaData(this.getClassMetaData(name, false));
            return typeLit;
        }
        throw this.parseException(0, "not-type-literal", new Object[]{name}, null);
    }

    private Value getPathOrConstant(JPQLNode node) {
        String className = JPQLExpressionBuilder.assemble(node, ".", 1);
        Class c = this.resolver.classForName(className, null);
        if (c != null) {
            String fieldName = JPQLExpressionBuilder.lastChild((JPQLNode)node).text;
            int type = c.isEnum() ? 6 : 0;
            try {
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                return this.factory.newLiteral(value, type);
            }
            catch (NoSuchFieldException nsfe) {
                if (node.inEnumPath) {
                    throw this.parseException(0, "no-field", new Object[]{c.getName(), fieldName}, nsfe);
                }
                return this.getPath(node, false, true);
            }
            catch (Exception e) {
                throw this.parseException(0, "unaccessible-field", new Object[]{className, fieldName}, e);
            }
        }
        return this.getPath(node, false, true);
    }

    private Value getType(JPQLNode node) {
        switch (node.id) {
            case 120: {
                return this.factory.type(this.getValue(node));
            }
            case 131: {
                return this.factory.type(this.getParameter(node.text, false, false));
            }
            case 132: {
                return this.factory.type(this.getParameter(node.text, true, false));
            }
            case 62: {
                return this.factory.type(this.getQualifiedIdentifier(this.onlyChild(node)));
            }
        }
        Path path = this.getPath(node, false, true);
        return this.factory.type(path);
    }

    private Path getPath(JPQLNode node) {
        return this.getPath(node, false, true);
    }

    private Path getPath(JPQLNode node, boolean pcOnly, boolean inner) {
        Path path = null;
        String name = this.firstChild((JPQLNode)node).text;
        Value val = this.getVariable(name, false);
        if (name.equalsIgnoreCase(this.ctx().schemaAlias)) {
            if (this.ctx().subquery != null) {
                path = this.factory.newPath(this.ctx().subquery);
                path.setMetaData(this.ctx().subquery.getMetaData());
            } else {
                path = this.factory.newPath();
                path.setMetaData(this.ctx().meta);
            }
        } else if (this.getMetaDataForAlias(name) != null) {
            path = this.newPath(null, this.getMetaDataForAlias(name));
        } else if (val instanceof Path) {
            path = (Path)val;
        } else if (val.getMetaData() != null) {
            path = this.newPath(val, val.getMetaData());
        } else {
            throw this.parseException(0, "path-invalid", new Object[]{JPQLExpressionBuilder.assemble(node), name}, null);
        }
        path.setSchemaAlias(name);
        boolean allowNull = !inner;
        for (int i = 1; i < node.children.length; ++i) {
            if (path.isXPath()) {
                for (int j = i; j < node.children.length; ++j) {
                    path = (Path)this.traverseXPath(path, node.children[j].text);
                }
                return path;
            }
            path = (Path)this.traversePath(path, node.children[i].text, pcOnly, allowNull);
            if (this.ctx().getParent() != null && this.ctx().getVariable(path.getSchemaAlias()) == null) {
                path.setSubqueryContext(this.ctx(), name);
            }
            allowNull = false;
        }
        return path;
    }

    @Override
    protected Class<?> getDeclaredVariableType(String name) {
        ClassMetaData cmd = this.getMetaDataForAlias(name);
        if (cmd != null) {
            return cmd.getDescribedType();
        }
        if (name != null && name.equals(this.ctx().schemaAlias)) {
            return this.getCandidateType();
        }
        return null;
    }

    private Expression getExpression(JPQLNode node) {
        Object exp = this.eval(node);
        if (!(exp instanceof Expression)) {
            return this.factory.asExpression((Value)exp);
        }
        return (Expression)exp;
    }

    private Value getSimpleCaseExpression(JPQLNode node) {
        Object caseOperand = this.eval(node.getChild(0));
        int nChild = node.getChildCount();
        Object val = this.eval(JPQLExpressionBuilder.lastChild(node));
        Expression[] exp = new Expression[nChild - 2];
        for (int i = 1; i < nChild - 1; ++i) {
            exp[i - 1] = this.eval(node.children[i]);
        }
        return this.factory.simpleCaseExpression((Value)caseOperand, exp, (Value)val);
    }

    private Value getGeneralCaseExpression(JPQLNode node) {
        int nChild = node.getChildCount();
        Object val = this.eval(JPQLExpressionBuilder.lastChild(node));
        Expression[] exp = new Expression[nChild - 1];
        for (int i = 0; i < nChild - 1; ++i) {
            exp[i] = this.eval(node.children[i]);
        }
        return this.factory.generalCaseExpression(exp, (Value)val);
    }

    private Expression getWhenCondition(JPQLNode node) {
        Object exp = this.eval(this.firstChild(node));
        Object val = this.eval(JPQLExpressionBuilder.secondChild(node));
        return this.factory.whenCondition((Expression)exp, (Value)val);
    }

    private Expression getWhenScalar(JPQLNode node) {
        Object val1 = this.eval(this.firstChild(node));
        Object val2 = this.eval(JPQLExpressionBuilder.secondChild(node));
        return this.factory.whenScalar((Value)val1, (Value)val2);
    }

    private Value getCoalesceExpression(JPQLNode node) {
        int nChild = node.getChildCount();
        Value[] vals = new Value[nChild];
        for (int i = 0; i < nChild; ++i) {
            vals[i] = this.eval(node.children[i]);
        }
        return this.factory.coalesceExpression(vals);
    }

    private Value getNullIfExpression(JPQLNode node) {
        Object val1 = this.eval(this.firstChild(node));
        Object val2 = this.eval(JPQLExpressionBuilder.secondChild(node));
        return this.factory.nullIfExpression((Value)val1, (Value)val2);
    }

    private Value getValue(JPQLNode node) {
        if (node.id == 59) {
            return this.getQualifiedIdentifier(this.onlyChild(node));
        }
        return this.getValue(node, 1);
    }

    private Path newPath(Value val, ClassMetaData meta) {
        Path path;
        Path path2 = path = val == null ? this.factory.newPath() : this.factory.newPath(val);
        if (meta != null) {
            path.setMetaData(meta);
        }
        return path;
    }

    private Value getValue(JPQLNode node, int handleVar) {
        Value val = (Value)this.eval(node);
        if (!val.isVariable()) {
            return val;
        }
        if (handleVar == 1 && !(val instanceof Path)) {
            return this.newPath(val, val.getMetaData());
        }
        if (handleVar == 2) {
            throw this.parseException(0, "unexpected-var", new Object[]{node.text}, null);
        }
        return val;
    }

    private Context ctx() {
        return this.contexts.peek();
    }

    private JPQLNode root() {
        return this.ctx().parsed.root;
    }

    private ClassMetaData getMetaDataForAlias(String alias) {
        for (int i = this.contexts.size() - 1; i >= 0; --i) {
            Context context = (Context)this.contexts.get(i);
            if (!alias.equalsIgnoreCase(context.schemaAlias)) continue;
            return context.meta;
        }
        return null;
    }

    @Override
    protected void addSchemaToContext(String id, ClassMetaData meta) {
        this.ctx().addSchema(id.toLowerCase(), meta);
    }

    @Override
    protected void addVariableToContext(String id, Value var) {
        this.ctx().addVariable(id, var);
    }

    @Override
    protected Value getVariable(String var) {
        Context c = this.ctx();
        Value v = c.getVariable(var);
        if (v != null) {
            return v;
        }
        if (c.getParent() != null) {
            return c.getParent().findVariable(var);
        }
        return null;
    }

    private JPQLNode onlyChild(JPQLNode node) throws UserException {
        JPQLNode child = this.firstChild(node);
        if (node.children.length > 1) {
            throw this.parseException(0, "multi-children", new Object[]{node, Arrays.asList(node.children)}, null);
        }
        return child;
    }

    private JPQLNode left(JPQLNode node) {
        return this.child(node, 0, 2);
    }

    private JPQLNode right(JPQLNode node) {
        return this.child(node, 1, 2);
    }

    private JPQLNode child(JPQLNode node, int childNum, int assertCount) {
        if (node.children.length != assertCount) {
            throw this.parseException(0, "wrong-child-count", new Object[]{assertCount, node, Arrays.asList(node.children)}, null);
        }
        return node.children[childNum];
    }

    private JPQLNode firstChild(JPQLNode node) {
        if (node.children == null || node.children.length == 0) {
            throw this.parseException(0, "no-children", new Object[]{node}, null);
        }
        return node.children[0];
    }

    private static JPQLNode secondChild(JPQLNode node) {
        return node.children[1];
    }

    private static JPQLNode thirdChild(JPQLNode node) {
        return node.children[2];
    }

    private static JPQLNode lastChild(JPQLNode node) {
        return JPQLExpressionBuilder.lastChild(node, 0);
    }

    private static JPQLNode lastChild(JPQLNode node, int fromLast) {
        return node.children[node.children.length - (1 + fromLast)];
    }

    private void validateParameters() {
        if (this.parameterTypes == null || this.parameterTypes.isEmpty()) {
            return;
        }
        boolean numericParms = false;
        boolean namedParms = false;
        for (Object key : this.parameterTypes.keySet()) {
            if (key instanceof Number) {
                if (namedParms) {
                    throw new UserException(_loc.get("mixed-parameter-types", this.resolver.getQueryContext().getQueryString(), this.parameterTypes.keySet().toString()));
                }
                numericParms = true;
                continue;
            }
            if (numericParms) {
                throw new UserException(_loc.get("mixed-parameter-types", this.resolver.getQueryContext().getQueryString(), this.parameterTypes.keySet().toString()));
            }
            namedParms = true;
        }
        if (numericParms && !this.parameterTypes.keySet().contains(1)) {
            throw new UserException(_loc.get("missing-positional-parameter", this.resolver.getQueryContext().getQueryString(), this.parameterTypes.keySet().toString()));
        }
    }

    private DateTimeExtractField resolveDateTimeExtractFieldType(JPQLNode node) {
        String value = node.text;
        try {
            return DateTimeExtractField.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static class ParsedJPQL
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient JPQLNode root;
        private final String query;
        private Class<?> _candidateType;

        ParsedJPQL(String jpql) {
            this(jpql, ParsedJPQL.parse(jpql));
        }

        ParsedJPQL(String query, JPQLNode root) {
            this.root = root;
            this.query = query;
        }

        private static JPQLNode parse(String jpql) {
            if (jpql == null) {
                jpql = "";
            }
            try {
                return (JPQLNode)new JPQL(jpql).parseQuery();
            }
            catch (Error e) {
                throw new UserException(_loc.get("parse-error", new Object[]{e.toString(), jpql}));
            }
        }

        void populate(ExpressionStoreQuery query) {
            QueryContext ctx = query.getContext();
            if (ctx.getCandidateType() == null) {
                if (this._candidateType == null) {
                    this._candidateType = new JPQLExpressionBuilder(null, query, this).getCandidateType();
                }
                ctx.setCandidateType(this._candidateType, true);
            }
        }

        public Class<?> getCandidateType() {
            return this._candidateType;
        }

        public String toString() {
            return this.query;
        }
    }

    protected static abstract class JPQLNode
    implements Node,
    Serializable {
        private static final long serialVersionUID = 1L;
        final int id;
        final JPQL parser;
        JPQLNode parent;
        JPQLNode[] children;
        String text;
        boolean not = false;
        boolean inEnumPath = false;

        public JPQLNode(JPQL parser, int id) {
            this.id = id;
            this.parser = parser;
            this.inEnumPath = parser.inEnumPath;
        }

        @Override
        public void jjtOpen() {
        }

        @Override
        public void jjtClose() {
        }

        JPQLNode[] findChildrenByID(int id) {
            LinkedHashSet<JPQLNode> set = new LinkedHashSet<JPQLNode>();
            this.findChildrenByID(id, set);
            return set.toArray(new JPQLNode[set.size()]);
        }

        private void findChildrenByID(int id, Collection<JPQLNode> set) {
            for (int i = 0; this.children != null && i < this.children.length; ++i) {
                if (this.children[i].id == id) {
                    set.add(this.children[i]);
                }
                this.children[i].findChildrenByID(id, set);
            }
        }

        boolean hasChildID(int id) {
            return this.findChildByID(id, false) != null;
        }

        JPQLNode findChildByID(int id, boolean recurse) {
            for (int i = 0; this.children != null && i < this.children.length; ++i) {
                JPQLNode found;
                JPQLNode child = this.children[i];
                if (child.id == id) {
                    return this.children[i];
                }
                if (!recurse || (found = child.findChildByID(id, recurse)) == null) continue;
                return found;
            }
            return null;
        }

        @Override
        public void jjtSetParent(Node parent) {
            this.parent = (JPQLNode)parent;
        }

        @Override
        public Node jjtGetParent() {
            return this.parent;
        }

        @Override
        public void jjtAddChild(Node n, int i) {
            if (this.children == null) {
                this.children = new JPQLNode[i + 1];
            } else if (i >= this.children.length) {
                JPQLNode[] c = new JPQLNode[i + 1];
                System.arraycopy(this.children, 0, c, 0, this.children.length);
                this.children = c;
            }
            this.children[i] = (JPQLNode)n;
        }

        @Override
        public Node jjtGetChild(int i) {
            return this.children[i];
        }

        public int getChildCount() {
            return this.jjtGetNumChildren();
        }

        public JPQLNode getChild(int index) {
            return (JPQLNode)this.jjtGetChild(index);
        }

        public Iterator<JPQLNode> iterator() {
            return Arrays.asList(this.children).iterator();
        }

        @Override
        public int jjtGetNumChildren() {
            return this.children == null ? 0 : this.children.length;
        }

        void setText(String text) {
            this.text = text;
        }

        void setToken(Token t) {
            this.setText(t.image);
        }

        public String toString() {
            return JPQLTreeConstants.jjtNodeName[this.id];
        }

        public String toString(String prefix) {
            return prefix + this.toString();
        }

        public void dump(String prefix) {
            this.dump(System.out, prefix);
        }

        public void dump() {
            this.dump(" ");
        }

        public void dump(PrintStream out, String prefix) {
            this.dump(out, prefix, false);
        }

        public void dump(PrintStream out, String prefix, boolean text) {
            out.println(this.toString(prefix) + (String)(text && this.text != null ? " [" + this.text + "]" : ""));
            if (this.children != null) {
                for (JPQLNode n : this.children) {
                    if (n == null) continue;
                    n.dump(out, prefix + " ", text);
                }
            }
        }
    }
}

