/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.executable.ExecutableType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.jsr.BootstrapConfigurationImpl;
import org.apache.bval.jsr.ConfigurationImpl;
import org.apache.bval.jsr.util.IOs;
import org.apache.bval.jsr.xml.DefaultValidatedExecutableTypesType;
import org.apache.bval.jsr.xml.ExecutableValidationType;
import org.apache.bval.jsr.xml.PropertyType;
import org.apache.bval.jsr.xml.ValidationConfigType;
import org.apache.bval.jsr.xml.ValidationParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationParser$parseXmlConfig$$Ljava_lang_String$_ACTION;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.xml.sax.SAXException;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.1.xsd";
    private static final Logger log;
    private static final ConcurrentMap<String, Schema> SCHEMA_CACHE;
    private ValidationConfigType xmlConfig;
    private BootstrapConfigurationImpl bootstrap;
    private Collection<ValidationException> exceptions = new CopyOnWriteArrayList<ValidationException>();

    private ValidationParser() {
    }

    public void applyConfigWithInstantiation(ConfigurationImpl targetConfig) {
        if (this.xmlConfig == null) {
            return;
        }
        this.applyProviderClass(this.xmlConfig, targetConfig);
        this.applyMessageInterpolator(this.xmlConfig, targetConfig);
        this.applyTraversableResolver(this.xmlConfig, targetConfig);
        this.applyConstraintFactory(this.xmlConfig, targetConfig);
        this.applyParameterNameProvider(this.xmlConfig, targetConfig);
        ValidationParser.applyMappingStreams(this.xmlConfig, targetConfig);
        ValidationParser.applyProperties(this.xmlConfig, targetConfig);
    }

    public BootstrapConfigurationImpl getBootstrap() {
        return this.bootstrap;
    }

    public static String getValidationXmlFile(String file) {
        if (file == null) {
            return DEFAULT_VALIDATION_XML_FILE;
        }
        return file;
    }

    public static ValidationParser processValidationConfig(String file, ConfigurationImpl targetConfig, boolean ignoreXml) {
        ValidationParser parser = new ValidationParser();
        if (!ignoreXml) {
            parser.xmlConfig = ValidationParser.parseXmlConfig(file);
        }
        if (parser.xmlConfig != null) {
            if (parser.xmlConfig.getExecutableValidation() == null) {
                ExecutableValidationType value = new ExecutableValidationType();
                value.setEnabled(true);
                DefaultValidatedExecutableTypesType defaultValidatedExecutableTypes = new DefaultValidatedExecutableTypesType();
                value.setDefaultValidatedExecutableTypes(defaultValidatedExecutableTypes);
                defaultValidatedExecutableTypes.getExecutableType().add(ExecutableType.CONSTRUCTORS);
                defaultValidatedExecutableTypes.getExecutableType().add(ExecutableType.NON_GETTER_METHODS);
                parser.xmlConfig.setExecutableValidation(value);
            }
            ValidationParser.applySimpleConfig(parser.xmlConfig, targetConfig);
            parser.bootstrap = new BootstrapConfigurationImpl(parser.xmlConfig.getDefaultProvider(), parser.xmlConfig.getConstraintValidatorFactory(), parser.xmlConfig.getMessageInterpolator(), parser.xmlConfig.getTraversableResolver(), parser.xmlConfig.getParameterNameProvider(), new CopyOnWriteArraySet<String>(parser.xmlConfig.getConstraintMapping()), parser.xmlConfig.getExecutableValidation().getEnabled(), new CopyOnWriteArraySet<ExecutableType>(targetConfig.getExecutableValidation()), ValidationParser.toMap(parser.xmlConfig.getProperty()));
        } else {
            CopyOnWriteArraySet<ExecutableType> executableTypes = new CopyOnWriteArraySet<ExecutableType>();
            executableTypes.add(ExecutableType.CONSTRUCTORS);
            executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            parser.bootstrap = new BootstrapConfigurationImpl(null, null, null, null, null, new CopyOnWriteArraySet<String>(), true, executableTypes, new HashMap<String, String>());
            targetConfig.setExecutableValidation(executableTypes);
        }
        return parser;
    }

    private static Map<String, String> toMap(List<PropertyType> property) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (property != null) {
            for (PropertyType p : property) {
                map.put(p.getName(), p.getValue());
            }
        }
        return map;
    }

    @Privileged
    private static ValidationConfigType parseXmlConfig(String string) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationParser.__privileged_parseXmlConfig(string);
        }
        return (ValidationConfigType)AccessController.doPrivileged(new ValidationParser$parseXmlConfig$$Ljava_lang_String$_ACTION(string));
    }

    static /* synthetic */ ValidationConfigType __privileged_access$0(String string) {
        return ValidationParser.__privileged_parseXmlConfig(string);
    }

    private static ValidationConfigType __privileged_parseXmlConfig(String validationXmlFile) {
        InputStream inputStream = null;
        try {
            inputStream = ValidationParser.getInputStream(ValidationParser.getValidationXmlFile(validationXmlFile));
            if (inputStream == null) {
                log.log(Level.FINEST, String.format("No %s found. Using annotation based configuration only.", validationXmlFile));
                ValidationConfigType validationConfigType = null;
                return validationConfigType;
            }
            log.log(Level.FINEST, String.format("%s found.", validationXmlFile));
            Schema schema = ValidationParser.getSchema();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            ValidationConfigType validationConfigType = (ValidationConfigType)root.getValue();
            return validationConfigType;
        }
        catch (JAXBException e) {
            throw new ValidationException("Unable to parse " + validationXmlFile, e);
        }
        catch (IOException e) {
            throw new ValidationException("Unable to parse " + validationXmlFile, e);
        }
        finally {
            IOs.closeQuietly(inputStream);
        }
    }

    protected static InputStream getInputStream(String path) throws IOException {
        Enumeration<URL> urls;
        ClassLoader loader = ValidationParser.org_apache_bval_util_reflection_Reflection$$getClassLoader(ValidationParser.class);
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream != null && (urls = loader.getResources(path)).hasMoreElements()) {
            String url = urls.nextElement().toString();
            while (urls.hasMoreElements()) {
                if (url.equals(urls.nextElement().toString())) continue;
                throw new ValidationException("More than one " + path + " is found in the classpath");
            }
        }
        return IOs.convertToMarkableInputStream(inputStream);
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new ValidationParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$1(Class clazz) {
        return ValidationParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    private static Schema getSchema() {
        return ValidationParser.getSchema(VALIDATION_CONFIGURATION_XSD);
    }

    static Schema getSchema(String xsd) {
        Schema schema = (Schema)SCHEMA_CACHE.get(xsd);
        if (schema != null) {
            return schema;
        }
        ClassLoader loader = ValidationParser.org_apache_bval_util_reflection_Reflection$$getClassLoader(ValidationParser.class);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = loader.getResource(xsd);
        try {
            Schema s = sf.newSchema(schemaUrl);
            Schema old = SCHEMA_CACHE.putIfAbsent(xsd, s);
            if (old != null) {
                s = old;
            }
            return s;
        }
        catch (SAXException e) {
            log.log(Level.WARNING, String.format("Unable to parse schema: %s", xsd), e);
            return null;
        }
    }

    public static void applySimpleConfig(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        ValidationParser.applyExecutableValidation(xmlConfig, targetConfig);
    }

    private static void applyProperties(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (PropertyType property : xmlConfig.getProperty()) {
            target.addProperty(property.getName(), property.getValue());
        }
    }

    private static void applyExecutableValidation(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        CopyOnWriteArrayList<ExecutableType> executableTypes = new CopyOnWriteArrayList<ExecutableType>();
        if (xmlConfig.getExecutableValidation() != null && xmlConfig.getExecutableValidation().getEnabled() && xmlConfig.getExecutableValidation().getDefaultValidatedExecutableTypes() != null) {
            executableTypes.addAll(xmlConfig.getExecutableValidation().getDefaultValidatedExecutableTypes().getExecutableType());
        }
        if (executableTypes.contains((Object)ExecutableType.ALL)) {
            executableTypes.clear();
            executableTypes.add(ExecutableType.CONSTRUCTORS);
            executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            executableTypes.add(ExecutableType.GETTER_METHODS);
        } else if (executableTypes.contains((Object)ExecutableType.NONE)) {
            executableTypes.clear();
        }
        targetConfig.setExecutableValidation(executableTypes);
    }

    private void applyParameterNameProvider(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        String parameterNameProvider = xmlConfig.getParameterNameProvider();
        if (targetConfig.getParameterNameProvider() == targetConfig.getDefaultParameterNameProvider() && parameterNameProvider != null) {
            Class<?> loaded = this.loadClass(parameterNameProvider);
            if (loaded == null) {
                log.log(Level.SEVERE, "Can't load " + parameterNameProvider);
            } else {
                Class<ParameterNameProvider> clazz = loaded.asSubclass(ParameterNameProvider.class);
                targetConfig.parameterNameProviderClass(clazz);
                log.log(Level.INFO, String.format("Using %s as validation provider.", parameterNameProvider));
            }
        }
    }

    private void applyProviderClass(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String providerClassName = xmlConfig.getDefaultProvider();
        if (providerClassName != null) {
            Class<?> clazz = this.loadClass(providerClassName);
            target.setProviderClass(clazz);
            log.log(Level.INFO, String.format("Using %s as validation provider.", providerClassName));
        }
    }

    private void applyMessageInterpolator(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String messageInterpolatorClass = xmlConfig.getMessageInterpolator();
        if (target.getMessageInterpolator() == target.getDefaultMessageInterpolator() && messageInterpolatorClass != null) {
            Class<MessageInterpolator> clazz = this.loadClass(messageInterpolatorClass);
            target.messageInterpolatorClass(clazz);
            log.log(Level.INFO, String.format("Using %s as message interpolator.", messageInterpolatorClass));
        }
    }

    private void applyTraversableResolver(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String traversableResolverClass = xmlConfig.getTraversableResolver();
        if (target.getTraversableResolver() == target.getDefaultTraversableResolver() && traversableResolverClass != null) {
            Class<TraversableResolver> clazz = this.loadClass(traversableResolverClass);
            target.traversableResolverClass(clazz);
            log.log(Level.INFO, String.format("Using %s as traversable resolver.", traversableResolverClass));
        }
    }

    private void applyConstraintFactory(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String constraintFactoryClass = xmlConfig.getConstraintValidatorFactory();
        if (target.getConstraintValidatorFactory() == target.getDefaultConstraintValidatorFactory() && constraintFactoryClass != null) {
            Class<ConstraintValidatorFactory> clazz = this.loadClass(constraintFactoryClass);
            target.constraintValidatorFactoryClass(clazz);
            log.log(Level.INFO, String.format("Using %s as constraint factory.", constraintFactoryClass));
        }
    }

    private static void applyMappingStreams(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (String rawMappingFileName : xmlConfig.getConstraintMapping()) {
            InputStream in;
            String mappingFileName = rawMappingFileName;
            if (mappingFileName.startsWith("/")) {
                mappingFileName = mappingFileName.substring(1);
            }
            log.log(Level.FINEST, String.format("Trying to open input stream for %s", mappingFileName));
            try {
                in = ValidationParser.getInputStream(mappingFileName);
                if (in == null) {
                    throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName);
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName, e);
            }
            target.addMapping(in);
        }
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = ValidationParser.org_apache_bval_util_reflection_Reflection$$getClassLoader(ValidationParser.class);
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            this.exceptions.add(new ValidationException("Unable to load class: " + className, ex));
            return null;
        }
    }

    public void ensureValidatorFactoryCanBeBuilt() {
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.iterator().next();
        }
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(ValidationParser.class.getName());
        SCHEMA_CACHE = new ConcurrentHashMap<String, Schema>(1);
    }

    static {
        ValidationParser.__privileged_clinit0();
    }
}

