/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

public class DecimalMaxValidatorForString
implements ConstraintValidator<DecimalMax, String> {
    private BigDecimal maxValue;

    @Override
    public void initialize(DecimalMax annotation) {
        try {
            this.maxValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(this.maxValue) != 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

