/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import org.apache.xbean.asm7.ClassReader;
import org.apache.xbean.asm7.ClassVisitor;
import org.apache.xbean.asm7.ClassWriter;
import serp.bytecode.BCClass;

public final class AsmAdaptor {
    private static final boolean USE_ASM = System.getProperty("java.version").compareTo("1.6") > 0;
    private static final int Java7_MajorVersion = 51;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(BCClass bc) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write();
        } else {
            String name = bc.getName();
            int dotIndex = name.lastIndexOf(46) + 1;
            name = name.substring(dotIndex);
            Class type = bc.getType();
            FileOutputStream out = new FileOutputStream(URLDecoder.decode(type.getResource(name + ".class").getFile()));
            try {
                AsmAdaptor.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    public static void write(BCClass bc, File outFile) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write(outFile);
        } else {
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                AsmAdaptor.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    public static byte[] toByteArray(BCClass bc, byte[] returnBytes) throws IOException {
        if (bc.getMajorVersion() >= 51) {
            returnBytes = AsmAdaptor.toJava7ByteArray(bc, returnBytes);
        }
        return returnBytes;
    }

    private static void writeJava7(BCClass bc, OutputStream out) throws IOException {
        byte[] java7Bytes = AsmAdaptor.toJava7ByteArray(bc, bc.toByteArray());
        out.write(java7Bytes);
    }

    private static byte[] toJava7ByteArray(BCClass bc, byte[] classBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(classBytes);
        BufferedInputStream bis = new BufferedInputStream(bais);
        BCClassWriter cw = new BCClassWriter(2, bc.getClassLoader());
        ClassReader cr = new ClassReader((InputStream)bis);
        cr.accept((ClassVisitor)cw, 0);
        return cw.toByteArray();
    }

    public static boolean use() {
        return USE_ASM;
    }

    public static boolean isEnhanced(byte[] b) {
        if (b == null) {
            return false;
        }
        ClassReader cr = new ClassReader(b);
        try {
            cr.accept(new ClassVisitor(458752){

                public void visit(int i, int i1, String name, String s, String parent, String[] interfaces) {
                    boolean enhanced;
                    boolean bl = enhanced = interfaces != null && interfaces.length > 0 && Arrays.asList(interfaces).contains("org/apache/openjpa/enhance/PersistenceCapable");
                    if (!(enhanced || name == null || parent == null || "java/lang/Object".equals(parent) || name.equals(parent))) {
                        enhanced = AsmAdaptor.isEnhanced(AsmAdaptor.bytes(parent));
                    }
                    throw new EnhancedStatusException(enhanced);
                }
            }, 0);
            return false;
        }
        catch (EnhancedStatusException e) {
            return e.status;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] bytes(String type) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(type + ".class");
        if (stream == null) {
            return null;
        }
        try {
            int c;
            byte[] buffer = new byte[1024];
            while ((c = stream.read(buffer)) >= 0) {
                baos.write(buffer, 0, c);
            }
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    private static class EnhancedStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean status;

        private EnhancedStatusException(boolean status) {
            this.status = status;
        }
    }

    private static class BCClassWriter
    extends ClassWriter {
        private final ClassLoader _loader;

        BCClassWriter(int flags, ClassLoader loader) {
            super(flags);
            this._loader = loader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> class2;
            Class<?> class1;
            try {
                class1 = this._loader.loadClass(type1.replace('/', '.'));
                class2 = this._loader.loadClass(type2.replace('/', '.'));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

