/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.persistence.JPAProperties;
import org.apache.openjpa.util.ClassResolver;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo,
SourceTracker {
    public static final String PERSISTENCE_VERSION = "PersistenceVersion";
    private static final Localizer s_loc = Localizer.forPackage(PersistenceUnitInfoImpl.class);
    private String _name;
    private final HashMap<Object, Object> _props = new HashMap();
    private PersistenceUnitTransactionType _transType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private String _providerClassName;
    private List<String> _mappingFileNames;
    private List<String> _entityClassNames;
    private List<URL> _jarFiles;
    private List<String> _jarFileNames;
    private String _jtaDataSourceName;
    private DataSource _jtaDataSource;
    private String _nonJtaDataSourceName;
    private DataSource _nonJtaDataSource;
    private boolean _excludeUnlisted;
    private URL _persistenceXmlFile;
    private String _schemaVersion = "1.0";
    private ValidationMode _validationMode;
    private SharedCacheMode _sharedCacheMode;
    private URL _root;

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        return AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction())));
    }

    @Override
    public String getPersistenceUnitName() {
        return this._name;
    }

    public void setPersistenceUnitName(String emName) {
        this._name = emName;
    }

    @Override
    public String getPersistenceProviderClassName() {
        return this._providerClassName;
    }

    public void setPersistenceProviderClassName(String providerClassName) {
        this._providerClassName = providerClassName;
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this._transType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transType) {
        this._transType = transType;
    }

    public String getJtaDataSourceName() {
        return this._jtaDataSourceName;
    }

    public void setJtaDataSourceName(String jta) {
        this._jtaDataSourceName = jta;
        if (jta != null) {
            this._jtaDataSource = null;
        }
    }

    @Override
    public DataSource getJtaDataSource() {
        return this._jtaDataSource;
    }

    public void setJtaDataSource(DataSource ds) {
        this._jtaDataSource = ds;
        if (ds != null) {
            this._jtaDataSourceName = null;
        }
    }

    public String getNonJtaDataSourceName() {
        return this._nonJtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJta) {
        this._nonJtaDataSourceName = nonJta;
        if (nonJta != null) {
            this._nonJtaDataSource = null;
        }
    }

    @Override
    public DataSource getNonJtaDataSource() {
        return this._nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource ds) {
        this._nonJtaDataSource = ds;
        if (ds != null) {
            this._nonJtaDataSourceName = null;
        }
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        return this._root;
    }

    public void setPersistenceUnitRootUrl(URL root) {
        this._root = root;
    }

    @Override
    public boolean excludeUnlistedClasses() {
        return this._excludeUnlisted;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlisted) {
        this._excludeUnlisted = excludeUnlisted;
    }

    @Override
    public List<String> getMappingFileNames() {
        if (this._mappingFileNames == null) {
            return Collections.emptyList();
        }
        return this._mappingFileNames;
    }

    public void addMappingFileName(String name) {
        if (this._mappingFileNames == null) {
            this._mappingFileNames = new ArrayList<String>();
        }
        this._mappingFileNames.add(name);
    }

    @Override
    public List<URL> getJarFileUrls() {
        if (this._jarFiles == null) {
            return Collections.emptyList();
        }
        return this._jarFiles;
    }

    public void addJarFile(URL jar) {
        if (this._jarFiles == null) {
            this._jarFiles = new ArrayList<URL>();
        }
        this._jarFiles.add(jar);
    }

    public void addJarFileName(String name) {
        if (this._jarFileNames == null) {
            this._jarFileNames = new ArrayList<String>();
        }
        this._jarFileNames.add(name);
    }

    public void processJarFileNames() {
        if (this._jarFileNames != null) {
            for (String name : this._jarFileNames) {
                this.validateJarFileName(name);
            }
            this._jarFileNames.clear();
        }
    }

    public void validateJarFileName(String name) {
        ClassLoader contextClassLoader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        MultiClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        loader.addClassLoader(contextClassLoader);
        loader.addClassLoader(this.getClass().getClassLoader());
        loader.addClassLoader(MultiClassLoader.THREAD_LOADER);
        URL url = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, name));
        if (url != null) {
            this.addJarFile(url);
            return;
        }
        String classPath = null;
        if (contextClassLoader instanceof MultiClassLoader) {
            for (ClassLoader classLoader : ((MultiClassLoader)contextClassLoader).getClassLoaders()) {
                try {
                    Method getClassPathMethod = classLoader.getClass().getMethod("getClasspath", new Class[0]);
                    classPath = (String)getClassPathMethod.invoke((Object)classLoader, new Object[0]);
                    if (classPath == null) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (classPath == null) {
            classPath = AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("java.class.path"));
        }
        String[] cp = classPath.split(J2DoPrivHelper.getPathSeparator());
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].equals(name) && !cp[i].endsWith(File.separatorChar + name)) continue;
            try {
                this.addJarFile(AccessController.doPrivileged(J2DoPrivHelper.toURLAction(new File(cp[i]))));
                return;
            }
            catch (PrivilegedActionException pae) {
                break;
            }
            catch (MalformedURLException mue) {
                break;
            }
        }
        throw new IllegalArgumentException(s_loc.get("bad-jar-name", name).getMessage());
    }

    @Override
    public List<String> getManagedClassNames() {
        if (this._entityClassNames == null) {
            return Collections.emptyList();
        }
        return this._entityClassNames;
    }

    public void addManagedClassName(String name) {
        if (this._entityClassNames == null) {
            this._entityClassNames = new ArrayList<String>();
        }
        this._entityClassNames.add(name);
    }

    @Override
    public Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this._props);
        return copy;
    }

    public void setProperty(String key, String value) {
        this._props.put(key, value);
    }

    @Override
    public void addTransformer(ClassTransformer transformer) {
        throw new UnsupportedOperationException();
    }

    public URL getPersistenceXmlFileUrl() {
        return this._persistenceXmlFile;
    }

    public void setPersistenceXmlFileUrl(URL url) {
        this._persistenceXmlFile = url;
    }

    public void fromUserProperties(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry o : map.entrySet()) {
            Object key = o.getKey();
            Object val = o.getValue();
            if ("javax.persistence.provider".equals(key)) {
                this.setPersistenceProviderClassName((String)val);
                continue;
            }
            if ("javax.persistence.transactionType".equals(key)) {
                this.setTransactionType(JPAProperties.getEnumValue(PersistenceUnitTransactionType.class, val));
                continue;
            }
            if ("javax.persistence.jtaDataSource".equals(key)) {
                if (val instanceof String) {
                    this.setJtaDataSourceName((String)val);
                    continue;
                }
                this.setJtaDataSource((DataSource)val);
                continue;
            }
            if ("javax.persistence.nonJtaDataSource".equals(key)) {
                if (val instanceof String) {
                    this.setNonJtaDataSourceName((String)val);
                    continue;
                }
                this.setNonJtaDataSource((DataSource)val);
                continue;
            }
            if ("javax.persistence.validation.mode".equals(key)) {
                this.setValidationMode(JPAProperties.getEnumValue(ValidationMode.class, val));
                continue;
            }
            if ("javax.persistence.sharedCache.mode".equals(key)) {
                this.setSharedCacheMode(JPAProperties.getEnumValue(SharedCacheMode.class, val));
                continue;
            }
            this._props.put(key, val);
        }
    }

    public Map toOpenJPAProperties() {
        return PersistenceUnitInfoImpl.toOpenJPAProperties(this);
    }

    public static Map toOpenJPAProperties(PersistenceUnitInfo info) {
        Properties props;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        HashSet<String> added = new HashSet<String>();
        if (info.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "TransactionMode", "managed");
        }
        boolean hasJta = false;
        DataSource ds = info.getJtaDataSource();
        if (ds != null) {
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "ConnectionFactory", ds);
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "ConnectionFactoryMode", "managed");
            hasJta = true;
        } else if (info instanceof PersistenceUnitInfoImpl && ((PersistenceUnitInfoImpl)info).getJtaDataSourceName() != null) {
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "ConnectionFactoryName", ((PersistenceUnitInfoImpl)info).getJtaDataSourceName());
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "ConnectionFactoryMode", "managed");
            hasJta = true;
        }
        ds = info.getNonJtaDataSource();
        if (ds != null) {
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, hasJta ? "ConnectionFactory2" : "ConnectionFactory", ds);
        } else if (info instanceof PersistenceUnitInfoImpl && ((PersistenceUnitInfoImpl)info).getNonJtaDataSourceName() != null) {
            String nonJtaName = ((PersistenceUnitInfoImpl)info).getNonJtaDataSourceName();
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, hasJta ? "ConnectionFactory2Name" : "ConnectionFactoryName", nonJtaName);
        }
        if (info.getClassLoader() != null) {
            PersistenceUnitInfoImpl.replaceAsOpenJPAProperty(map, added, "ClassResolver", new ClassResolverImpl(info.getClassLoader()));
        }
        if ((props = info.getProperties()) != null) {
            for (String key : added) {
                if (!Configurations.containsProperty(key, (Map)props)) continue;
                Configurations.removeProperty(key, props);
            }
            map.putAll(props);
            map.remove("ClassTransformerOptions");
        }
        if (!Configurations.containsProperty("Id", map)) {
            map.put("openjpa.Id", info.getPersistenceUnitName());
        }
        Properties metaFactoryProps = new Properties();
        if (info.getManagedClassNames() != null && !info.getManagedClassNames().isEmpty()) {
            StringBuilder types = new StringBuilder();
            for (String type : info.getManagedClassNames()) {
                if (types.length() > 0) {
                    types.append(';');
                }
                types.append(type);
            }
            metaFactoryProps.put("Types", types.toString());
        }
        if (info.getJarFileUrls() != null && !info.getJarFileUrls().isEmpty() || !info.excludeUnlistedClasses() && info.getPersistenceUnitRootUrl() != null) {
            StringBuilder jars = new StringBuilder();
            String file = null;
            if (!info.excludeUnlistedClasses() && info.getPersistenceUnitRootUrl() != null) {
                URL url = info.getPersistenceUnitRootUrl();
                if ("file".equals(url.getProtocol())) {
                    file = URLDecoder.decode(url.getPath());
                } else {
                    jars.append(url);
                }
            }
            for (URL jar : info.getJarFileUrls()) {
                if (jars.length() > 0) {
                    jars.append(';');
                }
                jars.append(jar);
            }
            if (file != null) {
                metaFactoryProps.put("Files", file);
            }
            if (jars.length() != 0) {
                metaFactoryProps.put("URLs", jars.toString());
            }
        }
        if (info.getMappingFileNames() != null && !info.getMappingFileNames().isEmpty()) {
            StringBuilder rsrcs = new StringBuilder();
            for (String rsrc : info.getMappingFileNames()) {
                if (rsrcs.length() > 0) {
                    rsrcs.append(';');
                }
                rsrcs.append(rsrc);
            }
            metaFactoryProps.put("Resources", rsrcs.toString());
        }
        if (!metaFactoryProps.isEmpty()) {
            String key;
            key = ProductDerivations.getConfigurationKey("MetaDataFactory", map);
            map.put(key, Configurations.combinePlugins((String)map.get(key), Configurations.serializeProperties(metaFactoryProps)));
        }
        if (info.getPersistenceProviderClassName() != null) {
            map.put("javax.persistence.provider", info.getPersistenceProviderClassName());
        }
        if (info.getValidationMode() != null) {
            map.put("javax.persistence.validation.mode", (Object)info.getValidationMode());
        }
        if (info.getPersistenceXMLSchemaVersion() != null) {
            map.put(PERSISTENCE_VERSION, info.getPersistenceXMLSchemaVersion());
        }
        if (info.getSharedCacheMode() != null) {
            map.put("javax.persistence.sharedCache.mode", (Object)info.getSharedCacheMode());
        }
        return map;
    }

    private static void replaceAsOpenJPAProperty(Map map, Set<String> added, String key, Object val) {
        map.put("openjpa." + key, val);
        added.add(key);
    }

    @Override
    public File getSourceFile() {
        if (this._persistenceXmlFile == null) {
            return null;
        }
        try {
            return new File(this._persistenceXmlFile.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getSourceScope() {
        return null;
    }

    @Override
    public int getSourceType() {
        return 2;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public int getColNumber() {
        return 0;
    }

    @Override
    public String getResourceName() {
        return "PersistenceUnitInfo:" + this._name;
    }

    @Override
    public String getPersistenceXMLSchemaVersion() {
        return this._schemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String version) {
        this._schemaVersion = version;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this._validationMode;
    }

    public void setValidationMode(ValidationMode mode) {
        this._validationMode = mode;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this._sharedCacheMode;
    }

    public void setSharedCacheMode(SharedCacheMode mode) {
        this._sharedCacheMode = mode;
    }

    public static class ClassResolverImpl
    implements ClassResolver {
        private final ClassLoader _loader;

        public ClassResolverImpl(ClassLoader loader) {
            this._loader = loader;
        }

        public ClassLoader getClassLoader(Class ctx, ClassLoader env) {
            return this._loader;
        }
    }
}

