/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.openjpa.lib.util.ReferenceMap;
import org.apache.openjpa.lib.util.SizedMap;

public class ReferenceHashMap
extends org.apache.commons.collections4.map.ReferenceMap
implements ReferenceMap,
SizedMap {
    private static final long serialVersionUID = 1L;
    private int _maxSize = Integer.MAX_VALUE;

    public ReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType) {
        super(keyType, valueType);
    }

    public ReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType, int capacity, float loadFactor) {
        super(keyType, valueType, capacity, loadFactor);
    }

    @Override
    public int getMaxSize() {
        return this._maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        int n = this._maxSize = maxSize < 0 ? Integer.MAX_VALUE : maxSize;
        if (this._maxSize != Integer.MAX_VALUE) {
            this.removeOverflow(this._maxSize);
        }
    }

    @Override
    public boolean isFull() {
        return this.size() >= this._maxSize;
    }

    @Override
    public void overflowRemoved(Object key, Object value) {
    }

    @Override
    public void valueExpired(Object key) {
    }

    @Override
    public void keyExpired(Object value) {
    }

    @Override
    public void removeExpired() {
        this.purge();
    }

    private void removeOverflow(int maxSize) {
        while (this.size() > maxSize) {
            Object key = this.keySet().iterator().next();
            this.overflowRemoved(key, this.remove(key));
        }
    }

    @Override
    protected void addMapping(int hashIndex, int hashCode, Object key, Object value) {
        if (this._maxSize != Integer.MAX_VALUE) {
            this.removeOverflow(this._maxSize - 1);
        }
        super.addMapping(hashIndex, hashCode, key, value);
    }

    @Override
    protected AbstractReferenceMap.ReferenceEntry createEntry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
        return new AccessibleEntry((AbstractReferenceMap)this, next, hashCode, key, value);
    }

    @Override
    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._maxSize);
        super.doWriteObject(out);
    }

    @Override
    protected void doReadObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._maxSize = in.readInt();
        super.doReadObject(in);
    }

    private static class AccessibleEntry
    extends AbstractReferenceMap.ReferenceEntry {
        private final ReferenceHashMap parent;

        public AccessibleEntry(AbstractReferenceMap map, AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
            super(map, next, hashCode, key, value);
            this.parent = (ReferenceHashMap)map;
        }

        public Object key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        public AccessibleEntry nextEntry() {
            return (AccessibleEntry)this.next;
        }

        public void setNextEntry(AccessibleEntry next) {
            this.next = next;
        }

        @Override
        protected void onPurge() {
            if (this.parent.isKeyType(AbstractReferenceMap.ReferenceStrength.HARD)) {
                this.parent.valueExpired(this.key);
            } else if (this.parent.isValueType(AbstractReferenceMap.ReferenceStrength.HARD)) {
                this.parent.keyExpired(this.value);
            }
        }
    }
}

