/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.specs.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.apache.geronimo.osgi.locator.Activator;
import org.apache.geronimo.specs.jpa.PersistenceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PersistenceActivator
extends Activator
implements BundleActivator,
PersistenceProviderResolver {
    public static final String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
    private Map<String, PersistenceProvider> providers = new WeakHashMap<String, PersistenceProvider>();
    private BundleContext ctx = null;
    private ServiceTracker tracker = null;

    @Override
    public void start(BundleContext arg0) throws Exception {
        super.start(arg0);
        this.ctx = arg0;
        PersistenceTracker customizer = new PersistenceTracker(this);
        this.tracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)customizer);
        this.tracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
    }

    @Override
    public void stop(BundleContext arg0) throws Exception {
        this.tracker.close();
        this.tracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
        this.providers.clear();
        this.ctx = null;
        super.stop(arg0);
    }

    @Override
    public void clearCachedProviders() {
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return new ArrayList<PersistenceProvider>(this.providers.values());
    }

    protected PersistenceProvider addProvider(ServiceReference ref) {
        PersistenceProvider provider = (PersistenceProvider)this.ctx.getService(ref);
        String name = (String)ref.getProperty(PERSISTENCE_PROVIDER);
        this.providers.put(name, provider);
        return provider;
    }

    protected void removeProvider(ServiceReference ref) {
        String name = (String)ref.getProperty(PERSISTENCE_PROVIDER);
        this.providers.remove(name);
    }
}

