/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.InvocationTargetException;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityExistsException;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.EntityNotFoundException;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.LockTimeoutException;
import org.apache.openjpa.persistence.NoResultException;
import org.apache.openjpa.persistence.NonUniqueResultException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OptimisticLockException;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.PessimisticLockException;
import org.apache.openjpa.persistence.QueryTimeoutException;
import org.apache.openjpa.persistence.TransactionRequiredException;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.LockException;
import org.apache.openjpa.util.NoTransactionException;
import org.apache.openjpa.util.ObjectExistsException;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.QueryException;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class PersistenceExceptions
extends Exceptions {
    public static final RuntimeExceptionTranslator TRANSLATOR = new RuntimeExceptionTranslator(){

        @Override
        public RuntimeException translate(RuntimeException re) {
            return PersistenceExceptions.toPersistenceException(re);
        }
    };

    public static RuntimeExceptionTranslator getRollbackTranslator(final OpenJPAEntityManager em) {
        return new RuntimeExceptionTranslator(){
            private boolean throwing = false;

            @Override
            public RuntimeException translate(RuntimeException re) {
                RuntimeException ex = PersistenceExceptions.toPersistenceException(re);
                if (!(ex instanceof NonUniqueResultException || ex instanceof NoResultException || ex instanceof LockTimeoutException || ex instanceof QueryTimeoutException || this.throwing)) {
                    try {
                        this.throwing = true;
                        if (em.isOpen() && ((EntityManagerImpl)em).isActive()) {
                            ((EntityManagerImpl)em).setRollbackOnly(ex);
                        }
                    }
                    finally {
                        this.throwing = false;
                    }
                }
                return ex;
            }
        };
    }

    public static RuntimeException toPersistenceException(Throwable t) {
        return (RuntimeException)PersistenceExceptions.translateException(t, true);
    }

    private static Throwable translateException(Throwable t, boolean checked) {
        if (PersistenceExceptions.isPersistenceException(t)) {
            return t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (!(t instanceof OpenJPAException)) {
            if (!checked || t instanceof RuntimeException) {
                return t;
            }
            GeneralException ke = new GeneralException(t.getMessage());
            ke.setStackTrace(t.getStackTrace());
            return ke;
        }
        OpenJPAException ke = (OpenJPAException)t;
        if (ke.getNestedThrowables().length == 1 && PersistenceExceptions.isPersistenceException(ke.getCause())) {
            return ke.getCause();
        }
        if (ke.getType() == 4 && ke.getSubtype() == 4 && ke.getNestedThrowables().length == 1) {
            Throwable e = ke.getCause();
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                return e;
            }
        }
        switch (ke.getType()) {
            case 2: {
                return PersistenceExceptions.translateStoreException(ke);
            }
            case 4: {
                return PersistenceExceptions.translateUserException(ke);
            }
            case 5: {
                return PersistenceExceptions.translateWrappedException(ke);
            }
        }
        return PersistenceExceptions.translateGeneralException(ke);
    }

    private static Throwable translateStoreException(OpenJPAException ke) {
        QueryException queryEx;
        LockException lockEx;
        Throwable cause;
        int subtype = ke.getSubtype();
        String msg = ke.getMessage();
        Throwable[] nested = PersistenceExceptions.getNestedThrowables(ke);
        Object failed = PersistenceExceptions.getFailedObject(ke);
        boolean fatal = ke.isFatal();
        Throwable throwable = cause = ke.getNestedThrowables() != null && ke.getNestedThrowables().length == 1 ? ke.getNestedThrowables()[0] : null;
        javax.persistence.PersistenceException e = subtype == 2 || cause instanceof ObjectNotFoundException ? new EntityNotFoundException(msg, nested, failed, fatal) : (subtype == 3 || cause instanceof OptimisticException ? new OptimisticLockException(msg, nested, failed, fatal) : (subtype == 1 || cause instanceof LockException ? ((lockEx = (LockException)(ke instanceof LockException ? ke : cause)) != null && lockEx.getLockLevel() >= 30 ? (!lockEx.isFatal() ? new LockTimeoutException(msg, nested, failed) : new PessimisticLockException(msg, nested, failed)) : new OptimisticLockException(msg, nested, failed, fatal)) : (subtype == 5 || cause instanceof ObjectExistsException ? new EntityExistsException(msg, nested, failed, fatal) : (subtype == 6 || cause instanceof QueryException ? (!(queryEx = (QueryException)(ke instanceof QueryException ? ke : cause)).isFatal() ? new QueryTimeoutException(msg, nested, failed, false) : new PersistenceException(msg, nested, failed, true)) : new PersistenceException(msg, nested, failed, fatal)))));
        e.setStackTrace(ke.getStackTrace());
        return e;
    }

    private static Exception translateUserException(OpenJPAException ke) {
        Exception e;
        switch (ke.getSubtype()) {
            case 3: {
                e = new TransactionRequiredException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 5: {
                e = new NoResultException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 6: {
                e = new NonUniqueResultException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 2: {
                e = new InvalidStateException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            default: {
                e = PersistenceExceptions.translateCause(ke);
            }
        }
        e.setStackTrace(ke.getStackTrace());
        return e;
    }

    private static Exception translateWrappedException(OpenJPAException ke) {
        Throwable t = ke.getCause();
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return PersistenceExceptions.translateCause(ke);
    }

    private static Exception translateCause(OpenJPAException ke) {
        Throwable cause = ke.getCause();
        if (cause instanceof ObjectNotFoundException) {
            return new EntityNotFoundException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        }
        if (cause instanceof ObjectExistsException) {
            return new EntityExistsException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        }
        if (cause instanceof NoTransactionException) {
            return new TransactionRequiredException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        }
        if (cause instanceof OptimisticException) {
            return new OptimisticLockException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        }
        return new ArgumentException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
    }

    private static Throwable translateGeneralException(OpenJPAException ke) {
        PersistenceException e = new PersistenceException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        e.setStackTrace(ke.getStackTrace());
        return e;
    }

    private static boolean isPersistenceException(Throwable t) {
        return t.getClass().getName().startsWith("org.apache.openjpa.persistence.");
    }

    private static Throwable[] getNestedThrowables(OpenJPAException ke) {
        Throwable[] nested = ke.getNestedThrowables();
        if (nested.length == 0) {
            return nested;
        }
        Throwable[] trans = new Throwable[nested.length];
        for (int i = 0; i < nested.length; ++i) {
            trans[i] = PersistenceExceptions.translateException(nested[i], false);
        }
        return trans;
    }

    private static Object getFailedObject(OpenJPAException ke) {
        Object o = ke.getFailedObject();
        if (o == null) {
            return null;
        }
        if (o instanceof Broker) {
            return JPAFacadeHelper.toEntityManager((Broker)o);
        }
        return JPAFacadeHelper.fromOpenJPAObjectId(o);
    }

    static Throwable getCause(Throwable[] nested) {
        if (nested == null || nested.length == 0) {
            return null;
        }
        return nested[0];
    }
}

