/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.oodt.cas.filemgr.webapp.browser;

//OODT imports
import org.apache.oodt.cas.webcomponents.filemgr.browser.product.ProductRefsBrowser;

//Wicket imports
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;

/**
 * 
 * Page that exposes the underlying {@link ProductRefsBrowser}
 * OODT Wicket component.
 * 
 * @author mattmann
 * @version $Revision$
 * 
 */
public class ProductRefsBrowserPage extends WebPage {

  public ProductRefsBrowserPage(PageParameters parameters) {
    ProductRefsBrowser refsBrowser = new ProductRefsBrowser(
        "product_refs_browser_component", ((FMBrowserApp) getApplication())
            .getFmUrlStr(), parameters.getString("id"));
    add(refsBrowser);
  }

}
