/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.olingo.client.api.communication.request.ODataPayloadManager;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractODataStreamer;
import org.apache.olingo.client.core.communication.request.Wrapper;
import org.apache.olingo.client.core.communication.util.PipedInputStream;
import org.apache.olingo.client.core.communication.util.PipedOutputStream;

public abstract class AbstractODataStreamManager<T extends ODataResponse>
extends AbstractODataStreamer
implements ODataPayloadManager<T> {
    private final PipedInputStream body;
    private final InputStream defaultBody;
    private final Wrapper<Future<HttpResponse>> futureWrap;

    public AbstractODataStreamManager(Wrapper<Future<HttpResponse>> futureWrap) {
        this(futureWrap, new PipedOutputStream(null, 0x400000));
    }

    public AbstractODataStreamManager(Wrapper<Future<HttpResponse>> futureWrap, PipedOutputStream output) {
        super(output);
        this.futureWrap = futureWrap;
        try {
            this.body = new PipedInputStream(this.getBodyStreamWriter(), 0x400000);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.defaultBody = this.body;
    }

    public AbstractODataStreamManager(Wrapper<Future<HttpResponse>> futureWrap, InputStream input) {
        super(null);
        this.futureWrap = futureWrap;
        this.body = null;
        this.defaultBody = input;
    }

    public InputStream getBody() {
        return this.body == null ? this.defaultBody : this.body;
    }

    public void finalizeBody() {
        IOUtils.closeQuietly((OutputStream)this.getBodyStreamWriter());
    }

    protected HttpResponse getHttpResponse(long timeout, TimeUnit unit) {
        try {
            return this.futureWrap.getWrapped().get(timeout, unit);
        }
        catch (Exception e) {
            LOG.error("Failure executing request");
            throw new HttpClientException((Throwable)e);
        }
    }

    protected abstract T getResponse(long var1, TimeUnit var3);

    public final T getResponse() {
        return this.getResponse(30L, TimeUnit.SECONDS);
    }

    public final Future<T> getAsyncResponse() {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return ((Future)AbstractODataStreamManager.this.futureWrap.getWrapped()).cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return ((Future)AbstractODataStreamManager.this.futureWrap.getWrapped()).isCancelled();
            }

            @Override
            public boolean isDone() {
                return ((Future)AbstractODataStreamManager.this.futureWrap.getWrapped()).isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return AbstractODataStreamManager.this.getResponse(0L, TimeUnit.SECONDS);
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return AbstractODataStreamManager.this.getResponse(timeout, unit);
            }
        };
    }
}

