/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public class EdmDuration
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("[-+]?P(?:(\\p{Digit}+)D)?(?:T(?:(\\p{Digit}+)H)?(?:(\\p{Digit}+)M)?(?:(\\p{Digit}+(?:\\.(?:\\p{Digit}+?)0*)?)S)?)?");
    private static final EdmDuration INSTANCE = new EdmDuration();

    public EdmDuration() {
        this.uriPrefix = "duration'";
        this.uriSuffix = "'";
    }

    public static EdmDuration getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return BigDecimal.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches() || matcher.group(1) == null && matcher.group(2) == null && matcher.group(3) == null && matcher.group(4) == null) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        BigDecimal result = (matcher.group(1) == null ? BigDecimal.ZERO : new BigDecimal(matcher.group(1)).multiply(BigDecimal.valueOf(86400L))).add(matcher.group(2) == null ? BigDecimal.ZERO : new BigDecimal(matcher.group(2)).multiply(BigDecimal.valueOf(3600L))).add(matcher.group(3) == null ? BigDecimal.ZERO : new BigDecimal(matcher.group(3)).multiply(BigDecimal.valueOf(60L))).add(matcher.group(4) == null ? BigDecimal.ZERO : new BigDecimal(matcher.group(4)));
        if (result.scale() > (precision == null ? 0 : precision)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
        }
        result = value.charAt(0) == '-' ? result.negate() : result;
        try {
            return EdmDecimal.convertDecimal(result, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        BigInteger minutes;
        BigDecimal valueDecimal;
        if (value instanceof BigDecimal) {
            valueDecimal = (BigDecimal)value;
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            valueDecimal = BigDecimal.valueOf(((Number)value).longValue());
        } else if (value instanceof BigInteger) {
            valueDecimal = new BigDecimal((BigInteger)value);
        } else {
            throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
        }
        if (valueDecimal.scale() > (precision == null ? 0 : precision)) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.");
        }
        StringBuilder result = new StringBuilder();
        if (valueDecimal.signum() == -1) {
            result.append('-');
            valueDecimal = valueDecimal.negate();
        }
        result.append('P');
        BigInteger seconds = valueDecimal.toBigInteger();
        BigInteger days = seconds.divide(BigInteger.valueOf(86400L));
        if (!days.equals(BigInteger.ZERO)) {
            result.append(days.toString());
            result.append('D');
        }
        result.append('T');
        seconds = seconds.subtract(days.multiply(BigInteger.valueOf(86400L)));
        BigInteger hours = seconds.divide(BigInteger.valueOf(3600L));
        if (!hours.equals(BigInteger.ZERO)) {
            result.append(hours.toString());
            result.append('H');
        }
        if (!(minutes = (seconds = seconds.subtract(hours.multiply(BigInteger.valueOf(3600L)))).divide(BigInteger.valueOf(60L))).equals(BigInteger.ZERO)) {
            result.append(minutes.toString());
            result.append('M');
        }
        result.append(valueDecimal.remainder(BigDecimal.valueOf(60L)).toPlainString());
        result.append('S');
        return result.toString();
    }
}

