/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

public class UriTokenizer {
    private final String parseString;
    private int startIndex = 0;
    private int index = 0;
    private int savedStartIndex;
    private int savedIndex;

    public UriTokenizer(String parseString) {
        this.parseString = parseString == null ? "" : parseString;
    }

    public void saveState() {
        this.savedStartIndex = this.startIndex;
        this.savedIndex = this.index;
    }

    public void returnToSavedState() {
        this.startIndex = this.savedStartIndex;
        this.index = this.savedIndex;
    }

    public String getText() {
        return this.parseString.substring(this.startIndex, this.index);
    }

    public boolean next(TokenKind allowedTokenKind) {
        if (allowedTokenKind == null) {
            return false;
        }
        boolean found = false;
        int previousIndex = this.index;
        switch (allowedTokenKind) {
            case EOF: {
                found = this.index >= this.parseString.length();
                break;
            }
            case REF: {
                found = this.nextConstant("$ref");
                break;
            }
            case VALUE: {
                found = this.nextConstant("$value");
                break;
            }
            case COUNT: {
                found = this.nextConstant("$count");
                break;
            }
            case CROSSJOIN: {
                found = this.nextConstant("$crossjoin");
                break;
            }
            case ROOT: {
                found = this.nextConstant("$root");
                break;
            }
            case IT: {
                found = this.nextConstant("$it");
                break;
            }
            case APPLY: {
                found = this.nextConstant("$apply");
                break;
            }
            case EXPAND: {
                found = this.nextConstant("$expand");
                break;
            }
            case FILTER: {
                found = this.nextConstant("$filter");
                break;
            }
            case LEVELS: {
                found = this.nextConstant("$levels");
                break;
            }
            case ORDERBY: {
                found = this.nextConstant("$orderby");
                break;
            }
            case SEARCH: {
                found = this.nextConstant("$search");
                break;
            }
            case SELECT: {
                found = this.nextConstant("$select");
                break;
            }
            case SKIP: {
                found = this.nextConstant("$skip");
                break;
            }
            case TOP: {
                found = this.nextConstant("$top");
                break;
            }
            case ANY: {
                found = this.nextConstant("any");
                break;
            }
            case ALL: {
                found = this.nextConstant("all");
                break;
            }
            case OPEN: {
                found = this.nextCharacter('(');
                break;
            }
            case CLOSE: {
                found = this.nextCharacter(')');
                break;
            }
            case COMMA: {
                found = this.nextCharacter(',');
                break;
            }
            case SEMI: {
                found = this.nextCharacter(';');
                break;
            }
            case COLON: {
                found = this.nextCharacter(':');
                break;
            }
            case DOT: {
                found = this.nextCharacter('.');
                break;
            }
            case SLASH: {
                found = this.nextCharacter('/');
                break;
            }
            case EQ: {
                found = this.nextCharacter('=');
                break;
            }
            case STAR: {
                found = this.nextCharacter('*');
                break;
            }
            case PLUS: {
                found = this.nextCharacter('+');
                break;
            }
            case NULL: {
                found = this.nextConstant("null");
                break;
            }
            case MAX: {
                found = this.nextConstant("max");
                break;
            }
            case AVERAGE: {
                found = this.nextConstant("average");
                break;
            }
            case COUNTDISTINCT: {
                found = this.nextConstant("countdistinct");
                break;
            }
            case IDENTITY: {
                found = this.nextConstant("identity");
                break;
            }
            case MIN: {
                found = this.nextConstant("min");
                break;
            }
            case SUM: {
                found = this.nextConstant("sum");
                break;
            }
            case ROLLUP_ALL: {
                found = this.nextConstant("$all");
                break;
            }
            case ODataIdentifier: {
                found = this.nextODataIdentifier();
                break;
            }
            case QualifiedName: {
                found = this.nextQualifiedName();
                break;
            }
            case ParameterAliasName: {
                found = this.nextParameterAliasName();
                break;
            }
            case BooleanValue: {
                found = this.nextBooleanValue();
                break;
            }
            case StringValue: {
                found = this.nextStringValue();
                break;
            }
            case IntegerValue: {
                found = this.nextIntegerValue(true);
                break;
            }
            case GuidValue: {
                found = this.nextGuidValue();
                break;
            }
            case DateValue: {
                found = this.nextDateValue();
                break;
            }
            case DateTimeOffsetValue: {
                found = this.nextDateTimeOffsetValue();
                break;
            }
            case TimeOfDayValue: {
                found = this.nextTimeOfDayValue();
                break;
            }
            case DecimalValue: {
                found = this.nextDecimalValue();
                break;
            }
            case DoubleValue: {
                found = this.nextDoubleValue();
                break;
            }
            case DurationValue: {
                found = this.nextDurationValue();
                break;
            }
            case BinaryValue: {
                found = this.nextBinaryValue();
                break;
            }
            case EnumValue: {
                found = this.nextEnumValue();
                break;
            }
            case GeographyPoint: {
                found = this.nextGeoPoint(true);
                break;
            }
            case GeometryPoint: {
                found = this.nextGeoPoint(false);
                break;
            }
            case GeographyLineString: {
                found = this.nextGeoLineString(true);
                break;
            }
            case GeometryLineString: {
                found = this.nextGeoLineString(false);
                break;
            }
            case GeographyPolygon: {
                found = this.nextGeoPolygon(true);
                break;
            }
            case GeometryPolygon: {
                found = this.nextGeoPolygon(false);
                break;
            }
            case GeographyMultiPoint: {
                found = this.nextGeoMultiPoint(true);
                break;
            }
            case GeometryMultiPoint: {
                found = this.nextGeoMultiPoint(false);
                break;
            }
            case GeographyMultiLineString: {
                found = this.nextGeoMultiLineString(true);
                break;
            }
            case GeometryMultiLineString: {
                found = this.nextGeoMultiLineString(false);
                break;
            }
            case GeographyMultiPolygon: {
                found = this.nextGeoMultiPolygon(true);
                break;
            }
            case GeometryMultiPolygon: {
                found = this.nextGeoMultiPolygon(false);
                break;
            }
            case GeographyCollection: {
                found = this.nextGeoCollection(true);
                break;
            }
            case GeometryCollection: {
                found = this.nextGeoCollection(false);
                break;
            }
            case jsonArrayOrObject: {
                found = this.nextJsonArrayOrObject();
                break;
            }
            case Word: {
                found = this.nextWord();
                break;
            }
            case Phrase: {
                found = this.nextPhrase();
                break;
            }
            case OrOperatorSearch: {
                found = this.nextBinaryOperator("OR");
                break;
            }
            case AndOperatorSearch: {
                found = this.nextAndOperatorSearch();
                break;
            }
            case NotOperatorSearch: {
                found = this.nextUnaryOperator("NOT");
                break;
            }
            case OrOperator: {
                found = this.nextBinaryOperator("or");
                break;
            }
            case AndOperator: {
                found = this.nextBinaryOperator("and");
                break;
            }
            case EqualsOperator: {
                found = this.nextBinaryOperator("eq");
                break;
            }
            case NotEqualsOperator: {
                found = this.nextBinaryOperator("ne");
                break;
            }
            case GreaterThanOperator: {
                found = this.nextBinaryOperator("gt");
                break;
            }
            case GreaterThanOrEqualsOperator: {
                found = this.nextBinaryOperator("ge");
                break;
            }
            case LessThanOperator: {
                found = this.nextBinaryOperator("lt");
                break;
            }
            case LessThanOrEqualsOperator: {
                found = this.nextBinaryOperator("le");
                break;
            }
            case HasOperator: {
                found = this.nextBinaryOperator("has");
                break;
            }
            case InOperator: {
                found = this.nextBinaryOperator("in");
                break;
            }
            case AddOperator: {
                found = this.nextBinaryOperator("add");
                break;
            }
            case SubOperator: {
                found = this.nextBinaryOperator("sub");
                break;
            }
            case MulOperator: {
                found = this.nextBinaryOperator("mul");
                break;
            }
            case DivOperator: {
                found = this.nextBinaryOperator("div");
                break;
            }
            case ModOperator: {
                found = this.nextBinaryOperator("mod");
                break;
            }
            case MinusOperator: {
                found = this.nextCharacter('-') && !this.nextDigit() && !this.nextConstant("INF");
                break;
            }
            case NotOperator: {
                found = this.nextUnaryOperator("not");
                break;
            }
            case AsOperator: {
                found = this.nextBinaryOperator("as");
                break;
            }
            case FromOperator: {
                found = this.nextBinaryOperator("from");
                break;
            }
            case WithOperator: {
                found = this.nextBinaryOperator("with");
                break;
            }
            case CastMethod: {
                found = this.nextMethod("cast");
                break;
            }
            case CeilingMethod: {
                found = this.nextMethod("ceiling");
                break;
            }
            case ConcatMethod: {
                found = this.nextMethod("concat");
                break;
            }
            case ContainsMethod: {
                found = this.nextMethod("contains");
                break;
            }
            case DateMethod: {
                found = this.nextMethod("date");
                break;
            }
            case DayMethod: {
                found = this.nextMethod("day");
                break;
            }
            case EndswithMethod: {
                found = this.nextMethod("endswith");
                break;
            }
            case FloorMethod: {
                found = this.nextMethod("floor");
                break;
            }
            case FractionalsecondsMethod: {
                found = this.nextMethod("fractionalseconds");
                break;
            }
            case GeoDistanceMethod: {
                found = this.nextMethod("geo.distance");
                break;
            }
            case GeoIntersectsMethod: {
                found = this.nextMethod("geo.intersects");
                break;
            }
            case GeoLengthMethod: {
                found = this.nextMethod("geo.length");
                break;
            }
            case HourMethod: {
                found = this.nextMethod("hour");
                break;
            }
            case IndexofMethod: {
                found = this.nextMethod("indexof");
                break;
            }
            case IsofMethod: {
                found = this.nextMethod("isof");
                break;
            }
            case LengthMethod: {
                found = this.nextMethod("length");
                break;
            }
            case MaxdatetimeMethod: {
                found = this.nextMethod("maxdatetime");
                break;
            }
            case MindatetimeMethod: {
                found = this.nextMethod("mindatetime");
                break;
            }
            case MinuteMethod: {
                found = this.nextMethod("minute");
                break;
            }
            case MonthMethod: {
                found = this.nextMethod("month");
                break;
            }
            case NowMethod: {
                found = this.nextMethod("now");
                break;
            }
            case RoundMethod: {
                found = this.nextMethod("round");
                break;
            }
            case SecondMethod: {
                found = this.nextMethod("second");
                break;
            }
            case StartswithMethod: {
                found = this.nextMethod("startswith");
                break;
            }
            case SubstringMethod: {
                found = this.nextMethod("substring");
                break;
            }
            case TimeMethod: {
                found = this.nextMethod("time");
                break;
            }
            case TolowerMethod: {
                found = this.nextMethod("tolower");
                break;
            }
            case TotaloffsetminutesMethod: {
                found = this.nextMethod("totaloffsetminutes");
                break;
            }
            case TotalsecondsMethod: {
                found = this.nextMethod("totalseconds");
                break;
            }
            case ToupperMethod: {
                found = this.nextMethod("toupper");
                break;
            }
            case TrimMethod: {
                found = this.nextMethod("trim");
                break;
            }
            case YearMethod: {
                found = this.nextMethod("year");
                break;
            }
            case SubstringofMethod: {
                found = this.nextMethod("substringof");
                break;
            }
            case IsDefinedMethod: {
                found = this.nextMethod("isdefined");
                break;
            }
            case AggregateTrafo: {
                found = this.nextMethod("aggregate");
                break;
            }
            case BottomCountTrafo: {
                found = this.nextMethod("bottomcount");
                break;
            }
            case BottomPercentTrafo: {
                found = this.nextMethod("bottompercent");
                break;
            }
            case BottomSumTrafo: {
                found = this.nextMethod("bottomsum");
                break;
            }
            case ComputeTrafo: {
                found = this.nextMethod("compute");
                break;
            }
            case ExpandTrafo: {
                found = this.nextMethod("expand");
                break;
            }
            case FilterTrafo: {
                found = this.nextMethod("filter");
                break;
            }
            case GroupByTrafo: {
                found = this.nextMethod("groupby");
                break;
            }
            case SearchTrafo: {
                found = this.nextMethod("search");
                break;
            }
            case TopCountTrafo: {
                found = this.nextMethod("topcount");
                break;
            }
            case TopPercentTrafo: {
                found = this.nextMethod("toppercent");
                break;
            }
            case TopSumTrafo: {
                found = this.nextMethod("topsum");
                break;
            }
            case RollUpSpec: {
                found = this.nextMethod("rollup");
                break;
            }
            case AscSuffix: {
                found = this.nextSuffix("asc");
                break;
            }
            case DescSuffix: {
                found = this.nextSuffix("desc");
            }
        }
        if (found) {
            this.startIndex = previousIndex;
        } else {
            this.index = previousIndex;
        }
        return found;
    }

    private boolean nextConstant(String constant) {
        if (this.parseString.startsWith(constant, this.index)) {
            this.index += constant.length();
            return true;
        }
        return false;
    }

    private boolean nextConstantIgnoreCase(String constant) {
        int length = constant.length();
        if (this.index + length <= this.parseString.length() && constant.equalsIgnoreCase(this.parseString.substring(this.index, this.index + length))) {
            this.index += length;
            return true;
        }
        return false;
    }

    private boolean nextCharacter(char character) {
        if (this.index < this.parseString.length() && this.parseString.charAt(this.index) == character) {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean nextCharacterRange(char from, char to) {
        char code;
        if (this.index < this.parseString.length() && (code = this.parseString.charAt(this.index)) >= from && code <= to) {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean nextDigit() {
        return this.nextCharacterRange('0', '9');
    }

    private boolean nextHexDigit() {
        return this.nextCharacterRange('0', '9') || this.nextCharacterRange('A', 'F') || this.nextCharacterRange('a', 'f');
    }

    private boolean nextBase64() {
        return this.nextCharacterRange('0', '9') || this.nextCharacterRange('A', 'Z') || this.nextCharacterRange('a', 'z') || this.nextCharacter('-') || this.nextCharacter('_');
    }

    private boolean nextSign() {
        return this.nextCharacter('+') || this.nextCharacter('-');
    }

    boolean nextWhitespace() {
        int count = 0;
        while (this.nextCharacter(' ') || this.nextCharacter('\t')) {
            ++count;
        }
        return count > 0;
    }

    private boolean nextODataIdentifier() {
        int code;
        int count = 0;
        if (this.index < this.parseString.length() && (Character.isUnicodeIdentifierStart(code = this.parseString.codePointAt(this.index)) || code == 95)) {
            ++count;
            this.index += Character.isSupplementaryCodePoint(code) ? 2 : 1;
            while (this.index < this.parseString.length() && count < 128 && Character.isUnicodeIdentifierPart(code = this.parseString.codePointAt(this.index)) && !Character.isISOControl(code)) {
                ++count;
                this.index += Character.isSupplementaryCodePoint(code) ? 2 : 1;
            }
        }
        return count > 0;
    }

    private boolean nextQualifiedName() {
        int lastGoodIndex = this.index;
        if (!this.nextODataIdentifier()) {
            return false;
        }
        int count = 1;
        while (this.nextCharacter('.')) {
            if (this.nextODataIdentifier()) {
                ++count;
                continue;
            }
            --this.index;
            break;
        }
        if (count >= 2) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextBinaryOperator(String operator) {
        return this.nextWhitespace() && this.nextConstant(operator) && this.nextWhitespace();
    }

    private boolean nextUnaryOperator(String operator) {
        return this.nextConstant(operator) && this.nextWhitespace();
    }

    private boolean nextMethod(String methodName) {
        return this.nextConstant(methodName) && this.nextCharacter('(');
    }

    private boolean nextSuffix(String suffixName) {
        return this.nextWhitespace() && this.nextConstant(suffixName);
    }

    private boolean nextParameterAliasName() {
        return this.nextCharacter('@') && this.nextODataIdentifier();
    }

    private boolean nextBooleanValue() {
        return this.nextConstantIgnoreCase("true") || this.nextConstantIgnoreCase("false");
    }

    private boolean nextStringValue() {
        if (!this.nextCharacter('\'')) {
            return false;
        }
        while (this.index < this.parseString.length()) {
            if (this.parseString.charAt(this.index) == '\'') {
                if (this.index + 1 >= this.parseString.length() || this.parseString.charAt(this.index + 1) != '\'') break;
                ++this.index;
            }
            ++this.index;
        }
        return this.nextCharacter('\'');
    }

    private boolean nextIntegerValue(boolean signed) {
        int lastGoodIndex = this.index;
        if (signed) {
            this.nextSign();
        }
        boolean hasDigits = false;
        while (this.nextDigit()) {
            hasDigits = true;
        }
        if (hasDigits) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextDecimalValue() {
        int lastGoodIndex = this.index;
        if (this.nextIntegerValue(true) && this.nextCharacter('.') && this.nextIntegerValue(false)) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextDoubleValue() {
        if (this.nextConstant("NaN") || this.nextConstant("-INF") || this.nextConstant("INF")) {
            return true;
        }
        int lastGoodIndex = this.index;
        if (!this.nextIntegerValue(true)) {
            return false;
        }
        if (this.nextCharacter('.') && !this.nextIntegerValue(false)) {
            this.index = lastGoodIndex;
            return false;
        }
        if ((this.nextCharacter('E') || this.nextCharacter('e')) && this.nextIntegerValue(true)) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextGuidValue() {
        return this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextCharacter('-') && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextCharacter('-') && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextCharacter('-') && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextCharacter('-') && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit();
    }

    private boolean nextYear() {
        this.nextCharacter('-');
        if (this.nextCharacter('0')) {
            return this.nextDigit() && this.nextDigit() && this.nextDigit();
        }
        if (this.nextCharacterRange('1', '9')) {
            int count = 0;
            while (this.nextDigit()) {
                ++count;
            }
            return count >= 3;
        }
        return false;
    }

    private boolean nextDateValue() {
        return this.nextYear() && this.nextCharacter('-') && (this.nextCharacter('0') && this.nextCharacterRange('1', '9') || this.nextCharacter('1') && this.nextCharacterRange('0', '2')) && this.nextCharacter('-') && (this.nextCharacter('0') && this.nextCharacterRange('1', '9') || this.nextCharacterRange('1', '2') && this.nextDigit() || this.nextCharacter('3') && this.nextCharacterRange('0', '1'));
    }

    private boolean nextHours() {
        return this.nextCharacterRange('0', '1') && this.nextDigit() || this.nextCharacter('2') && this.nextCharacterRange('0', '3');
    }

    private boolean nextMinutesOrSeconds() {
        return this.nextCharacterRange('0', '5') && this.nextDigit();
    }

    private boolean nextDateTimeOffsetValue() {
        return this.nextDateValue() && (this.nextCharacter('T') || this.nextCharacter('t')) && this.nextTimeOfDayValue() && (this.nextCharacter('Z') || this.nextCharacter('z') || this.nextSign() && this.nextHours() && this.nextCharacter(':') && this.nextMinutesOrSeconds());
    }

    private boolean nextTimeOfDayValue() {
        if (this.nextHours() && this.nextCharacter(':') && this.nextMinutesOrSeconds()) {
            if (this.nextCharacter(':')) {
                if (this.nextMinutesOrSeconds()) {
                    if (this.nextCharacter('.') && !this.nextIntegerValue(false)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean nextDurationValue() {
        if (this.nextConstantIgnoreCase("duration") && this.nextCharacter('\'')) {
            this.nextSign();
            if (this.nextCharacter('P') || this.nextCharacter('p')) {
                if (this.nextIntegerValue(false) && !this.nextCharacter('D') && !this.nextCharacter('d')) {
                    return false;
                }
                if (this.nextCharacter('T') || this.nextCharacter('t')) {
                    boolean hasNumber = false;
                    if (this.nextIntegerValue(false)) {
                        hasNumber = true;
                        if (this.nextCharacter('H') || this.nextCharacter('h')) {
                            hasNumber = false;
                        }
                    }
                    if (hasNumber || this.nextIntegerValue(false)) {
                        hasNumber = true;
                        if (this.nextCharacter('M') || this.nextCharacter('m')) {
                            hasNumber = false;
                        }
                    }
                    if (hasNumber || this.nextIntegerValue(false)) {
                        if (this.nextCharacter('.') && !this.nextIntegerValue(false)) {
                            return false;
                        }
                        if (!this.nextCharacter('S') && !this.nextCharacter('s')) {
                            return false;
                        }
                    }
                }
                return this.nextCharacter('\'');
            }
        }
        return false;
    }

    private boolean nextBinaryValue() {
        if (this.nextConstantIgnoreCase("binary") && this.nextCharacter('\'')) {
            int lastGoodIndex = this.index;
            while (this.nextBase64() && this.nextBase64() && this.nextBase64() && this.nextBase64()) {
                lastGoodIndex += 4;
            }
            this.index = lastGoodIndex;
            if (this.nextBase64() && this.nextBase64() && (this.nextCharacter('A') || this.nextCharacter('E') || this.nextCharacter('I') || this.nextCharacter('M') || this.nextCharacter('Q') || this.nextCharacter('U') || this.nextCharacter('Y') || this.nextCharacter('c') || this.nextCharacter('g') || this.nextCharacter('k') || this.nextCharacter('o') || this.nextCharacter('s') || this.nextCharacter('w') || this.nextCharacter('0') || this.nextCharacter('4') || this.nextCharacter('8'))) {
                this.nextCharacter('=');
            } else {
                this.index = lastGoodIndex;
                if (this.nextBase64()) {
                    if (this.nextCharacter('A') || this.nextCharacter('Q') || this.nextCharacter('g') || this.nextCharacter('w')) {
                        this.nextConstant("==");
                    } else {
                        return false;
                    }
                }
            }
            return this.nextCharacter('\'');
        }
        return false;
    }

    private boolean nextEnumValue() {
        if (this.nextQualifiedName() && this.nextCharacter('\'')) {
            do {
                if (this.nextODataIdentifier() || this.nextIntegerValue(true)) continue;
                return false;
            } while (this.nextCharacter(','));
            return this.nextCharacter('\'');
        }
        return false;
    }

    private boolean nextGeoPrefix(boolean isGeography) {
        return this.nextConstantIgnoreCase(isGeography ? "geography" : "geometry");
    }

    private boolean nextSrid() {
        int lastGoodIndex = this.index;
        if (this.nextConstantIgnoreCase("SRID") && this.nextCharacter('=') && this.nextDigit()) {
            this.nextDigit();
            this.nextDigit();
            this.nextDigit();
            this.nextDigit();
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextPosition() {
        int lastGoodIndex = this.index;
        if ((this.nextDoubleValue() || this.nextDecimalValue() || this.nextIntegerValue(true)) && this.nextCharacter(' ') && (this.nextDoubleValue() || this.nextDecimalValue() || this.nextIntegerValue(true))) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextPointData() {
        int lastGoodIndex = this.index;
        if (this.nextCharacter('(') && this.nextPosition() && this.nextCharacter(')')) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextPoint() {
        return this.nextConstantIgnoreCase("Point") && this.nextPointData();
    }

    private boolean nextGeoPoint(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextPoint() && this.nextCharacter('\'');
    }

    private boolean nextLineStringData(boolean isRing) {
        int lastGoodIndex = this.index;
        if (this.nextCharacter('(') && this.nextPosition()) {
            String lastPosition;
            int count = 1;
            String firstPosition = isRing ? this.parseString.substring(lastGoodIndex + 1, this.index) : null;
            int positionStart = -1;
            while (this.nextCharacter(',')) {
                positionStart = this.index;
                if (this.nextPosition()) {
                    ++count;
                    continue;
                }
                this.index = lastGoodIndex;
                return false;
            }
            if (count < (isRing ? 4 : 2)) {
                this.index = lastGoodIndex;
                return false;
            }
            if (isRing && !(lastPosition = this.parseString.substring(positionStart, this.index)).equals(firstPosition)) {
                this.index = lastGoodIndex;
                return false;
            }
            if (!this.nextCharacter(')')) {
                this.index = lastGoodIndex;
                return false;
            }
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextLineString() {
        return this.nextConstantIgnoreCase("LineString") && this.nextLineStringData(false);
    }

    private boolean nextGeoLineString(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextLineString() && this.nextCharacter('\'');
    }

    private boolean nextPolygonData() {
        int lastGoodIndex = this.index;
        if (this.nextCharacter('(') && this.nextLineStringData(true)) {
            while (this.nextCharacter(',')) {
                if (this.nextLineStringData(true)) continue;
                this.index = lastGoodIndex;
                return false;
            }
            if (!this.nextCharacter(')')) {
                this.index = lastGoodIndex;
                return false;
            }
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextPolygon() {
        return this.nextConstantIgnoreCase("Polygon") && this.nextPolygonData();
    }

    private boolean nextGeoPolygon(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextPolygon() && this.nextCharacter('\'');
    }

    private boolean nextMultiPoint() {
        if (this.nextConstantIgnoreCase("MultiPoint") && this.nextCharacter('(') && this.nextPointData()) {
            while (this.nextCharacter(',')) {
                if (this.nextPointData()) continue;
                return false;
            }
        }
        return this.nextCharacter(')');
    }

    private boolean nextGeoMultiPoint(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextMultiPoint() && this.nextCharacter('\'');
    }

    private boolean nextMultiLineString() {
        if (this.nextConstantIgnoreCase("MultiLineString") && this.nextCharacter('(') && this.nextLineStringData(false)) {
            while (this.nextCharacter(',')) {
                if (this.nextLineStringData(false)) continue;
                return false;
            }
        }
        return this.nextCharacter(')');
    }

    private boolean nextGeoMultiLineString(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextMultiLineString() && this.nextCharacter('\'');
    }

    private boolean nextMultiPolygon() {
        if (this.nextConstantIgnoreCase("MultiPolygon") && this.nextCharacter('(') && this.nextPolygonData()) {
            while (this.nextCharacter(',')) {
                if (this.nextPolygonData()) continue;
                return false;
            }
        }
        return this.nextCharacter(')');
    }

    private boolean nextGeoMultiPolygon(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextMultiPolygon() && this.nextCharacter('\'');
    }

    private boolean nextGeo() {
        int lastGoodIndex = this.index;
        if (this.nextPoint()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextLineString()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextPolygon()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextMultiPoint()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextMultiLineString()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextMultiPolygon()) {
            return true;
        }
        this.index = lastGoodIndex;
        if (this.nextCollection()) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextCollection() {
        if (this.nextConstantIgnoreCase("Collection") && this.nextCharacter('(') && this.nextGeo()) {
            while (this.nextCharacter(',')) {
                if (this.nextGeo()) continue;
                return false;
            }
        }
        return this.nextCharacter(')');
    }

    private boolean nextGeoCollection(boolean isGeography) {
        return this.nextGeoPrefix(isGeography) && this.nextCharacter('\'') && this.nextSrid() && this.nextCharacter(';') && this.nextCollection() && this.nextCharacter('\'');
    }

    private boolean nextJsonString() {
        int lastGoodIndex = this.index;
        if (this.nextCharacter('\"')) {
            do {
                if (this.nextCharacter('\\')) {
                    if (this.nextCharacter('b') || this.nextCharacter('t') || this.nextCharacter('n') || this.nextCharacter('f') || this.nextCharacter('r') || this.nextCharacter('\"') || this.nextCharacter('/') || this.nextCharacter('\\') || this.nextCharacter('u') && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit() && this.nextHexDigit()) continue;
                    this.index = lastGoodIndex;
                    return false;
                }
                if (this.nextCharacter('\"')) {
                    return true;
                }
                ++this.index;
            } while (this.index < this.parseString.length());
            this.index = lastGoodIndex;
            return false;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextJsonValue() {
        return this.nextConstant("null") || this.nextConstant("true") || this.nextConstant("false") || this.nextDoubleValue() || this.nextDecimalValue() || this.nextIntegerValue(true) || this.nextJsonString() || this.nextJsonArrayOrObject();
    }

    private boolean nextJsonMember() {
        int lastGoodIndex = this.index;
        if (this.nextJsonString() && this.nextCharacter(':') && this.nextJsonValue()) {
            return true;
        }
        this.index = lastGoodIndex;
        return false;
    }

    private boolean nextJsonArrayOrObject() {
        int lastGoodIndex = this.index;
        if (this.nextCharacter('[')) {
            if (this.nextJsonValue()) {
                while (this.nextCharacter(',')) {
                    if (this.nextJsonValue()) continue;
                    this.index = lastGoodIndex;
                    return false;
                }
            }
            if (this.nextCharacter(']')) {
                return true;
            }
            this.index = lastGoodIndex;
            return false;
        }
        if (this.nextCharacter('{')) {
            if (this.nextJsonMember()) {
                while (this.nextCharacter(',')) {
                    if (this.nextJsonMember()) continue;
                    this.index = lastGoodIndex;
                    return false;
                }
            }
            if (this.nextCharacter('}')) {
                return true;
            }
            this.index = lastGoodIndex;
            return false;
        }
        return false;
    }

    private boolean nextAndOperatorSearch() {
        if (this.nextWhitespace()) {
            int lastGoodIndex = this.index;
            if (this.nextUnaryOperator("OR")) {
                return false;
            }
            if (!this.nextUnaryOperator("AND")) {
                this.index = lastGoodIndex;
            }
            return true;
        }
        return false;
    }

    private boolean nextWord() {
        int code;
        int count = 0;
        while (this.index < this.parseString.length() && Character.isUnicodeIdentifierStart(code = this.parseString.codePointAt(this.index))) {
            ++count;
            this.index += Character.isSupplementaryCodePoint(code) ? 2 : 1;
        }
        String word = this.parseString.substring(this.index - count, this.index);
        return count > 0 && !"OR".equals(word) && !"AND".equals(word) && !"NOT".equals(word);
    }

    private boolean nextPhrase() {
        if (this.nextCharacter('\"')) {
            do {
                if (this.nextCharacter('\\')) {
                    if (this.nextCharacter('\\') || this.nextCharacter('\"')) continue;
                    return false;
                }
                if (this.nextCharacter('\"')) {
                    return true;
                }
                ++this.index;
            } while (this.index < this.parseString.length());
            return false;
        }
        return false;
    }

    public static enum TokenKind {
        EOF,
        REF,
        VALUE,
        COUNT,
        CROSSJOIN,
        ROOT,
        IT,
        APPLY,
        EXPAND,
        FILTER,
        LEVELS,
        ORDERBY,
        SEARCH,
        SELECT,
        SKIP,
        TOP,
        ANY,
        ALL,
        OPEN,
        CLOSE,
        COMMA,
        SEMI,
        COLON,
        DOT,
        SLASH,
        EQ,
        STAR,
        PLUS,
        NULL,
        MAX,
        AVERAGE,
        COUNTDISTINCT,
        IDENTITY,
        MIN,
        SUM,
        ROLLUP_ALL,
        ODataIdentifier,
        QualifiedName,
        ParameterAliasName,
        BooleanValue,
        StringValue,
        IntegerValue,
        GuidValue,
        DateValue,
        DateTimeOffsetValue,
        TimeOfDayValue,
        DecimalValue,
        DoubleValue,
        DurationValue,
        BinaryValue,
        EnumValue,
        GeographyPoint,
        GeometryPoint,
        GeographyLineString,
        GeometryLineString,
        GeographyPolygon,
        GeometryPolygon,
        GeographyMultiPoint,
        GeometryMultiPoint,
        GeographyMultiLineString,
        GeometryMultiLineString,
        GeographyMultiPolygon,
        GeometryMultiPolygon,
        GeographyCollection,
        GeometryCollection,
        jsonArrayOrObject,
        Word,
        Phrase,
        OrOperatorSearch,
        AndOperatorSearch,
        NotOperatorSearch,
        OrOperator,
        AndOperator,
        EqualsOperator,
        NotEqualsOperator,
        GreaterThanOperator,
        GreaterThanOrEqualsOperator,
        LessThanOperator,
        LessThanOrEqualsOperator,
        HasOperator,
        InOperator,
        AddOperator,
        SubOperator,
        MulOperator,
        DivOperator,
        ModOperator,
        MinusOperator,
        NotOperator,
        AsOperator,
        FromOperator,
        WithOperator,
        CastMethod,
        CeilingMethod,
        ConcatMethod,
        ContainsMethod,
        DateMethod,
        DayMethod,
        EndswithMethod,
        FloorMethod,
        FractionalsecondsMethod,
        GeoDistanceMethod,
        GeoIntersectsMethod,
        GeoLengthMethod,
        HourMethod,
        IndexofMethod,
        IsofMethod,
        LengthMethod,
        MaxdatetimeMethod,
        MindatetimeMethod,
        MinuteMethod,
        MonthMethod,
        NowMethod,
        RoundMethod,
        SecondMethod,
        StartswithMethod,
        SubstringMethod,
        TimeMethod,
        TolowerMethod,
        TotaloffsetminutesMethod,
        TotalsecondsMethod,
        ToupperMethod,
        TrimMethod,
        YearMethod,
        SubstringofMethod,
        IsDefinedMethod,
        AggregateTrafo,
        BottomCountTrafo,
        BottomPercentTrafo,
        BottomSumTrafo,
        ComputeTrafo,
        ExpandTrafo,
        FilterTrafo,
        GroupByTrafo,
        SearchTrafo,
        TopCountTrafo,
        TopPercentTrafo,
        TopSumTrafo,
        RollUpSpec,
        AscSuffix,
        DescSuffix;

    }
}

