/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequestItem;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.request.batch.ODataSingleRequest;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataStreamManager;
import org.apache.olingo.client.core.communication.request.Wrapper;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchRequest;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.apache.olingo.client.core.communication.request.batch.ODataSingleRequestImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataSingleResponseItem;

public abstract class AbstractBatchManager
extends AbstractODataStreamManager<ODataBatchResponse> {
    protected final boolean continueOnError;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected ODataBatchRequestItem currentItem = null;
    protected final ODataBatchRequest req;

    protected AbstractBatchManager(ODataBatchRequest req, Wrapper<Future<HttpResponse>> futureWrap, boolean continueOnError) {
        super(futureWrap);
        this.req = req;
        this.continueOnError = continueOnError;
    }

    public ODataChangeset addChangeset() {
        this.closeCurrentItem();
        this.streamDashBoundary();
        ODataChangesetResponseItem expectedResItem = new ODataChangesetResponseItem(this.continueOnError);
        ((AbstractODataBatchRequest)this.req).addExpectedResItem(expectedResItem);
        this.currentItem = new ODataChangesetImpl(this.req, expectedResItem);
        return (ODataChangeset)this.currentItem;
    }

    public void addRequest(ODataBatchableRequest request) {
        this.validateSingleRequest(request);
        this.closeCurrentItem();
        this.streamDashBoundary();
        ODataSingleResponseItem expectedResItem = new ODataSingleResponseItem();
        this.currentItem = new ODataSingleRequestImpl(this.req, expectedResItem);
        ((AbstractODataBatchRequest)this.req).addExpectedResItem(expectedResItem);
        ((ODataSingleRequest)this.currentItem).setRequest(request);
    }

    protected void closeCurrentItem() {
        if (this.currentItem != null) {
            this.currentItem.close();
        }
    }

    @Override
    protected ODataBatchResponse getResponse(long timeout, TimeUnit unit) {
        this.closeCurrentItem();
        this.streamCloseDelimiter();
        this.finalizeBody();
        return this.getResponseInstance(timeout, unit);
    }

    protected abstract ODataBatchResponse getResponseInstance(long var1, TimeUnit var3);

    protected void streamDashBoundary() {
        this.newLine();
        this.stream(("--" + ((AbstractODataBatchRequest)this.req).boundary).getBytes(DEFAULT_CHARSET));
        this.newLine();
    }

    protected void streamCloseDelimiter() {
        this.newLine();
        this.stream(("--" + ((AbstractODataBatchRequest)this.req).boundary + "--").getBytes(DEFAULT_CHARSET));
    }

    protected abstract void validateSingleRequest(ODataBatchableRequest var1);
}

