/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlStructuralType;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.commons.core.edm.EdmActionImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.commons.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImpl;
import org.apache.olingo.commons.core.edm.EdmSchemaImpl;
import org.apache.olingo.commons.core.edm.EdmTermImpl;
import org.apache.olingo.commons.core.edm.EdmTypeDefinitionImpl;

public class EdmProviderImpl
extends AbstractEdm {
    private final CsdlEdmProvider provider;
    private final Map<FullQualifiedName, List<CsdlAction>> actionsMap = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, List<CsdlFunction>> functionsMap = Collections.synchronizedMap(new HashMap());
    private List<CsdlSchema> termSchemaDefinition = new ArrayList<CsdlSchema>();

    public EdmProviderImpl(CsdlEdmProvider provider) {
        this.provider = provider;
    }

    public EdmProviderImpl(CsdlEdmProvider provider, List<CsdlSchema> termSchemaDefinition) {
        this.provider = provider;
        this.termSchemaDefinition = termSchemaDefinition;
    }

    @Override
    public EdmEntityContainer createEntityContainer(FullQualifiedName containerName) {
        try {
            CsdlEntityContainerInfo entityContainerInfo = this.provider.getEntityContainerInfo(containerName);
            if (entityContainerInfo != null) {
                this.addAnnotations(this.provider.getEntityContainer(), entityContainerInfo.getContainerName());
                return new EdmEntityContainerImpl(this, this.provider, entityContainerInfo.getContainerName(), this.provider.getEntityContainer());
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlEntityContainer csdlEntityContainer, FullQualifiedName containerName) {
        block0: for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (!annotationGrp.getTarget().equalsIgnoreCase(containerName.getFullQualifiedNameAsString())) continue;
                for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                    if (this.compareAnnotations(csdlEntityContainer.getAnnotations(), annotation)) continue;
                    csdlEntityContainer.getAnnotations().addAll(annotationGrp.getAnnotations());
                }
                continue block0;
            }
        }
    }

    @Override
    public EdmEnumType createEnumType(FullQualifiedName enumName) {
        try {
            CsdlEnumType enumType = this.provider.getEnumType(enumName);
            if (enumType != null) {
                this.addAnnotations(enumType, enumName);
                return new EdmEnumTypeImpl((Edm)this, enumName, enumType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlEnumType enumType, FullQualifiedName enumName) {
        block0: for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (!annotationGrp.getTarget().equalsIgnoreCase(enumName.getFullQualifiedNameAsString())) continue;
                for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                    if (this.compareAnnotations(enumType.getAnnotations(), annotation)) continue;
                    enumType.getAnnotations().addAll(annotationGrp.getAnnotations());
                }
                continue block0;
            }
        }
    }

    @Override
    public EdmTypeDefinition createTypeDefinition(FullQualifiedName typeDefinitionName) {
        try {
            CsdlTypeDefinition typeDefinition = this.provider.getTypeDefinition(typeDefinitionName);
            if (typeDefinition != null) {
                this.addAnnotations(typeDefinition, typeDefinitionName);
                return new EdmTypeDefinitionImpl((Edm)this, typeDefinitionName, typeDefinition);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlTypeDefinition typeDefinition, FullQualifiedName typeDefinitionName) {
        block0: for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (!annotationGrp.getTarget().equalsIgnoreCase(typeDefinitionName.getFullQualifiedNameAsString())) continue;
                for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                    if (this.compareAnnotations(typeDefinition.getAnnotations(), annotation)) continue;
                    typeDefinition.getAnnotations().addAll(annotationGrp.getAnnotations());
                }
                continue block0;
            }
        }
    }

    @Override
    public EdmEntityType createEntityType(FullQualifiedName entityTypeName) {
        try {
            CsdlEntityType entityType = this.provider.getEntityType(entityTypeName);
            if (entityType != null) {
                if (!this.isEntityDerivedFromES()) {
                    this.addAnnotations((CsdlStructuralType)entityType, entityTypeName);
                }
                return new EdmEntityTypeImpl((Edm)this, entityTypeName, entityType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlStructuralType structuralType, FullQualifiedName typeName) {
        boolean isPropAnnotationsCleared = false;
        boolean isNavPropAnnotationsCleared = false;
        for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (annotationGrp.getTarget().equalsIgnoreCase(typeName.getFullQualifiedNameAsString())) {
                    this.addAnnotationsToStructuralTypes(structuralType, annotationGrp);
                    continue;
                }
                this.checkAnnotationsOnStructuralProperties(structuralType, typeName, isPropAnnotationsCleared, annotationGrp);
                this.checkAnnotationsOnStructuralNavProperties(structuralType, typeName, isNavPropAnnotationsCleared, annotationGrp);
                isPropAnnotationsCleared = true;
                isNavPropAnnotationsCleared = true;
            }
        }
    }

    private void checkAnnotationsOnStructuralNavProperties(CsdlStructuralType structuralType, FullQualifiedName typeName, boolean isNavPropAnnotationsCleared, CsdlAnnotations annotationGrp) {
        List navProperties = structuralType.getNavigationProperties();
        for (CsdlNavigationProperty navProperty : navProperties) {
            if (!isNavPropAnnotationsCleared) {
                structuralType.getNavigationProperty(navProperty.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(typeName + "/" + navProperty.getName())) continue;
            this.addAnnotationsToStructuralTypeNavProperties(structuralType, annotationGrp, navProperty);
        }
    }

    private void checkAnnotationsOnStructuralProperties(CsdlStructuralType structuralType, FullQualifiedName typeName, boolean isPropAnnotationsCleared, CsdlAnnotations annotationGrp) {
        List properties = structuralType.getProperties();
        for (CsdlProperty property : properties) {
            if (!isPropAnnotationsCleared) {
                structuralType.getProperty(property.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(typeName.getFullQualifiedNameAsString() + "/" + property.getName())) continue;
            this.addAnnotationsToStructuralTypeProperties(structuralType, annotationGrp, property);
        }
    }

    private void addAnnotationsToStructuralTypeNavProperties(CsdlStructuralType structuralType, CsdlAnnotations annotationGrp, CsdlNavigationProperty navProperty) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(structuralType.getNavigationProperty(navProperty.getName()).getAnnotations(), annotation)) continue;
            structuralType.getNavigationProperty(navProperty.getName()).getAnnotations().add(annotation);
        }
    }

    private void addAnnotationsToStructuralTypeProperties(CsdlStructuralType structuralType, CsdlAnnotations annotationGrp, CsdlProperty property) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(structuralType.getProperty(property.getName()).getAnnotations(), annotation)) continue;
            structuralType.getProperty(property.getName()).getAnnotations().add(annotation);
        }
    }

    private void addAnnotationsToStructuralTypes(CsdlStructuralType structuralType, CsdlAnnotations annotationGrp) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(structuralType.getAnnotations(), annotation)) continue;
            structuralType.getAnnotations().addAll(annotationGrp.getAnnotations());
        }
    }

    @Override
    public EdmComplexType createComplexType(FullQualifiedName complexTypeName) {
        try {
            CsdlComplexType complexType = this.provider.getComplexType(complexTypeName);
            if (complexType != null) {
                if (!this.isComplexDerivedFromES()) {
                    this.addAnnotations((CsdlStructuralType)complexType, complexTypeName);
                }
                return new EdmComplexTypeImpl((Edm)this, complexTypeName, complexType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmAction createBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        try {
            List actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                List parameters;
                CsdlParameter parameter;
                if (!action.isBound() || !bindingParameterTypeName.equals((Object)(parameter = (CsdlParameter)(parameters = action.getParameters()).get(0)).getTypeFQN()) && !this.isEntityPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, parameter) && !this.isComplexPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, parameter, isBindingParameterCollection) || isBindingParameterCollection.booleanValue() != parameter.isCollection()) continue;
                this.addAnnotations(action, actionName);
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlAction action, FullQualifiedName actionName) {
        for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (annotationGrp.getTarget().equalsIgnoreCase(actionName.getFullQualifiedNameAsString())) {
                    this.addAnnotationsToActions(action, annotationGrp);
                    continue;
                }
                this.addAnnotationsToParamsOfActions(action, actionName, annotationGrp);
            }
        }
    }

    private void addAnnotationsToParamsOfActions(CsdlAction action, FullQualifiedName actionName, CsdlAnnotations annotationGrp) {
        List parameters = action.getParameters();
        for (CsdlParameter parameter : parameters) {
            if (!annotationGrp.getTarget().equalsIgnoreCase(actionName.getFullQualifiedNameAsString() + "/" + parameter.getName())) continue;
            for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                if (this.compareAnnotations(action.getParameter(parameter.getName()).getAnnotations(), annotation)) continue;
                action.getParameter(parameter.getName()).getAnnotations().add(annotation);
            }
        }
    }

    private void addAnnotationsToActions(CsdlAction action, CsdlAnnotations annotationGrp) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(action.getAnnotations(), annotation)) continue;
            action.getAnnotations().add(annotation);
        }
    }

    private boolean isComplexPreviousTypeCompatibleToBindingParam(FullQualifiedName bindingParameterTypeName, CsdlParameter parameter, Boolean isBindingParameterCollection) throws ODataException {
        CsdlComplexType complexType = this.provider.getComplexType(bindingParameterTypeName);
        if (this.provider.getEntityType(parameter.getTypeFQN()) == null) {
            return false;
        }
        List properties = this.provider.getEntityType(parameter.getTypeFQN()).getProperties();
        for (CsdlProperty property : properties) {
            String paramPropertyTypeName = property.getTypeAsFQNObject().getFullQualifiedNameAsString();
            if ((complexType == null || complexType.getBaseType() == null || !complexType.getBaseTypeFQN().getFullQualifiedNameAsString().equals(paramPropertyTypeName)) && (!paramPropertyTypeName.equals(bindingParameterTypeName.getFullQualifiedNameAsString()) || isBindingParameterCollection.booleanValue() != property.isCollection())) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityPreviousTypeCompatibleToBindingParam(FullQualifiedName bindingParameterTypeName, CsdlParameter parameter) throws ODataException {
        return this.provider.getEntityType(bindingParameterTypeName) != null && this.provider.getEntityType(bindingParameterTypeName).getBaseTypeFQN() != null && this.provider.getEntityType(bindingParameterTypeName).getBaseTypeFQN().equals((Object)parameter.getTypeFQN());
    }

    @Override
    public EdmFunction createBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (!function.isBound()) continue;
                List providerParameters = function.getParameters();
                if (providerParameters == null || providerParameters.isEmpty()) {
                    throw new EdmException("No parameter specified for bound function: " + functionName);
                }
                CsdlParameter bindingParameter = (CsdlParameter)providerParameters.get(0);
                if (!bindingParameterTypeName.equals((Object)bindingParameter.getTypeFQN()) && !this.isEntityPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, bindingParameter) && !this.isComplexPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, bindingParameter, isBindingParameterCollection) || isBindingParameterCollection.booleanValue() != bindingParameter.isCollection() || parameterNamesCopy.size() != providerParameters.size() - 1) continue;
                ArrayList<String> providerParameterNames = new ArrayList<String>();
                for (int i = 1; i < providerParameters.size(); ++i) {
                    providerParameterNames.add(((CsdlParameter)providerParameters.get(i)).getName());
                }
                if (!parameterNamesCopy.containsAll(providerParameterNames)) continue;
                this.addAnnotations(function, functionName);
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public void addAnnotations(CsdlFunction function, FullQualifiedName functionName) {
        for (CsdlSchema schema : this.termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (annotationGrp.getTarget().equalsIgnoreCase(functionName.getFullQualifiedNameAsString())) {
                    this.addAnnotationsToFunctions(function, annotationGrp);
                    continue;
                }
                this.addAnnotationsToParamsOFunctions(function, functionName, annotationGrp);
            }
        }
    }

    private void addAnnotationsToParamsOFunctions(CsdlFunction function, FullQualifiedName functionName, CsdlAnnotations annotationGrp) {
        List parameters = function.getParameters();
        for (CsdlParameter parameter : parameters) {
            if (!annotationGrp.getTarget().equalsIgnoreCase(functionName.getFullQualifiedNameAsString() + "/" + parameter.getName())) continue;
            for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                if (this.compareAnnotations(function.getParameter(parameter.getName()).getAnnotations(), annotation)) continue;
                function.getParameter(parameter.getName()).getAnnotations().add(annotation);
            }
        }
    }

    private void addAnnotationsToFunctions(CsdlFunction function, CsdlAnnotations annotationGrp) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(function.getAnnotations(), annotation)) continue;
            function.getAnnotations().add(annotation);
        }
    }

    @Override
    protected Map<String, String> createAliasToNamespaceInfo() {
        HashMap<String, String> aliasToNamespaceInfos = new HashMap<String, String>();
        try {
            List aliasInfos = this.provider.getAliasInfos();
            if (aliasInfos != null) {
                for (CsdlAliasInfo info : aliasInfos) {
                    aliasToNamespaceInfos.put(info.getAlias(), info.getNamespace());
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return aliasToNamespaceInfos;
    }

    @Override
    protected EdmAction createUnboundAction(FullQualifiedName actionName) {
        try {
            List actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                if (action.isBound()) continue;
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected List<EdmFunction> createUnboundFunctions(FullQualifiedName functionName) {
        ArrayList<EdmFunction> result = new ArrayList<EdmFunction>();
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null && (functions = this.provider.getFunctions(functionName)) != null) {
                this.functionsMap.put(functionName, functions);
            }
            if (functions != null) {
                for (CsdlFunction function : functions) {
                    if (function.isBound()) continue;
                    result.add(new EdmFunctionImpl((Edm)this, functionName, function));
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return result;
    }

    @Override
    protected EdmFunction createUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (function.isBound()) continue;
                List<CsdlParameter> providerParameters = function.getParameters();
                if (providerParameters == null) {
                    providerParameters = Collections.emptyList();
                }
                if (parameterNamesCopy.size() != providerParameters.size()) continue;
                ArrayList<String> functionParameterNames = new ArrayList<String>();
                for (CsdlParameter parameter : providerParameters) {
                    functionParameterNames.add(parameter.getName());
                }
                if (!parameterNamesCopy.containsAll(functionParameterNames)) continue;
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected Map<String, EdmSchema> createSchemas() {
        try {
            LinkedHashMap<String, EdmSchema> providerSchemas = new LinkedHashMap<String, EdmSchema>();
            List localSchemas = this.provider.getSchemas();
            if (localSchemas != null) {
                for (CsdlSchema schema : localSchemas) {
                    providerSchemas.put(schema.getNamespace(), new EdmSchemaImpl(this, this.provider, schema));
                }
            }
            for (CsdlSchema termSchemaDefn : this.termSchemaDefinition) {
                providerSchemas.put(termSchemaDefn.getNamespace(), new EdmSchemaImpl(this, this.provider, termSchemaDefn));
            }
            return providerSchemas;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected EdmTerm createTerm(FullQualifiedName termName) {
        try {
            CsdlTerm providerTerm = this.provider.getTerm(termName);
            if (providerTerm != null) {
                return new EdmTermImpl((Edm)this, termName.getNamespace(), providerTerm);
            }
            for (CsdlSchema schema : this.termSchemaDefinition) {
                if (!schema.getNamespace().equalsIgnoreCase(termName.getNamespace()) && (null == schema.getAlias() || !schema.getAlias().equalsIgnoreCase(termName.getNamespace()))) continue;
                List terms = schema.getTerms();
                for (CsdlTerm term : terms) {
                    if (!term.getName().equals(termName.getName())) continue;
                    return new EdmTermImpl((Edm)this, termName.getNamespace(), term);
                }
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected EdmAnnotations createAnnotationGroup(FullQualifiedName targetName, String qualifier) {
        try {
            CsdlAnnotations providerGroup = this.provider.getAnnotationsGroup(targetName, qualifier);
            if (providerGroup != null) {
                return new EdmAnnotationsImpl((Edm)this, providerGroup);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public List<CsdlSchema> getTermSchemaDefinitions() {
        return this.termSchemaDefinition;
    }

    private boolean compareAnnotations(List<CsdlAnnotation> annotations, CsdlAnnotation annotation) {
        for (CsdlAnnotation annot : annotations) {
            if (!annot.equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }
}

