/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.ActionMapKey;
import org.apache.olingo.commons.core.edm.FunctionMapKey;
import org.apache.olingo.commons.core.edm.TargetQualifierMapKey;

public abstract class AbstractEdm
implements Edm {
    protected Map<String, EdmSchema> schemas;
    protected List<EdmSchema> schemaList;
    private boolean isEntityDerivedFromES;
    private boolean isComplexDerivedFromES;
    private boolean isPreviousES;
    private final Map<FullQualifiedName, EdmEntityContainer> entityContainers = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmEnumType> enumTypes = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmTypeDefinition> typeDefinitions = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmEntityType> entityTypes = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmComplexType> complexTypes = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmAction> unboundActions = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, List<EdmFunction>> unboundFunctionsByName = Collections.synchronizedMap(new HashMap());
    private final Map<FunctionMapKey, EdmFunction> unboundFunctionsByKey = Collections.synchronizedMap(new HashMap());
    private final Map<ActionMapKey, EdmAction> boundActions = Collections.synchronizedMap(new HashMap());
    private final Map<FunctionMapKey, EdmFunction> boundFunctions = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmTerm> terms = Collections.synchronizedMap(new HashMap());
    private final Map<TargetQualifierMapKey, EdmAnnotations> annotationGroups = Collections.synchronizedMap(new HashMap());
    private Map<String, String> aliasToNamespaceInfo = null;
    private final Map<FullQualifiedName, EdmEntityType> entityTypesWithAnnotations = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmEntityType> entityTypesDerivedFromES = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmComplexType> complexTypesWithAnnotations = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, EdmComplexType> complexTypesDerivedFromES = Collections.synchronizedMap(new HashMap());

    public List<EdmSchema> getSchemas() {
        if (this.schemaList == null) {
            this.initSchemas();
        }
        return this.schemaList;
    }

    public EdmSchema getSchema(String namespace) {
        EdmSchema schema;
        if (this.schemas == null) {
            this.initSchemas();
        }
        if ((schema = this.schemas.get(namespace)) == null) {
            schema = this.schemas.get(this.aliasToNamespaceInfo.get(namespace));
        }
        return schema;
    }

    private void initSchemas() {
        this.loadAliasToNamespaceInfo();
        Map<String, EdmSchema> localSchemas = this.createSchemas();
        this.schemas = Collections.synchronizedMap(localSchemas);
        this.schemaList = Collections.unmodifiableList(new ArrayList<EdmSchema>(this.schemas.values()));
    }

    private void loadAliasToNamespaceInfo() {
        Map<String, String> localAliasToNamespaceInfo = this.createAliasToNamespaceInfo();
        this.aliasToNamespaceInfo = Collections.synchronizedMap(localAliasToNamespaceInfo);
    }

    public EdmEntityContainer getEntityContainer() {
        return this.getEntityContainer(null);
    }

    public EdmEntityContainer getEntityContainer(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEntityContainer container = this.entityContainers.get(fqn);
        if (container == null && (container = this.createEntityContainer(fqn)) != null) {
            this.entityContainers.put(fqn, container);
            if (fqn == null) {
                this.entityContainers.put(new FullQualifiedName(container.getNamespace(), container.getName()), container);
            }
        }
        return container;
    }

    public EdmEnumType getEnumType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEnumType enumType = this.enumTypes.get(fqn);
        if (enumType == null && (enumType = this.createEnumType(fqn)) != null) {
            this.enumTypes.put(fqn, enumType);
        }
        return enumType;
    }

    public EdmTypeDefinition getTypeDefinition(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmTypeDefinition typeDefinition = this.typeDefinitions.get(fqn);
        if (typeDefinition == null && (typeDefinition = this.createTypeDefinition(fqn)) != null) {
            this.typeDefinitions.put(fqn, typeDefinition);
        }
        return typeDefinition;
    }

    public EdmEntityType getEntityType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEntityType entityType = this.entityTypes.get(fqn);
        if (entityType == null && (entityType = this.createEntityType(fqn)) != null) {
            this.entityTypes.put(fqn, entityType);
        }
        return entityType;
    }

    public EdmEntityType getEntityTypeWithAnnotations(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEntityType entityType = this.entityTypesWithAnnotations.get(fqn);
        if (entityType == null && (entityType = this.createEntityType(fqn)) != null) {
            this.entityTypesWithAnnotations.put(fqn, entityType);
        }
        this.setIsPreviousES(false);
        return entityType;
    }

    protected EdmEntityType getEntityTypeWithAnnotations(FullQualifiedName namespaceOrAliasFQN, boolean isEntityDerivedFromES) {
        EdmEntityType entityType;
        this.isEntityDerivedFromES = isEntityDerivedFromES;
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        if (!this.isPreviousES() && this.getEntityContainer() != null) {
            this.getEntityContainer().getEntitySetsWithAnnotations();
        }
        if ((entityType = this.entityTypesDerivedFromES.get(fqn)) == null && (entityType = this.createEntityType(fqn)) != null) {
            this.entityTypesDerivedFromES.put(fqn, entityType);
        }
        this.isEntityDerivedFromES = false;
        return entityType;
    }

    protected EdmComplexType getComplexTypeWithAnnotations(FullQualifiedName namespaceOrAliasFQN, boolean isComplexDerivedFromES) {
        EdmComplexType complexType;
        this.isComplexDerivedFromES = isComplexDerivedFromES;
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        if (!this.isPreviousES() && this.getEntityContainer() != null) {
            this.getEntityContainer().getEntitySetsWithAnnotations();
        }
        if ((complexType = this.complexTypesDerivedFromES.get(fqn)) == null && (complexType = this.createComplexType(fqn)) != null) {
            this.complexTypesDerivedFromES.put(fqn, complexType);
        }
        this.isComplexDerivedFromES = false;
        return complexType;
    }

    public EdmComplexType getComplexType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmComplexType complexType = this.complexTypes.get(fqn);
        if (complexType == null && (complexType = this.createComplexType(fqn)) != null) {
            this.complexTypes.put(fqn, complexType);
        }
        return complexType;
    }

    public EdmComplexType getComplexTypeWithAnnotations(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmComplexType complexType = this.complexTypesWithAnnotations.get(fqn);
        if (complexType == null && (complexType = this.createComplexType(fqn)) != null) {
            this.complexTypesWithAnnotations.put(fqn, complexType);
        }
        this.setIsPreviousES(false);
        return complexType;
    }

    public EdmAction getUnboundAction(FullQualifiedName actionName) {
        FullQualifiedName fqn = this.resolvePossibleAlias(actionName);
        EdmAction action = this.unboundActions.get(fqn);
        if (action == null && (action = this.createUnboundAction(fqn)) != null) {
            this.unboundActions.put(actionName, action);
        }
        return action;
    }

    public EdmAction getBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        FullQualifiedName bindingParameterTypeFqn;
        FullQualifiedName actionFqn = this.resolvePossibleAlias(actionName);
        ActionMapKey key = new ActionMapKey(actionFqn, bindingParameterTypeFqn = this.resolvePossibleAlias(bindingParameterTypeName), isBindingParameterCollection);
        EdmAction action = this.boundActions.get(key);
        if (action == null && (action = this.createBoundAction(actionFqn, bindingParameterTypeFqn, isBindingParameterCollection)) != null) {
            this.boundActions.put(key, action);
        }
        return action;
    }

    public List<EdmFunction> getUnboundFunctions(FullQualifiedName functionName) {
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        List<EdmFunction> functions = this.unboundFunctionsByName.get(functionFqn);
        if (functions == null && (functions = this.createUnboundFunctions(functionFqn)) != null) {
            this.unboundFunctionsByName.put(functionFqn, functions);
            for (EdmFunction unbound : functions) {
                FunctionMapKey key = new FunctionMapKey(new FullQualifiedName(unbound.getNamespace(), unbound.getName()), unbound.getBindingParameterTypeFqn(), unbound.isBindingParameterTypeCollection(), unbound.getParameterNames());
                this.unboundFunctionsByKey.put(key, unbound);
            }
        }
        return functions;
    }

    public EdmFunction getUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        FunctionMapKey key = new FunctionMapKey(functionFqn, null, null, parameterNames);
        EdmFunction function = this.unboundFunctionsByKey.get(key);
        if (function == null && (function = this.createUnboundFunction(functionFqn, parameterNames)) != null) {
            this.unboundFunctionsByKey.put(key, function);
        }
        return function;
    }

    public EdmFunction getBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        FullQualifiedName bindingParameterTypeFqn;
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        FunctionMapKey key = new FunctionMapKey(functionFqn, bindingParameterTypeFqn = this.resolvePossibleAlias(bindingParameterTypeName), isBindingParameterCollection, parameterNames);
        EdmFunction function = this.boundFunctions.get(key);
        if (function == null && (function = this.createBoundFunction(functionFqn, bindingParameterTypeFqn, isBindingParameterCollection, parameterNames)) != null) {
            this.boundFunctions.put(key, function);
        }
        return function;
    }

    public EdmTerm getTerm(FullQualifiedName termName) {
        FullQualifiedName fqn = this.resolvePossibleAlias(termName);
        EdmTerm term = this.terms.get(fqn);
        if (term == null && (term = this.createTerm(fqn)) != null) {
            this.terms.put(fqn, term);
        }
        return term;
    }

    public EdmAnnotations getAnnotationGroup(FullQualifiedName targetName, String qualifier) {
        FullQualifiedName fqn = this.resolvePossibleAlias(targetName);
        TargetQualifierMapKey key = new TargetQualifierMapKey(fqn, qualifier);
        EdmAnnotations _annotations = this.annotationGroups.get(key);
        if (_annotations == null && (_annotations = this.createAnnotationGroup(fqn, qualifier)) != null) {
            this.annotationGroups.put(key, _annotations);
        }
        return _annotations;
    }

    private FullQualifiedName resolvePossibleAlias(FullQualifiedName namespaceOrAliasFQN) {
        if (this.aliasToNamespaceInfo == null) {
            this.loadAliasToNamespaceInfo();
        }
        FullQualifiedName finalFQN = null;
        if (namespaceOrAliasFQN != null) {
            String namespace = this.aliasToNamespaceInfo.get(namespaceOrAliasFQN.getNamespace());
            finalFQN = namespace == null ? namespaceOrAliasFQN : new FullQualifiedName(namespace, namespaceOrAliasFQN.getName());
        }
        return finalFQN;
    }

    protected abstract Map<String, EdmSchema> createSchemas();

    protected abstract Map<String, String> createAliasToNamespaceInfo();

    public void cacheAliasNamespaceInfo(String alias, String namespace) {
        this.aliasToNamespaceInfo.put(alias, namespace);
    }

    protected abstract EdmEntityContainer createEntityContainer(FullQualifiedName var1);

    public void cacheEntityContainer(FullQualifiedName containerFQN, EdmEntityContainer container) {
        this.entityContainers.put(containerFQN, container);
    }

    protected abstract EdmEnumType createEnumType(FullQualifiedName var1);

    public void cacheEnumType(FullQualifiedName enumName, EdmEnumType enumType) {
        this.enumTypes.put(enumName, enumType);
    }

    protected abstract EdmTypeDefinition createTypeDefinition(FullQualifiedName var1);

    public void cacheTypeDefinition(FullQualifiedName typeDefName, EdmTypeDefinition typeDef) {
        this.typeDefinitions.put(typeDefName, typeDef);
    }

    protected abstract EdmEntityType createEntityType(FullQualifiedName var1);

    public void cacheEntityType(FullQualifiedName entityTypeName, EdmEntityType entityType) {
        this.entityTypes.put(entityTypeName, entityType);
    }

    protected abstract EdmComplexType createComplexType(FullQualifiedName var1);

    public void cacheComplexType(FullQualifiedName compelxTypeName, EdmComplexType complexType) {
        this.complexTypes.put(compelxTypeName, complexType);
    }

    protected abstract EdmAction createUnboundAction(FullQualifiedName var1);

    protected abstract List<EdmFunction> createUnboundFunctions(FullQualifiedName var1);

    protected abstract EdmFunction createUnboundFunction(FullQualifiedName var1, List<String> var2);

    protected abstract EdmAction createBoundAction(FullQualifiedName var1, FullQualifiedName var2, Boolean var3);

    protected abstract EdmFunction createBoundFunction(FullQualifiedName var1, FullQualifiedName var2, Boolean var3, List<String> var4);

    public void cacheFunction(FullQualifiedName functionName, EdmFunction function) {
        FunctionMapKey key = new FunctionMapKey(functionName, function.getBindingParameterTypeFqn(), function.isBindingParameterTypeCollection(), function.getParameterNames());
        if (function.isBound()) {
            this.boundFunctions.put(key, function);
        } else {
            if (!this.unboundFunctionsByName.containsKey(functionName)) {
                this.unboundFunctionsByName.put(functionName, new ArrayList());
            }
            this.unboundFunctionsByName.get(functionName).add(function);
            this.unboundFunctionsByKey.put(key, function);
        }
    }

    public void cacheAction(FullQualifiedName actionName, EdmAction action) {
        if (action.isBound()) {
            ActionMapKey key = new ActionMapKey(actionName, action.getBindingParameterTypeFqn(), action.isBindingParameterTypeCollection());
            this.boundActions.put(key, action);
        } else {
            this.unboundActions.put(actionName, action);
        }
    }

    protected abstract EdmTerm createTerm(FullQualifiedName var1);

    public void cacheTerm(FullQualifiedName termName, EdmTerm term) {
        this.terms.put(termName, term);
    }

    protected abstract EdmAnnotations createAnnotationGroup(FullQualifiedName var1, String var2);

    public void cacheAnnotationGroup(FullQualifiedName targetName, EdmAnnotations annotationsGroup) {
        TargetQualifierMapKey key = new TargetQualifierMapKey(targetName, annotationsGroup.getQualifier());
        this.annotationGroups.put(key, annotationsGroup);
    }

    public EdmAction getBoundActionWithBindingType(FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        for (EdmSchema schema : this.getSchemas()) {
            for (EdmAction action : schema.getActions()) {
                EdmParameter bindingParameter;
                if (!action.isBound() || !(bindingParameter = action.getParameter((String)action.getParameterNames().get(0))).getType().getFullQualifiedName().equals((Object)bindingParameterTypeName) || bindingParameter.isCollection() != isBindingParameterCollection.booleanValue()) continue;
                return action;
            }
        }
        return null;
    }

    public List<EdmFunction> getBoundFunctionsWithBindingType(FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        ArrayList<EdmFunction> functions = new ArrayList<EdmFunction>();
        for (EdmSchema schema : this.getSchemas()) {
            for (EdmFunction function : schema.getFunctions()) {
                EdmParameter bindingParameter;
                if (!function.isBound() || !(bindingParameter = function.getParameter((String)function.getParameterNames().get(0))).getType().getFullQualifiedName().equals((Object)bindingParameterTypeName) || bindingParameter.isCollection() != isBindingParameterCollection.booleanValue()) continue;
                functions.add(function);
            }
        }
        return functions;
    }

    protected boolean isEntityDerivedFromES() {
        return this.isEntityDerivedFromES;
    }

    protected boolean isComplexDerivedFromES() {
        return this.isComplexDerivedFromES;
    }

    protected void setIsPreviousES(boolean isPreviousES) {
        this.isPreviousES = isPreviousES;
    }

    protected boolean isPreviousES() {
        return this.isPreviousES;
    }
}

