/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataSerializer;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.serialization.AtomGeoValueSerializer;
import org.apache.olingo.client.core.serialization.ContextURLParser;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.AbstractODataObject;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class AtomSerializer
implements ODataSerializer {
    private static final String TYPE_TEXT = "text";
    private static final XMLOutputFactory FACTORY = new OutputFactoryImpl();
    private final AtomGeoValueSerializer geoSerializer = new AtomGeoValueSerializer();
    private final boolean serverMode;

    public AtomSerializer() {
        this(false);
    }

    public AtomSerializer(boolean serverMode) {
        this.serverMode = serverMode;
    }

    protected void namespaces(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeNamespace("", "http://www.w3.org/2005/Atom");
        writer.writeNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        writer.writeNamespace("m", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeNamespace("d", "http://docs.oasis-open.org/odata/ns/data");
        writer.writeNamespace("gml", "http://www.opengis.net/gml");
        writer.writeNamespace("georss", "http://www.georss.org/georss");
    }

    private void collection(XMLStreamWriter writer, ValueType valueType, EdmPrimitiveTypeKind kind, List<?> value) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Object item : value) {
            writer.writeStartElement("m", "element", "http://docs.oasis-open.org/odata/ns/metadata");
            this.value(writer, valueType, kind, item);
            writer.writeEndElement();
        }
    }

    private void value(XMLStreamWriter writer, ValueType valueType, EdmPrimitiveTypeKind kind, Object value) throws XMLStreamException, EdmPrimitiveTypeException {
        if (value == null || valueType == ValueType.COMPLEX && ((ComplexValue)value).getValue().isEmpty()) {
            writer.writeAttribute("m", "http://docs.oasis-open.org/odata/ns/metadata", "null", Boolean.TRUE.toString());
            return;
        }
        switch (valueType) {
            case PRIMITIVE: {
                EdmPrimitiveTypeKind valueKind;
                EdmPrimitiveTypeKind edmPrimitiveTypeKind = valueKind = kind == null ? EdmTypeInfo.determineTypeKind((Object)value) : kind;
                if (valueKind == null) {
                    if (this.serverMode) {
                        throw new EdmPrimitiveTypeException("The primitive type could not be determined.");
                    }
                    writer.writeCharacters(value.toString());
                    break;
                }
                writer.writeCharacters(EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)valueKind).valueToString(value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null));
                break;
            }
            case ENUM: {
                writer.writeCharacters(value.toString());
                break;
            }
            case GEOSPATIAL: {
                this.geoSerializer.serialize(writer, (Geospatial)value);
                break;
            }
            case COLLECTION_PRIMITIVE: 
            case COLLECTION_GEOSPATIAL: 
            case COLLECTION_ENUM: 
            case COLLECTION_COMPLEX: {
                this.collection(writer, valueType.getBaseType(), kind, (List)value);
                break;
            }
            case COMPLEX: {
                if (((ComplexValue)value).getTypeName() != null) {
                    EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setTypeExpression(((ComplexValue)value).getTypeName()).build();
                    writer.writeAttribute("m", "http://docs.oasis-open.org/odata/ns/metadata", "type", typeInfo.external());
                }
                for (Property property : ((ComplexValue)value).getValue()) {
                    this.property(writer, property, false);
                }
                break;
            }
            case ENTITY: 
            case COLLECTION_ENTITY: {
                throw new ODataRuntimeException("Entities cannot appear in this payload");
            }
        }
    }

    public void property(XMLStreamWriter writer, Property property, boolean standalone) throws XMLStreamException, EdmPrimitiveTypeException {
        if (standalone) {
            writer.writeStartElement("m", "value", "http://docs.oasis-open.org/odata/ns/data");
            this.namespaces(writer);
        } else {
            writer.writeStartElement("d", property.getName(), "http://docs.oasis-open.org/odata/ns/data");
        }
        EdmTypeInfo typeInfo = null;
        if (property.getType() != null && !"COMPLEX".equalsIgnoreCase(property.getValueType().name())) {
            typeInfo = new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build();
            if (!EdmPrimitiveTypeKind.String.getFullQualifiedName().toString().equals(typeInfo.internal())) {
                writer.writeAttribute("m", "http://docs.oasis-open.org/odata/ns/metadata", "type", typeInfo.external());
            }
        }
        this.value(writer, property.getValueType(), typeInfo == null ? null : typeInfo.getPrimitiveTypeKind(), property.getValue());
        if (!property.isNull() && property.isComplex() && !property.isCollection()) {
            this.links(writer, property.asComplex().getAssociationLinks());
            if (this.serverMode) {
                this.links(writer, property.asComplex().getNavigationLinks());
            } else {
                this.writeNavigationLinks(writer, property.asComplex().getNavigationLinks());
            }
        }
        writer.writeEndElement();
        for (Annotation annotation : property.getAnnotations()) {
            this.annotation(writer, annotation, property.getName());
        }
    }

    private void property(XMLStreamWriter writer, Property property) throws XMLStreamException, EdmPrimitiveTypeException {
        this.property(writer, property, true);
    }

    private void startDocument(XMLStreamWriter writer, String rootElement) throws XMLStreamException {
        writer.writeStartDocument();
        writer.setDefaultNamespace("http://www.w3.org/2005/Atom");
        writer.writeStartElement(rootElement);
        this.namespaces(writer);
    }

    private void property(Writer outWriter, Property property) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        writer.writeStartDocument();
        this.property(writer, property);
        writer.writeEndDocument();
        writer.flush();
    }

    private boolean isEntitySetNavigation(Link link) {
        return Constants.ENTITY_SET_NAVIGATION_LINK_TYPE.equals(link.getType());
    }

    private void writeNavigationLinks(XMLStreamWriter writer, List<Link> links) throws XMLStreamException, EdmPrimitiveTypeException {
        HashMap entitySetLinks = new HashMap();
        for (Link link : links) {
            if (link.getInlineEntity() != null || link.getInlineEntitySet() != null) {
                this.writeLink(writer, link, new ExtraContent(){

                    @Override
                    public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                        writer.writeStartElement("m", "inline", "http://docs.oasis-open.org/odata/ns/metadata");
                        if (link.getInlineEntity() != null) {
                            writer.writeStartElement("http://www.w3.org/2005/Atom", "entry");
                            AtomSerializer.this.entity(writer, link.getInlineEntity());
                            writer.writeEndElement();
                        }
                        if (link.getInlineEntitySet() != null) {
                            writer.writeStartElement("http://www.w3.org/2005/Atom", "feed");
                            AtomSerializer.this.entitySet(writer, link.getInlineEntitySet());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                });
                continue;
            }
            if (link.getBindingLink() != null) {
                this.writeLink(writer, link, new ExtraContent(){

                    @Override
                    public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                        writer.writeAttribute("href", link.getBindingLink());
                    }
                });
                continue;
            }
            if (link.getBindingLinks() != null && !link.getBindingLinks().isEmpty()) {
                this.writeLink(writer, link, new ExtraContent(){

                    @Override
                    public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                        writer.writeStartElement("m", "inline", "http://docs.oasis-open.org/odata/ns/metadata");
                        writer.writeStartElement("http://www.w3.org/2005/Atom", "feed");
                        for (String binding : link.getBindingLinks()) {
                            Entity entity = new Entity();
                            entity.setId(URI.create(binding));
                            AtomSerializer.this.inlineEntityRef(writer, entity);
                        }
                        writer.writeEndElement();
                        writer.writeEndElement();
                    }
                });
                continue;
            }
            if (this.isEntitySetNavigation(link)) {
                List<String> uris;
                if (entitySetLinks.containsKey(link.getTitle())) {
                    uris = (List)entitySetLinks.get(link.getTitle());
                } else {
                    uris = new ArrayList();
                    entitySetLinks.put(link.getTitle(), uris);
                }
                if (link.getHref() == null) continue;
                uris.add(link.getHref());
                continue;
            }
            this.writeLink(writer, link, new ExtraContent(){

                @Override
                public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                }
            });
        }
        for (Map.Entry entry : entitySetLinks.entrySet()) {
            final List entitySetLink = (List)entry.getValue();
            if (entitySetLink.isEmpty()) continue;
            Link link = new Link();
            link.setTitle((String)entry.getKey());
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            link.setRel("http://docs.oasis-open.org/odata/ns/related/" + (String)entry.getKey());
            this.writeLink(writer, link, new ExtraContent(){

                @Override
                public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                    writer.writeStartElement("m", "inline", "http://docs.oasis-open.org/odata/ns/metadata");
                    writer.writeStartElement("http://www.w3.org/2005/Atom", "feed");
                    for (String binding : entitySetLink) {
                        Entity entity = new Entity();
                        entity.setId(URI.create(binding));
                        AtomSerializer.this.inlineEntityRef(writer, entity);
                    }
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            });
        }
    }

    private void links(XMLStreamWriter writer, List<Link> links) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Link link : links) {
            this.writeLink(writer, link, new ExtraContent(){

                @Override
                public void write(XMLStreamWriter writer, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
                }
            });
        }
    }

    private void writeLink(XMLStreamWriter writer, Link link, ExtraContent content) throws XMLStreamException, EdmPrimitiveTypeException {
        writer.writeStartElement("link");
        if (link.getRel() != null) {
            writer.writeAttribute("rel", link.getRel());
        }
        if (link.getTitle() != null) {
            writer.writeAttribute("title", link.getTitle());
        }
        if (link.getHref() != null) {
            writer.writeAttribute("href", link.getHref());
        }
        if (link.getType() != null) {
            writer.writeAttribute("type", link.getType());
        }
        content.write(writer, link);
        for (Annotation annotation : link.getAnnotations()) {
            this.annotation(writer, annotation, null);
        }
        writer.writeEndElement();
    }

    private void common(XMLStreamWriter writer, AbstractODataObject object) throws XMLStreamException {
        if (object.getTitle() != null) {
            writer.writeStartElement("title");
            writer.writeAttribute("type", TYPE_TEXT);
            writer.writeCharacters(object.getTitle());
            writer.writeEndElement();
        }
    }

    private void properties(XMLStreamWriter writer, List<Property> properties) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Property property : properties) {
            this.property(writer, property, false);
        }
    }

    private void annotation(XMLStreamWriter writer, Annotation annotation, String target) throws XMLStreamException, EdmPrimitiveTypeException {
        writer.writeStartElement("m", "annotation", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeAttribute("term", annotation.getTerm());
        if (target != null) {
            writer.writeAttribute("target", target);
        }
        EdmTypeInfo typeInfo = null;
        if (annotation.getType() != null) {
            typeInfo = new EdmTypeInfo.Builder().setTypeExpression(annotation.getType()).build();
            if (!EdmPrimitiveTypeKind.String.getFullQualifiedName().toString().equals(typeInfo.internal())) {
                writer.writeAttribute("m", "http://docs.oasis-open.org/odata/ns/metadata", "type", typeInfo.external());
            }
        }
        this.value(writer, annotation.getValueType(), typeInfo == null ? EdmTypeInfo.determineTypeKind((Object)annotation.getValue()) : typeInfo.getPrimitiveTypeKind(), annotation.getValue());
        writer.writeEndElement();
    }

    private void entity(XMLStreamWriter writer, Entity entity) throws XMLStreamException, EdmPrimitiveTypeException {
        if (entity.getBaseURI() != null) {
            writer.writeAttribute("http://www.w3.org/XML/1998/namespace", "base", entity.getBaseURI().toASCIIString());
        }
        if (this.serverMode && entity.getETag() != null) {
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "etag", entity.getETag());
        }
        if (entity.getId() != null) {
            writer.writeStartElement("id");
            writer.writeCharacters(entity.getId().toASCIIString());
            writer.writeEndElement();
        }
        writer.writeStartElement("category");
        writer.writeAttribute("scheme", "http://docs.oasis-open.org/odata/ns/scheme");
        if (entity.getType() != null) {
            writer.writeAttribute("term", new EdmTypeInfo.Builder().setTypeExpression(entity.getType()).build().external());
        }
        writer.writeEndElement();
        this.common(writer, (AbstractODataObject)entity);
        if (this.serverMode) {
            if (entity.getEditLink() != null) {
                this.links(writer, Collections.singletonList(entity.getEditLink()));
            }
            if (entity.getSelfLink() != null) {
                this.links(writer, Collections.singletonList(entity.getSelfLink()));
            }
        }
        this.links(writer, entity.getAssociationLinks());
        if (this.serverMode) {
            this.links(writer, entity.getNavigationLinks());
        } else {
            this.writeNavigationLinks(writer, entity.getNavigationLinks());
            this.writeNavigationLinks(writer, entity.getNavigationBindings());
        }
        this.links(writer, entity.getMediaEditLinks());
        if (this.serverMode) {
            for (Operation operation : entity.getOperations()) {
                writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "action");
                writer.writeAttribute("metadata", operation.getMetadataAnchor());
                writer.writeAttribute("title", operation.getTitle());
                writer.writeAttribute("target", operation.getTarget().toASCIIString());
                writer.writeEndElement();
            }
        }
        writer.writeStartElement("content");
        if (entity.isMediaEntity()) {
            if (entity.getMediaContentType() != null) {
                writer.writeAttribute("type", entity.getMediaContentType());
            }
            if (entity.getMediaContentSource() != null) {
                writer.writeAttribute("src", entity.getMediaContentSource().toASCIIString());
            }
            writer.writeEndElement();
            writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "properties");
            this.properties(writer, entity.getProperties());
        } else {
            writer.writeAttribute("type", ContentType.APPLICATION_XML.toContentTypeString());
            writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "properties");
            this.properties(writer, entity.getProperties());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        for (Annotation annotation : entity.getAnnotations()) {
            this.annotation(writer, annotation, null);
        }
    }

    private void inlineEntityRef(XMLStreamWriter writer, Entity entity) throws XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "ref");
        writer.writeAttribute("id", entity.getId().toASCIIString());
        writer.writeEndElement();
    }

    private void entityRef(XMLStreamWriter writer, Entity entity) throws XMLStreamException {
        writer.writeStartElement("ref");
        writer.writeDefaultNamespace("http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeAttribute("id", entity.getId().toASCIIString());
        writer.writeEndElement();
    }

    private void entityRef(XMLStreamWriter writer, ResWrap<Entity> container) throws XMLStreamException {
        writer.writeStartElement("ref");
        writer.writeDefaultNamespace("http://docs.oasis-open.org/odata/ns/metadata");
        this.addContextInfo(writer, container);
        writer.writeAttribute("id", ((Entity)container.getPayload()).getId().toASCIIString());
    }

    private void entity(Writer outWriter, Entity entity) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        if (entity.getType() == null && entity.getProperties().isEmpty()) {
            writer.writeStartDocument();
            writer.setDefaultNamespace("http://docs.oasis-open.org/odata/ns/metadata");
            this.entityRef(writer, entity);
        } else {
            this.startDocument(writer, "entry");
            this.entity(writer, entity);
        }
        writer.writeEndDocument();
        writer.flush();
    }

    private void entity(Writer outWriter, ResWrap<Entity> container) throws XMLStreamException, EdmPrimitiveTypeException {
        Entity entity = (Entity)container.getPayload();
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        if (entity.getType() == null && entity.getProperties().isEmpty()) {
            writer.writeStartDocument();
            writer.setDefaultNamespace("http://docs.oasis-open.org/odata/ns/metadata");
            this.entityRef(writer, container);
        } else {
            this.startDocument(writer, "entry");
            this.addContextInfo(writer, container);
            this.entity(writer, entity);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void entitySet(XMLStreamWriter writer, EntityCollection entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        if (entitySet.getBaseURI() != null) {
            writer.writeAttribute("http://www.w3.org/XML/1998/namespace", "base", entitySet.getBaseURI().toASCIIString());
        }
        if (entitySet.getCount() != null) {
            writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "count");
            writer.writeCharacters(Integer.toString(entitySet.getCount()));
            writer.writeEndElement();
        }
        if (entitySet.getId() != null) {
            writer.writeStartElement("id");
            writer.writeCharacters(entitySet.getId().toASCIIString());
            writer.writeEndElement();
        }
        this.common(writer, (AbstractODataObject)entitySet);
        for (Entity entity : entitySet) {
            if (entity.getType() == null && entity.getProperties().isEmpty()) {
                this.entityRef(writer, entity);
                continue;
            }
            writer.writeStartElement("entry");
            this.entity(writer, entity);
            writer.writeEndElement();
        }
        if (this.serverMode) {
            Link next;
            if (entitySet.getNext() != null) {
                next = new Link();
                next.setRel("next");
                next.setHref(entitySet.getNext().toASCIIString());
                this.links(writer, Collections.singletonList(next));
            }
            if (entitySet.getDeltaLink() != null) {
                next = new Link();
                next.setRel("http://docs.oasis-open.org/odata/ns/delta");
                next.setHref(entitySet.getDeltaLink().toASCIIString());
                this.links(writer, Collections.singletonList(next));
            }
        }
    }

    private void entitySet(Writer outWriter, EntityCollection entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        this.startDocument(writer, "feed");
        this.entitySet(writer, entitySet);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void entitySet(Writer outWriter, ResWrap<EntityCollection> entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        this.startDocument(writer, "feed");
        this.addContextInfo(writer, entitySet);
        this.entitySet(writer, (EntityCollection)entitySet.getPayload());
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void link(Writer outWriter, Link link) throws XMLStreamException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        writer.writeStartDocument();
        writer.writeStartElement("links");
        writer.writeDefaultNamespace("http://docs.oasis-open.org/odata/ns/data");
        writer.writeStartElement("uri");
        writer.writeCharacters(link.getHref());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    public <T> void write(Writer writer, T obj) throws ODataSerializerException {
        try {
            if (obj instanceof EntityCollection) {
                this.entitySet(writer, (EntityCollection)obj);
            } else if (obj instanceof Entity) {
                this.entity(writer, (Entity)obj);
            } else if (obj instanceof Property) {
                this.property(writer, (Property)obj);
            } else if (obj instanceof Link) {
                this.link(writer, (Link)obj);
            }
        }
        catch (XMLStreamException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    private void reference(Writer outWriter, ResWrap<URI> container) throws XMLStreamException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        writer.writeStartDocument();
        writer.writeStartElement("metadata", "ref", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "context", container.getContextURL().toASCIIString());
        writer.writeAttribute("id", ((URI)container.getPayload()).toASCIIString());
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public <T> void write(Writer writer, ResWrap<T> container) throws ODataSerializerException {
        Object obj = container == null ? null : container.getPayload();
        try {
            if (obj instanceof EntityCollection) {
                this.entitySet(writer, container);
            } else if (obj instanceof Entity) {
                this.entity(writer, container);
            } else if (obj instanceof Property) {
                this.property(writer, (Property)obj);
            } else if (obj instanceof Link) {
                this.link(writer, (Link)obj);
            } else if (obj instanceof URI) {
                this.reference(writer, container);
            }
        }
        catch (XMLStreamException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    private <T> void addContextInfo(XMLStreamWriter writer, ResWrap<T> container) throws XMLStreamException {
        if (container.getContextURL() != null) {
            ContextURL contextURL = ContextURLParser.parse(container.getContextURL());
            URI base = contextURL.getServiceRoot();
            if (container.getPayload() instanceof EntityCollection) {
                ((EntityCollection)container.getPayload()).setBaseURI(base);
            }
            if (container.getPayload() instanceof Entity) {
                ((Entity)container.getPayload()).setBaseURI(base);
            }
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "context", container.getContextURL().toASCIIString());
        }
        if (container.getMetadataETag() != null) {
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "metadata-etag", container.getMetadataETag());
        }
    }

    static interface ExtraContent {
        public void write(XMLStreamWriter var1, Link var2) throws XMLStreamException, EdmPrimitiveTypeException;
    }
}

