/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.util;

import java.io.IOException;
import org.apache.olingo.client.core.communication.util.PipedInputStream;

public class PipedOutputStream
extends java.io.PipedOutputStream {
    PipedInputStream sink;

    protected PipedOutputStream() {
        this(null);
    }

    public PipedOutputStream(PipedInputStream sink) {
        this(sink, 0x400000);
    }

    public PipedOutputStream(PipedInputStream sink, int bufferSize) {
        if (sink != null) {
            try {
                this.connect(sink);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            sink.buffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        Object object = this.sink.sync;
        synchronized (object) {
            this.sink.closed = true;
            this.flush();
        }
    }

    public void connect(PipedInputStream sink) throws IOException {
        if (this.sink != null) {
            throw new IOException("Pipe already connected");
        }
        this.sink = sink;
        sink.source = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.sink.sync;
        synchronized (object) {
            this.sink.sync.notifyAll();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        if (this.sink.closed) {
            throw new IOException("Broken pipe");
        }
        Object object = this.sink.sync;
        synchronized (object) {
            if (this.sink.writePosition == this.sink.readPosition && this.sink.writeLaps > this.sink.readLaps) {
                try {
                    this.sink.sync.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
                this.write(b, off, len);
                return;
            }
            int amount = Math.min(len, (this.sink.writePosition < this.sink.readPosition ? this.sink.readPosition : this.sink.buffer.length) - this.sink.writePosition);
            System.arraycopy(b, off, this.sink.buffer, this.sink.writePosition, amount);
            this.sink.writePosition += amount;
            if (this.sink.writePosition == this.sink.buffer.length) {
                this.sink.writePosition = 0;
                ++this.sink.writeLaps;
            }
            if (amount < len) {
                this.write(b, off + amount, len - amount);
            } else {
                this.sink.sync.notifyAll();
            }
        }
    }
}

