/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;

public class DebugTabStacktrace
implements DebugTab {
    private final Exception exception;

    public DebugTabStacktrace(Exception exception) {
        this.exception = exception;
    }

    @Override
    public String getName() {
        return "Stacktrace";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("exceptions");
        gen.writeStartArray();
        for (Throwable throwable = this.exception; throwable != null; throwable = throwable.getCause()) {
            gen.writeStartObject();
            gen.writeStringField("class", throwable.getClass().getCanonicalName());
            gen.writeStringField("message", this.getMessageText(throwable));
            gen.writeFieldName("invocation");
            this.appendJsonStackTraceElement(gen, throwable.getStackTrace()[0]);
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeFieldName("stacktrace");
        gen.writeStartArray();
        for (StackTraceElement stackTraceElement : this.exception.getStackTrace()) {
            this.appendJsonStackTraceElement(gen, stackTraceElement);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private String getMessageText(Throwable throwable) {
        ODataLibraryException ex;
        ODataLibraryException.ODataErrorMessage translatedMessage;
        String message = throwable instanceof ODataLibraryException ? ((translatedMessage = (ex = (ODataLibraryException)throwable).getTranslatedMessage(null)).getMessage() == null ? ex.getMessage() : translatedMessage.getMessage()) : throwable.getMessage();
        return message;
    }

    private void appendJsonStackTraceElement(JsonGenerator gen, StackTraceElement element) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("class", element.getClassName());
        gen.writeStringField("method", element.getMethodName());
        gen.writeNumberField("line", element.getLineNumber());
        gen.writeEndObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        this.appendException(this.exception, writer);
        writer.append("<h2>Stacktrace</h2>\n");
        int count = 0;
        for (StackTraceElement stackTraceElement : this.exception.getStackTrace()) {
            this.appendStackTraceElement(stackTraceElement, ++count == 1, count == this.exception.getStackTrace().length, writer);
        }
    }

    private void appendException(Throwable throwable, Writer writer) throws IOException {
        if (throwable.getCause() != null) {
            this.appendException(throwable.getCause(), writer);
        }
        StackTraceElement details = throwable.getStackTrace()[0];
        writer.append("<h2>").append(throwable.getClass().getCanonicalName()).append("</h2>\n").append("<p>").append(DebugResponseHelperImpl.escapeHtml(this.getMessageText(throwable))).append("</p>\n");
        this.appendStackTraceElement(details, true, true, writer);
    }

    private void appendStackTraceElement(StackTraceElement stackTraceElement, boolean isFirst, boolean isLast, Writer writer) throws IOException {
        if (isFirst) {
            writer.append("<table>\n<thead>\n").append("<tr>\n<th class=\"name\">Class</th>\n").append("<th class=\"name\">Method</th>\n").append("<th class=\"value\">Line number in class</th>\n</tr>\n").append("</thead>\n<tbody>\n");
        }
        writer.append("<tr>\n<td class=\"name\">").append(stackTraceElement.getClassName()).append("</td>\n").append("<td class=\"name\">").append(stackTraceElement.getMethodName()).append("</td>\n").append("<td class=\"value\">").append(Integer.toString(stackTraceElement.getLineNumber())).append("</td>\n</tr>\n");
        if (isLast) {
            writer.append("</tbody>\n</table>\n");
        }
    }
}

