/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDecimal
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?(?:0*(\\p{Digit}+?))(?:\\.(\\p{Digit}+?)0*)?");
    private static final EdmDecimal INSTANCE = new EdmDecimal();

    public static EdmDecimal getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32 || primitiveType instanceof EdmInt64 || primitiveType instanceof EdmSingle || primitiveType instanceof EdmDouble || primitiveType instanceof EdmDecimal;
    }

    public Class<?> getDefaultType() {
        return BigDecimal.class;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : EdmDecimal.validateLiteral(value) && EdmDecimal.validatePrecisionAndScale(value, precision, scale);
    }

    private static boolean validateLiteral(String value) {
        return PATTERN.matcher(value).matches();
    }

    private static boolean validatePrecisionAndScale(String value, Integer precision, Integer scale) {
        int decimals;
        Matcher matcher = PATTERN.matcher(value);
        matcher.matches();
        int significantIntegerDigits = matcher.group(1).equals("0") ? 0 : matcher.group(1).length();
        int n = decimals = matcher.group(2) == null ? 0 : matcher.group(2).length();
        return (precision == null || precision >= significantIntegerDigits + decimals) && decimals <= (scale == null ? 0 : scale);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (!EdmDecimal.validateLiteral(value)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        if (!EdmDecimal.validatePrecisionAndScale(value, precision, scale)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
        }
        try {
            return EdmDecimal.convertDecimal(new BigDecimal(value), returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    protected static <T> T convertDecimal(BigDecimal value, Class<T> returnType) throws IllegalArgumentException, ClassCastException {
        if (returnType.isAssignableFrom(BigDecimal.class)) {
            return returnType.cast(value);
        }
        if (returnType.isAssignableFrom(Double.class)) {
            double doubleValue = value.doubleValue();
            if (BigDecimal.valueOf(doubleValue).compareTo(value) == 0) {
                return returnType.cast(doubleValue);
            }
            throw new IllegalArgumentException();
        }
        if (returnType.isAssignableFrom(Float.class)) {
            Float floatValue = Float.valueOf(value.floatValue());
            if (BigDecimal.valueOf(floatValue.floatValue()).compareTo(value) == 0) {
                return returnType.cast(floatValue);
            }
            throw new IllegalArgumentException();
        }
        try {
            if (returnType.isAssignableFrom(BigInteger.class)) {
                return returnType.cast(value.toBigIntegerExact());
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(value.longValueExact());
            }
            if (returnType.isAssignableFrom(Integer.class)) {
                return returnType.cast(value.intValueExact());
            }
            if (returnType.isAssignableFrom(Short.class)) {
                return returnType.cast(value.shortValueExact());
            }
            if (returnType.isAssignableFrom(Byte.class)) {
                return returnType.cast(value.byteValueExact());
            }
            throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        int digits;
        BigDecimal bigDecimalValue;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            String result = value.toString();
            int digits2 = result.startsWith("-") ? result.length() - 1 : result.length();
            if (precision == null) return result;
            if (precision >= digits2) return result;
            throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.");
        }
        if (!(value instanceof Double) && !(value instanceof Float)) {
            if (!(value instanceof BigDecimal)) throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
        }
        try {
            bigDecimalValue = value instanceof Double ? BigDecimal.valueOf((Double)value) : (value instanceof Float ? BigDecimal.valueOf(((Float)value).floatValue()) : (BigDecimal)value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.", (Exception)e);
        }
        int n = digits = bigDecimalValue.scale() >= 0 ? Math.max(bigDecimalValue.precision(), bigDecimalValue.scale()) : bigDecimalValue.precision() - bigDecimalValue.scale();
        if (precision != null) {
            if (precision < digits) throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.");
        }
        if (bigDecimalValue.scale() > (scale == null ? 0 : scale)) throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.");
        return bigDecimalValue.toPlainString();
    }
}

