/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.ComposedGeospatial;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;

class JsonGeoValueSerializer {
    JsonGeoValueSerializer() {
    }

    private void srid(JsonGenerator jgen, SRID srid) throws IOException {
        jgen.writeObjectFieldStart("crs");
        jgen.writeStringField("type", "name");
        jgen.writeObjectFieldStart("properties");
        jgen.writeStringField("name", "EPSG:" + srid.toString());
        jgen.writeEndObject();
        jgen.writeEndObject();
    }

    private void point(JsonGenerator jgen, Point point) throws IOException {
        try {
            jgen.writeNumber(EdmDouble.getInstance().valueToString((Object)point.getX(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null));
            jgen.writeNumber(EdmDouble.getInstance().valueToString((Object)point.getY(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IllegalArgumentException("While serializing point coordinates as double", e);
        }
    }

    private void multipoint(JsonGenerator jgen, MultiPoint multiPoint) throws IOException {
        for (Point point : multiPoint) {
            jgen.writeStartArray();
            this.point(jgen, point);
            jgen.writeEndArray();
        }
    }

    private void lineString(JsonGenerator jgen, ComposedGeospatial<Point> lineString) throws IOException {
        for (Point point : lineString) {
            jgen.writeStartArray();
            this.point(jgen, point);
            jgen.writeEndArray();
        }
    }

    private void multiLineString(JsonGenerator jgen, MultiLineString multiLineString) throws IOException {
        for (LineString lineString : multiLineString) {
            jgen.writeStartArray();
            this.lineString(jgen, (ComposedGeospatial<Point>)lineString);
            jgen.writeEndArray();
        }
    }

    private void polygon(JsonGenerator jgen, Polygon polygon) throws IOException {
        if (!polygon.getExterior().isEmpty()) {
            jgen.writeStartArray();
            this.lineString(jgen, (ComposedGeospatial<Point>)polygon.getExterior());
            jgen.writeEndArray();
        }
        if (!polygon.getInterior().isEmpty()) {
            jgen.writeStartArray();
            this.lineString(jgen, (ComposedGeospatial<Point>)polygon.getInterior());
            jgen.writeEndArray();
        }
    }

    private void multiPolygon(JsonGenerator jgen, MultiPolygon multiPolygon) throws IOException {
        for (Polygon polygon : multiPolygon) {
            jgen.writeStartArray();
            this.polygon(jgen, polygon);
            jgen.writeEndArray();
        }
    }

    private void collection(JsonGenerator jgen, GeospatialCollection collection) throws IOException {
        jgen.writeArrayFieldStart("geometries");
        for (Geospatial geospatial : collection) {
            jgen.writeStartObject();
            this.serialize(jgen, geospatial);
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }

    public void serialize(JsonGenerator jgen, Geospatial value) throws IOException {
        if (value.getEdmPrimitiveTypeKind().equals((Object)EdmPrimitiveTypeKind.GeographyCollection) || value.getEdmPrimitiveTypeKind().equals((Object)EdmPrimitiveTypeKind.GeometryCollection)) {
            jgen.writeStringField("type", EdmPrimitiveTypeKind.GeometryCollection.name());
        } else {
            int yIdx = value.getEdmPrimitiveTypeKind().name().indexOf(121);
            String itemType = value.getEdmPrimitiveTypeKind().name().substring(yIdx + 1);
            jgen.writeStringField("type", itemType);
        }
        switch (value.getEdmPrimitiveTypeKind()) {
            case GeographyPoint: 
            case GeometryPoint: {
                jgen.writeArrayFieldStart("coordinates");
                this.point(jgen, (Point)value);
                jgen.writeEndArray();
                break;
            }
            case GeographyMultiPoint: 
            case GeometryMultiPoint: {
                jgen.writeArrayFieldStart("coordinates");
                this.multipoint(jgen, (MultiPoint)value);
                jgen.writeEndArray();
                break;
            }
            case GeographyLineString: 
            case GeometryLineString: {
                jgen.writeArrayFieldStart("coordinates");
                this.lineString(jgen, (ComposedGeospatial<Point>)((LineString)value));
                jgen.writeEndArray();
                break;
            }
            case GeographyMultiLineString: 
            case GeometryMultiLineString: {
                jgen.writeArrayFieldStart("coordinates");
                this.multiLineString(jgen, (MultiLineString)value);
                jgen.writeEndArray();
                break;
            }
            case GeographyPolygon: 
            case GeometryPolygon: {
                jgen.writeArrayFieldStart("coordinates");
                this.polygon(jgen, (Polygon)value);
                jgen.writeEndArray();
                break;
            }
            case GeographyMultiPolygon: 
            case GeometryMultiPolygon: {
                jgen.writeArrayFieldStart("coordinates");
                this.multiPolygon(jgen, (MultiPolygon)value);
                jgen.writeEndArray();
                break;
            }
            case GeographyCollection: 
            case GeometryCollection: {
                this.collection(jgen, (GeospatialCollection)value);
                break;
            }
        }
        if (value.getSrid() != null && value.getSrid().isNotDefault()) {
            this.srid(jgen, value.getSrid());
        }
    }
}

