/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;

public final class ServiceDocumentImpl
implements ServiceDocument {
    private String title;
    private final List<ServiceDocumentItem> entitySets = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> functionImports = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> singletons = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> relatedServiceDocuments = new ArrayList<ServiceDocumentItem>();
    private String metadata;

    public URI getBaseURI() {
        URI baseURI = null;
        if (this.metadata != null) {
            String metadataURI = this.getMetadata();
            baseURI = URI.create(metadataURI.substring(0, metadataURI.indexOf("$metadata")));
        }
        return baseURI;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected ServiceDocumentItem getByName(List<ServiceDocumentItem> elements, String name) {
        ServiceDocumentItem result = null;
        for (ServiceDocumentItem element : elements) {
            if (!name.equals(element.getName())) continue;
            result = element;
        }
        return result;
    }

    public List<ServiceDocumentItem> getEntitySets() {
        return this.entitySets;
    }

    public ServiceDocumentItem getEntitySetByName(String name) {
        return this.getByName(this.getEntitySets(), name);
    }

    public List<ServiceDocumentItem> getFunctionImports() {
        return this.functionImports;
    }

    public ServiceDocumentItem getFunctionImportByName(String name) {
        return this.getByName(this.getFunctionImports(), name);
    }

    public List<ServiceDocumentItem> getSingletons() {
        return this.singletons;
    }

    public ServiceDocumentItem getSingletonByName(String name) {
        return this.getByName(this.getSingletons(), name);
    }

    public List<ServiceDocumentItem> getRelatedServiceDocuments() {
        return this.relatedServiceDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDocumentImpl that = (ServiceDocumentImpl)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.entitySets != null ? !this.entitySets.equals(that.entitySets) : that.entitySets != null) {
            return false;
        }
        if (this.functionImports != null ? !this.functionImports.equals(that.functionImports) : that.functionImports != null) {
            return false;
        }
        if (this.singletons != null ? !this.singletons.equals(that.singletons) : that.singletons != null) {
            return false;
        }
        if (this.relatedServiceDocuments != null ? !this.relatedServiceDocuments.equals(that.relatedServiceDocuments) : that.relatedServiceDocuments != null) {
            return false;
        }
        return !(this.metadata == null ? that.metadata != null : !this.metadata.equals(that.metadata));
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.entitySets != null ? this.entitySets.hashCode() : 0);
        result = 31 * result + (this.functionImports != null ? this.functionImports.hashCode() : 0);
        result = 31 * result + (this.singletons != null ? this.singletons.hashCode() : 0);
        result = 31 * result + (this.relatedServiceDocuments != null ? this.relatedServiceDocuments.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceDocumentImpl{title='" + this.title + '\'' + ", entitySets=" + this.entitySets + ", functionImports=" + this.functionImports + ", singletons=" + this.singletons + ", relatedServiceDocuments=" + this.relatedServiceDocuments + ", metadata='" + this.metadata + '\'' + '}';
    }
}

