/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataBasicRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractODataBasicRequest<T extends ODataResponse>
extends AbstractODataRequest
implements ODataBasicRequest<T> {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public AbstractODataBasicRequest(ODataClient odataClient, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
    }

    public void setFormat(ContentType contentType) {
        if (contentType != null) {
            String formatString = contentType.toContentTypeString();
            this.setAccept(formatString);
            this.setContentType(formatString);
        }
    }

    public final Future<T> asyncExecute() {
        return this.odataClient.getConfiguration().getExecutor().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractODataBasicRequest.this.execute();
            }
        });
    }

    protected abstract InputStream getPayload();

    public void batch(ODataBatchRequest req) {
        this.batch(req, null);
    }

    public void batch(ODataBatchRequest req, String contentId) {
        try {
            req.rawAppend(this.toByteArray());
            if (StringUtils.isNotBlank((CharSequence)contentId)) {
                req.rawAppend(("Content-ID: " + contentId).getBytes(DEFAULT_CHARSET));
                req.rawAppend(ODataStreamer.CRLF);
            }
            req.rawAppend(ODataStreamer.CRLF);
            InputStream payload = this.getPayload();
            if (payload != null) {
                req.rawAppend(IOUtils.toByteArray((InputStream)this.getPayload()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

