/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.prefer;

import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.format.PreferenceName;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.core.prefer.PreferParser;

public class PreferencesImpl
implements Preferences {
    private static final String URL = "url";
    private final Map<String, Preferences.Preference> preferences;

    public PreferencesImpl(Collection<String> preferHeaders) {
        this.preferences = PreferParser.parse(preferHeaders);
    }

    public Preferences.Preference getPreference(String name) {
        return this.preferences.get(name.toLowerCase(Locale.ROOT));
    }

    public boolean hasAllowEntityReferences() {
        return this.preferences.containsKey(PreferenceName.ALLOW_ENTITY_REFERENCES.getName());
    }

    public URI getCallback() {
        if (this.preferences.containsKey(PreferenceName.CALLBACK.getName()) && this.preferences.get(PreferenceName.CALLBACK.getName()).getParameters() != null && this.preferences.get(PreferenceName.CALLBACK.getName()).getParameters().get(URL) != null) {
            try {
                return URI.create((String)this.preferences.get(PreferenceName.CALLBACK.getName()).getParameters().get(URL));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public boolean hasContinueOnError() {
        return this.preferences.containsKey(PreferenceName.CONTINUE_ON_ERROR.getName());
    }

    public Integer getMaxPageSize() {
        return this.getNonNegativeIntegerPreference(PreferenceName.MAX_PAGE_SIZE.getName());
    }

    public boolean hasTrackChanges() {
        return this.preferences.containsKey(PreferenceName.TRACK_CHANGES.getName());
    }

    public Preferences.Return getReturn() {
        if (this.preferences.containsKey(PreferenceName.RETURN.getName())) {
            String value = this.preferences.get(PreferenceName.RETURN.getName()).getValue();
            if (Preferences.Return.REPRESENTATION.toString().toLowerCase(Locale.ROOT).equals(value)) {
                return Preferences.Return.REPRESENTATION;
            }
            if (Preferences.Return.MINIMAL.toString().toLowerCase(Locale.ROOT).equals(value)) {
                return Preferences.Return.MINIMAL;
            }
        }
        return null;
    }

    public boolean hasRespondAsync() {
        return this.preferences.containsKey(PreferenceName.RESPOND_ASYNC.getName());
    }

    public Integer getWait() {
        return this.getNonNegativeIntegerPreference(PreferenceName.WAIT.getName());
    }

    private Integer getNonNegativeIntegerPreference(String name) {
        if (this.preferences.containsKey(name) && this.preferences.get(name).getValue() != null) {
            try {
                Integer result = Integer.valueOf(this.preferences.get(name).getValue());
                return result < 0 ? null : result;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

