/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.core.Decoder;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.queryoption.CustomQueryOptionImpl;

public class UriDecoder {
    protected static List<String> splitAndDecodePath(String path) throws UriParserSyntaxException {
        ArrayList<String> pathSegmentsDecoded = new ArrayList<String>();
        for (String segment : UriDecoder.split(path, '/')) {
            pathSegmentsDecoded.add(UriDecoder.decode(segment));
        }
        return pathSegmentsDecoded;
    }

    protected static List<QueryOption> splitAndDecodeOptions(String queryOptionString) throws UriParserSyntaxException {
        ArrayList<QueryOption> queryOptions = new ArrayList<QueryOption>();
        for (String option : UriDecoder.split(queryOptionString, '&')) {
            int pos = option.indexOf(61);
            String name = pos >= 0 ? option.substring(0, pos) : option;
            String text = pos >= 0 ? option.substring(pos + 1).trim() : "";
            queryOptions.add(new CustomQueryOptionImpl().setName(UriDecoder.decode(name)).setText(UriDecoder.decode(text)));
        }
        return queryOptions;
    }

    private static List<String> split(String input, char c) {
        int end;
        LinkedList<String> list = new LinkedList<String>();
        int start = 0;
        while ((end = input.indexOf(c, start)) >= 0) {
            list.add(input.substring(start, end));
            start = end + 1;
        }
        list.add(input.substring(start));
        return list;
    }

    private static String decode(String encoded) throws UriParserSyntaxException {
        try {
            return Decoder.decode((String)encoded);
        }
        catch (IllegalArgumentException e) {
            throw new UriParserSyntaxException("Wrong percent encoding!", e, UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
    }
}

