/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.Collection;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceRefImpl;
import org.apache.olingo.server.core.uri.parser.FilterParser;
import org.apache.olingo.server.core.uri.parser.OrderByParser;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.SearchParser;
import org.apache.olingo.server.core.uri.parser.SelectParser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.CountOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.LevelsOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ExpandParser {
    private final Edm edm;
    private final OData odata;
    private final Map<String, AliasQueryOption> aliases;
    private final Collection<String> crossjoinEntitySetNames;

    public ExpandParser(Edm edm, OData odata, Map<String, AliasQueryOption> aliases, Collection<String> crossjoinEntitySetNames) {
        this.edm = edm;
        this.odata = odata;
        this.aliases = aliases;
        this.crossjoinEntitySetNames = crossjoinEntitySetNames;
    }

    public ExpandOption parse(UriTokenizer tokenizer, EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ExpandOptionImpl expandOption = new ExpandOptionImpl();
        do {
            ExpandItem item;
            if (this.crossjoinEntitySetNames != null && !this.crossjoinEntitySetNames.isEmpty()) {
                item = this.parseCrossJoinItem(tokenizer);
                expandOption.addExpandItem(item);
                continue;
            }
            item = this.parseItem(tokenizer, referencedType);
            expandOption.addExpandItem(item);
        } while (tokenizer.next(UriTokenizer.TokenKind.COMMA));
        return expandOption;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExpandItem parseCrossJoinItem(UriTokenizer tokenizer) throws UriParserSemanticException {
        ExpandItemImpl item = new ExpandItemImpl();
        if (tokenizer.next(UriTokenizer.TokenKind.STAR)) {
            item.setIsStar(true);
            return item;
        } else {
            if (!tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) throw new UriParserSemanticException("If the target resource is a crossjoin an entity set is needed as the starting point.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, new String[0]);
            String entitySetName = tokenizer.getText();
            if (!this.crossjoinEntitySetNames.contains(entitySetName)) throw new UriParserSemanticException("Unknown crossjoin entity set.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, entitySetName);
            UriInfoImpl resource = new UriInfoImpl().setKind(UriInfoKind.resource);
            UriResourceEntitySetImpl entitySetResourceSegment = new UriResourceEntitySetImpl(this.edm.getEntityContainer().getEntitySet(entitySetName));
            resource.addResourcePart(entitySetResourceSegment);
            item.setResourcePath((UriInfoResource)resource);
        }
        return item;
    }

    private ExpandItem parseItem(UriTokenizer tokenizer, EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ExpandItemImpl item = new ExpandItemImpl();
        if (tokenizer.next(UriTokenizer.TokenKind.STAR)) {
            item.setIsStar(true);
            if (tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.REF);
                item.setIsRef(true);
            } else if (tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.LEVELS);
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                item.setSystemQueryOption((SystemQueryOption)this.parseLevels(tokenizer));
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
            }
        } else {
            EdmStructuredType typeCast = ParserHelper.parseTypeCast(tokenizer, this.edm, referencedType);
            if (typeCast != null) {
                item.setTypeFilter((EdmType)typeCast);
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.SLASH);
            }
            UriInfoImpl resource = ExpandParser.parseExpandPath(tokenizer, this.edm, referencedType, item);
            UriResourcePartTyped lastPart = (UriResourcePartTyped)resource.getLastResourcePart();
            boolean hasSlash = false;
            EdmStructuredType typeCastSuffix = null;
            if (tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                UriResourceNavigationPropertyImpl navigationResource;
                EdmNavigationProperty navigationProperty;
                hasSlash = true;
                if (lastPart instanceof UriResourceNavigation && (typeCastSuffix = ParserHelper.parseTypeCast(tokenizer, this.edm, (EdmStructuredType)(navigationProperty = (navigationResource = (UriResourceNavigationPropertyImpl)lastPart).getProperty()).getType())) != null) {
                    if (navigationProperty.isCollection()) {
                        navigationResource.setCollectionTypeFilter((EdmType)typeCastSuffix);
                    } else {
                        navigationResource.setEntryTypeFilter((EdmType)typeCastSuffix);
                    }
                    hasSlash = false;
                }
            }
            EdmStructuredType newReferencedType = typeCastSuffix != null ? typeCastSuffix : (EdmStructuredType)lastPart.getType();
            boolean newReferencedIsCollection = lastPart.isCollection();
            if (hasSlash || tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                if (tokenizer.next(UriTokenizer.TokenKind.REF)) {
                    resource.addResourcePart(new UriResourceRefImpl());
                    item.setIsRef(true);
                    this.parseOptions(tokenizer, newReferencedType, newReferencedIsCollection, item, true, false);
                } else {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.COUNT);
                    resource.addResourcePart(new UriResourceCountImpl());
                    item.setCountPath(true);
                    this.parseOptions(tokenizer, newReferencedType, newReferencedIsCollection, item, false, true);
                }
            } else {
                this.parseOptions(tokenizer, newReferencedType, newReferencedIsCollection, item, false, false);
            }
            item.setResourcePath((UriInfoResource)resource);
        }
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static UriInfoImpl parseExpandPath(UriTokenizer tokenizer, Edm edm, EdmStructuredType referencedType, ExpandItemImpl item) throws UriParserException {
        UriInfoImpl resource = new UriInfoImpl().setKind(UriInfoKind.resource);
        EdmStructuredType type = referencedType;
        String name = null;
        while (tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
            name = tokenizer.getText();
            EdmProperty property = referencedType.getStructuralProperty(name);
            if (property == null || property.getType().getKind() != EdmTypeKind.COMPLEX) continue;
            type = (EdmStructuredType)property.getType();
            UriResourceComplexPropertyImpl complexResource = new UriResourceComplexPropertyImpl(property);
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.SLASH);
            EdmStructuredType typeCast = ParserHelper.parseTypeCast(tokenizer, edm, type);
            if (typeCast != null) {
                complexResource.setTypeFilter(typeCast);
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.SLASH);
                type = typeCast;
            }
            resource.addResourcePart(complexResource);
        }
        EdmNavigationProperty navigationProperty = type.getNavigationProperty(name);
        if (navigationProperty == null) {
            if (!tokenizer.next(UriTokenizer.TokenKind.STAR)) throw new UriParserSemanticException("Navigation Property '" + name + "' not found in type '" + type.getFullQualifiedName() + "'.", UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, type.getName(), name);
            item.setIsStar(true);
            return resource;
        } else {
            resource.addResourcePart(new UriResourceNavigationPropertyImpl(navigationProperty));
        }
        return resource;
    }

    private void parseOptions(UriTokenizer tokenizer, EdmStructuredType referencedType, boolean referencedIsCollection, ExpandItemImpl item, boolean forRef, boolean forCount) throws UriParserException, UriValidationException {
        if (tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            do {
                SystemQueryOption systemQueryOption;
                if (!forCount && tokenizer.next(UriTokenizer.TokenKind.COUNT)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.BooleanValue);
                    CountOptionImpl countOption = new CountOptionImpl();
                    countOption.setText(tokenizer.getText());
                    countOption.setValue(Boolean.parseBoolean(tokenizer.getText()));
                    systemQueryOption = countOption;
                } else if (!forRef && !forCount && tokenizer.next(UriTokenizer.TokenKind.EXPAND)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = new ExpandParser(this.edm, this.odata, this.aliases, null).parse(tokenizer, referencedType);
                } else if (tokenizer.next(UriTokenizer.TokenKind.FILTER)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = new FilterParser(this.edm, this.odata).parse(tokenizer, (EdmType)referencedType, null, this.aliases);
                } else if (!forRef && !forCount && tokenizer.next(UriTokenizer.TokenKind.LEVELS)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = (SystemQueryOption)this.parseLevels(tokenizer);
                } else if (!forCount && tokenizer.next(UriTokenizer.TokenKind.ORDERBY)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = new OrderByParser(this.edm, this.odata).parse(tokenizer, referencedType, null, this.aliases);
                } else if (tokenizer.next(UriTokenizer.TokenKind.SEARCH)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = new SearchParser().parse(tokenizer);
                } else if (!forRef && !forCount && tokenizer.next(UriTokenizer.TokenKind.SELECT)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    systemQueryOption = new SelectParser(this.edm).parse(tokenizer, referencedType, referencedIsCollection);
                } else if (!forCount && tokenizer.next(UriTokenizer.TokenKind.SKIP)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.IntegerValue);
                    int value = ParserHelper.parseNonNegativeInteger(SystemQueryOptionKind.SKIP.toString(), tokenizer.getText(), true);
                    SkipOptionImpl skipOption = new SkipOptionImpl();
                    skipOption.setText(tokenizer.getText());
                    skipOption.setValue(value);
                    systemQueryOption = skipOption;
                } else if (!forCount && tokenizer.next(UriTokenizer.TokenKind.TOP)) {
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.IntegerValue);
                    int value = ParserHelper.parseNonNegativeInteger(SystemQueryOptionKind.TOP.toString(), tokenizer.getText(), true);
                    TopOptionImpl topOption = new TopOptionImpl();
                    topOption.setText(tokenizer.getText());
                    topOption.setValue(value);
                    systemQueryOption = topOption;
                } else {
                    throw new UriParserSyntaxException("Allowed query option expected.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                }
                try {
                    item.setSystemQueryOption(systemQueryOption);
                }
                catch (ODataRuntimeException e) {
                    throw new UriParserSyntaxException("Double system query option '" + systemQueryOption.getName() + "'.", e, UriParserSyntaxException.MessageKeys.DOUBLE_SYSTEM_QUERY_OPTION, systemQueryOption.getName());
                }
            } while (tokenizer.next(UriTokenizer.TokenKind.SEMI));
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
        }
    }

    private LevelsExpandOption parseLevels(UriTokenizer tokenizer) throws UriParserException {
        LevelsOptionImpl option = new LevelsOptionImpl();
        if (tokenizer.next(UriTokenizer.TokenKind.MAX)) {
            option.setText(tokenizer.getText());
            option.setMax();
        } else {
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.IntegerValue);
            option.setText(tokenizer.getText());
            option.setValue(ParserHelper.parseNonNegativeInteger(SystemQueryOptionKind.LEVELS.toString(), tokenizer.getText(), false));
        }
        return option;
    }
}

