/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;
import org.apache.olingo.server.core.debug.DebugTab;

public class DebugTabRuntime
implements DebugTab {
    private static final int TO_MILLIS_DIVISOR = 1000;
    private final RuntimeNode rootNode = new RuntimeNode();

    public DebugTabRuntime(List<RuntimeMeasurement> runtimeInformation) {
        for (RuntimeMeasurement runtimeMeasurement : runtimeInformation) {
            this.rootNode.add(runtimeMeasurement);
        }
        this.rootNode.combineRuntimeMeasurements();
    }

    @Override
    public String getName() {
        return "Runtime";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        this.appendJsonChildren(gen, this.rootNode);
    }

    private void appendJsonChildren(JsonGenerator gen, RuntimeNode node) throws IOException {
        gen.writeStartArray();
        for (RuntimeNode child : node.children) {
            this.appendJsonNode(gen, child);
        }
        gen.writeEndArray();
    }

    private void appendJsonNode(JsonGenerator gen, RuntimeNode node) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("class", node.className);
        gen.writeStringField("method ", node.methodName);
        if (node.timeStopped == 0L) {
            gen.writeNullField("duration");
        } else {
            gen.writeStringField("duration", Long.toString((node.timeStopped - node.timeStarted) / 1000L));
            gen.writeStringField("unit", "\u00b5s");
        }
        if (!node.children.isEmpty()) {
            gen.writeFieldName("children");
            this.appendJsonChildren(gen, node);
        }
        gen.writeEndObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        this.appendRuntimeNode(this.rootNode, "", true, writer);
    }

    private void appendRuntimeNode(RuntimeNode node, String draw, boolean isLast, Writer writer) throws IOException {
        if (node.className != null) {
            writer.append("<li>\n").append("<span class=\"code\">").append("<span class=\"draw\">").append(draw).append(isLast ? "&#x2514;" : "&#x251C;").append("&#x2500;&nbsp;</span>").append("<span class=\"class\">").append(node.className).append("</span>.").append("<span class=\"method\">").append(node.methodName).append("(&hellip;)").append("</span></span>");
            long time = node.timeStopped == 0L ? 0L : (node.timeStopped - node.timeStarted) / 1000L;
            writer.append("<span class=\"").append(time == 0L ? "null" : "numeric").append("\" title=\"").append(time == 0L ? "Stop time missing" : "Gross duration").append("\">").append(time == 0L ? "unfinished" : Long.toString(time) + "&nbsp;&micro;s").append("</span>\n");
        }
        if (!node.children.isEmpty()) {
            writer.append("<ol class=\"tree\">\n");
            for (RuntimeNode childNode : node.children) {
                this.appendRuntimeNode(childNode, node.className == null ? draw : draw + (isLast ? "&nbsp;" : "&#x2502;") + "&nbsp;&nbsp;", node.children.indexOf(childNode) == node.children.size() - 1, writer);
            }
            writer.append("</ol>\n");
        }
        if (node.className != null) {
            writer.append("</li>\n");
        }
    }

    private class RuntimeNode {
        private String className;
        private String methodName;
        private long timeStarted;
        private long timeStopped;
        private List<RuntimeNode> children = new ArrayList<RuntimeNode>();

        protected RuntimeNode() {
            this.timeStarted = 0L;
            this.timeStopped = Long.MAX_VALUE;
        }

        private RuntimeNode(RuntimeMeasurement runtimeMeasurement) {
            this.className = runtimeMeasurement.getClassName();
            this.methodName = runtimeMeasurement.getMethodName();
            this.timeStarted = runtimeMeasurement.getTimeStarted();
            this.timeStopped = runtimeMeasurement.getTimeStopped();
        }

        protected boolean add(RuntimeMeasurement runtimeMeasurement) {
            if (this.timeStarted <= runtimeMeasurement.getTimeStarted() && this.timeStopped != 0L && this.timeStopped >= runtimeMeasurement.getTimeStopped()) {
                for (RuntimeNode candidate : this.children) {
                    if (!candidate.add(runtimeMeasurement)) continue;
                    return true;
                }
                this.children.add(new RuntimeNode(runtimeMeasurement));
                return true;
            }
            return false;
        }

        protected void combineRuntimeMeasurements() {
            RuntimeNode preceding = null;
            Iterator<RuntimeNode> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                RuntimeNode child = iterator.next();
                if (preceding != null && preceding.timeStopped != 0L && child.timeStopped != 0L && preceding.timeStopped <= child.timeStarted && preceding.children.isEmpty() && child.children.isEmpty() && preceding.methodName.equals(child.methodName) && preceding.className.equals(child.className)) {
                    preceding.timeStarted = child.timeStarted - (preceding.timeStopped - preceding.timeStarted);
                    preceding.timeStopped = child.timeStopped;
                    iterator.remove();
                    continue;
                }
                preceding = child;
                child.combineRuntimeMeasurements();
            }
        }
    }
}

