/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataHandler;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.OlingoExtension;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.etag.CustomETagSupport;
import org.apache.olingo.server.api.etag.PreconditionException;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataDispatcher;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.debug.ServerCoreDebugger;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.queryoption.FormatOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandlerImpl
implements ODataHandler {
    private final OData odata;
    private final ServiceMetadata serviceMetadata;
    private final List<Processor> processors = new LinkedList<Processor>();
    private final ServerCoreDebugger debugger;
    private CustomContentTypeSupport customContentTypeSupport;
    private CustomETagSupport customETagSupport;
    private UriInfo uriInfo;
    private Exception lastThrownException;

    public ODataHandlerImpl(OData odata, ServiceMetadata serviceMetadata, ServerCoreDebugger debugger) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
        this.debugger = debugger;
        this.register(new DefaultRedirectProcessor());
        this.register((Processor)new DefaultProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ODataResponse response = new ODataResponse();
        int responseHandle = this.debugger.startRuntimeMeasurement("ODataHandler", "process");
        try {
            this.processInternal(request, response);
        }
        catch (UriValidationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (UriParserSemanticException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (UriParserSyntaxException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (UriParserException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (ContentNegotiatorException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (SerializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (DeserializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (PreconditionException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (ODataHandlerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (ODataApplicationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, (Exception)((Object)e));
        }
        catch (Exception e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, e);
        }
        this.debugger.stopRuntimeMeasurement(responseHandle);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInternal(ODataRequest request, ODataResponse response) throws ODataApplicationException, ODataLibraryException {
        int measurementHandle = this.debugger.startRuntimeMeasurement("ODataHandler", "processInternal");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        try {
            this.validateODataVersion(request);
        }
        catch (ODataHandlerException e) {
            this.debugger.stopRuntimeMeasurement(measurementHandle);
            throw e;
        }
        int measurementUriParser = this.debugger.startRuntimeMeasurement("Parser", "parseUri");
        try {
            this.uriInfo = new Parser(this.serviceMetadata.getEdm(), this.odata).parseUri(request.getRawODataPath(), request.getRawQueryPath(), null);
        }
        catch (ODataLibraryException e) {
            this.debugger.stopRuntimeMeasurement(measurementUriParser);
            this.debugger.stopRuntimeMeasurement(measurementHandle);
            throw e;
        }
        this.debugger.stopRuntimeMeasurement(measurementUriParser);
        int measurementUriValidator = this.debugger.startRuntimeMeasurement("UriValidator", "validate");
        HttpMethod method = request.getMethod();
        try {
            new UriValidator().validate(this.uriInfo, method);
        }
        catch (UriValidationException e) {
            this.debugger.stopRuntimeMeasurement(measurementUriValidator);
            this.debugger.stopRuntimeMeasurement(measurementHandle);
            throw e;
        }
        this.debugger.stopRuntimeMeasurement(measurementUriValidator);
        int measurementDispatcher = this.debugger.startRuntimeMeasurement("ODataDispatcher", "dispatch");
        try {
            new ODataDispatcher(this.uriInfo, this).dispatch(request, response);
        }
        finally {
            this.debugger.stopRuntimeMeasurement(measurementDispatcher);
            this.debugger.stopRuntimeMeasurement(measurementHandle);
        }
    }

    public void handleException(ODataRequest request, ODataResponse response, ODataServerError serverError, Exception exception) {
        ContentType requestedContentType;
        ErrorProcessor exceptionProcessor;
        int measurementHandle = this.debugger.startRuntimeMeasurement("ODataHandler", "handleException");
        this.lastThrownException = exception;
        try {
            exceptionProcessor = this.selectProcessor(ErrorProcessor.class);
        }
        catch (ODataHandlerException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        try {
            FormatOption formatOption = this.getFormatOption(request, this.uriInfo);
            requestedContentType = ContentNegotiator.doContentNegotiation(formatOption, request, this.getCustomContentTypeSupport(), RepresentationType.ERROR);
        }
        catch (ContentNegotiatorException e) {
            requestedContentType = ContentType.JSON;
        }
        int measurementError = this.debugger.startRuntimeMeasurement("ErrorProcessor", "processError");
        exceptionProcessor.processError(request, response, serverError, requestedContentType);
        this.debugger.stopRuntimeMeasurement(measurementError);
        this.debugger.stopRuntimeMeasurement(measurementHandle);
    }

    private FormatOption getFormatOption(ODataRequest request, UriInfo uriInfo) {
        if (uriInfo == null) {
            String query = request.getRawQueryPath();
            if (query == null) {
                return null;
            }
            String formatOption = SystemQueryOptionKind.FORMAT.toString();
            int index = query.indexOf(formatOption);
            int endIndex = query.indexOf(38, index);
            if (endIndex == -1) {
                endIndex = query.length();
            }
            String format = query.substring(index + formatOption.length(), endIndex);
            return new FormatOptionImpl().setFormat(format);
        }
        return uriInfo.getFormatOption();
    }

    private void validateODataVersion(ODataRequest request) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, maxVersion);
        }
    }

    <T extends Processor> T selectProcessor(Class<T> cls) throws ODataHandlerException {
        for (Processor processor : this.processors) {
            if (!cls.isAssignableFrom(processor.getClass())) continue;
            processor.init(this.odata, this.serviceMetadata);
            return (T)((Processor)cls.cast(processor));
        }
        throw new ODataHandlerException("Processor: " + cls.getSimpleName() + " not registered.", ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, cls.getSimpleName());
    }

    public void register(Processor processor) {
        this.processors.add(0, processor);
    }

    public void register(OlingoExtension extension) {
        if (extension instanceof CustomContentTypeSupport) {
            this.customContentTypeSupport = (CustomContentTypeSupport)extension;
        } else if (extension instanceof CustomETagSupport) {
            this.customETagSupport = (CustomETagSupport)extension;
        } else {
            throw new ODataRuntimeException("Got not supported exception with class name " + extension.getClass().getSimpleName());
        }
    }

    public CustomContentTypeSupport getCustomContentTypeSupport() {
        return this.customContentTypeSupport;
    }

    public CustomETagSupport getCustomETagSupport() {
        return this.customETagSupport;
    }

    public Exception getLastThrownException() {
        return this.lastThrownException;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

