/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.uri.QueryOption;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.api.uri.URIFilter;
import org.apache.olingo.client.api.uri.URISearch;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.core.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIBuilderImpl
implements URIBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(URIBuilderImpl.class);
    private final Configuration configuration;
    protected final List<Segment> segments = new ArrayList<Segment>();
    protected final Map<String, String> queryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, String> parameters = new LinkedHashMap<String, String>();

    public URIBuilderImpl(Configuration configuration, String serviceRoot) {
        this.configuration = configuration;
        this.segments.add(new Segment(SegmentType.SERVICEROOT, serviceRoot));
    }

    public URIBuilder addQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, false);
    }

    public URIBuilder replaceQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, true);
    }

    public URIBuilder addQueryOption(String option, String value, boolean replace) {
        StringBuilder builder = new StringBuilder();
        if (!replace && this.queryOptions.containsKey(option)) {
            builder.append(this.queryOptions.get(option)).append(',');
        }
        builder.append(value);
        this.queryOptions.put(option, builder.toString());
        return this;
    }

    public URIBuilder addParameterAlias(String alias, String exp) {
        this.parameters.put(alias, exp);
        return this;
    }

    public URIBuilder appendEntitySetSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.ENTITYSET, segmentValue));
        return this;
    }

    public URIBuilder appendKeySegment(Object val) {
        String segValue = URIUtils.escape(val);
        this.segments.add(this.configuration.isKeyAsSegment() ? new Segment(SegmentType.KEY_AS_SEGMENT, segValue) : new Segment(SegmentType.KEY, "(" + segValue + ")"));
        return this;
    }

    public URIBuilder appendKeySegment(Map<String, Object> segmentValues) {
        if (!this.configuration.isKeyAsSegment()) {
            String key = this.buildMultiKeySegment(segmentValues, true, ',');
            if (StringUtils.isEmpty((CharSequence)key)) {
                this.segments.add(new Segment(SegmentType.KEY, this.noKeysWrapper()));
            } else {
                this.segments.add(new Segment(SegmentType.KEY, key));
            }
        }
        return this;
    }

    public URIBuilder appendPropertySegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.PROPERTY, segmentValue));
        return this;
    }

    public URIBuilder appendNavigationSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.NAVIGATION, segmentValue));
        return this;
    }

    public URIBuilder appendDerivedEntityTypeSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.DERIVED_ENTITY_TYPE, segmentValue));
        return this;
    }

    public URIBuilder appendValueSegment() {
        this.segments.add(new Segment(SegmentType.VALUE, SegmentType.VALUE.getValue()));
        return this;
    }

    public URIBuilder appendCountSegment() {
        this.segments.add(new Segment(SegmentType.COUNT, SegmentType.COUNT.getValue()));
        return this;
    }

    public URIBuilder appendActionCallSegment(String action) {
        this.segments.add(new Segment(this.segments.size() == 1 ? SegmentType.UNBOUND_ACTION : SegmentType.BOUND_ACTION, action));
        return this;
    }

    public URIBuilder appendOperationCallSegment(String operation) {
        this.segments.add(new Segment(this.segments.size() == 1 ? SegmentType.UNBOUND_OPERATION : SegmentType.BOUND_OPERATION, operation));
        return this;
    }

    public URIBuilder appendMetadataSegment() {
        this.segments.add(new Segment(SegmentType.METADATA, SegmentType.METADATA.getValue()));
        return this;
    }

    public URIBuilder appendBatchSegment() {
        this.segments.add(new Segment(SegmentType.BATCH, SegmentType.BATCH.getValue()));
        return this;
    }

    public URIBuilder count() {
        this.segments.add(new Segment(SegmentType.ROOT_QUERY_OPTION, "$" + QueryOption.COUNT.toString()));
        return this;
    }

    public URIBuilder expand(String ... expandItems) {
        return this.addQueryOption(QueryOption.EXPAND, StringUtils.join((Object[])expandItems, (String)","));
    }

    public URIBuilder format(String format) {
        return this.replaceQueryOption(QueryOption.FORMAT, format);
    }

    public URIBuilder filter(URIFilter filter) {
        URIBuilder result;
        try {
            result = this.filter(URLDecoder.decode(filter.build(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            result = this.filter(filter.build());
        }
        return result;
    }

    public URIBuilder filter(String filter) {
        return this.replaceQueryOption(QueryOption.FILTER, filter);
    }

    public URIBuilder select(String ... selectItems) {
        return this.addQueryOption(QueryOption.SELECT, StringUtils.join((Object[])selectItems, (String)","));
    }

    public URIBuilder orderBy(String order) {
        return this.replaceQueryOption(QueryOption.ORDERBY, order);
    }

    public URIBuilder top(int top) {
        return this.replaceQueryOption(QueryOption.TOP, String.valueOf(top));
    }

    public URIBuilder skip(int skip) {
        return this.replaceQueryOption(QueryOption.SKIP, String.valueOf(skip));
    }

    public URIBuilder skipToken(String skipToken) {
        return this.replaceQueryOption(QueryOption.SKIPTOKEN, skipToken);
    }

    public URI build() {
        StringBuilder segmentsBuilder = new StringBuilder();
        for (Segment segment : this.segments) {
            if (segmentsBuilder.length() > 0 && segment.getType() != SegmentType.KEY) {
                switch (segment.getType()) {
                    case BOUND_OPERATION: {
                        segmentsBuilder.append(this.getBoundOperationSeparator());
                        break;
                    }
                    case BOUND_ACTION: {
                        segmentsBuilder.append(this.getBoundOperationSeparator());
                        break;
                    }
                    default: {
                        if (segmentsBuilder.length() <= 0 || segmentsBuilder.charAt(segmentsBuilder.length() - 1) == '/') break;
                        segmentsBuilder.append('/');
                    }
                }
            }
            if (segment.getType() == SegmentType.ENTITY) {
                segmentsBuilder.append(segment.getType().getValue());
            } else {
                segmentsBuilder.append(segment.getValue());
            }
            if (segment.getType() != SegmentType.BOUND_OPERATION && segment.getType() != SegmentType.UNBOUND_OPERATION) continue;
            segmentsBuilder.append(this.getOperationInvokeMarker());
        }
        try {
            if (this.queryOptions.size() + this.parameters.size() > 0) {
                segmentsBuilder.append("?");
                LinkedList<NameValuePair> list1 = new LinkedList<NameValuePair>();
                for (Map.Entry<String, String> entry : this.queryOptions.entrySet()) {
                    list1.add((NameValuePair)new BasicNameValuePair("$" + entry.getKey(), entry.getValue()));
                }
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    list1.add((NameValuePair)new BasicNameValuePair("@" + entry.getKey(), entry.getValue()));
                }
                String string = this.encodeQueryParameter(list1);
                segmentsBuilder.append(string);
            }
            return URI.create(segmentsBuilder.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not build valid URI", e);
        }
    }

    private String encodeQueryParameter(List<NameValuePair> list) {
        StringBuilder builder = new StringBuilder();
        for (NameValuePair pair : list) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(Encoder.encode((String)pair.getName()));
            builder.append("=");
            builder.append(Encoder.encode((String)pair.getValue()));
        }
        return builder.toString();
    }

    public String toString() {
        return this.build().toASCIIString();
    }

    protected String buildMultiKeySegment(Map<String, Object> segmentValues, boolean escape, char sperator) {
        if (segmentValues == null || segmentValues.isEmpty()) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder().append('(');
        for (Map.Entry<String, Object> entry : segmentValues.entrySet()) {
            keyBuilder.append(entry.getKey()).append('=').append(escape ? URIUtils.escape(entry.getValue()) : entry.getValue());
            keyBuilder.append(sperator);
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1).append(')');
        return keyBuilder.toString();
    }

    public URIBuilder appendKeySegment(EdmEnumType enumType, String memberName) {
        return this.appendKeySegment(enumType.toUriLiteral(memberName));
    }

    public URIBuilder appendKeySegment(Map<String, Pair<EdmEnumType, String>> enumValues, Map<String, Object> segmentValues) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Pair<EdmEnumType, String>> entry : enumValues.entrySet()) {
            values.put(entry.getKey(), ((EdmEnumType)entry.getValue().getKey()).toUriLiteral((String)entry.getValue().getValue()));
        }
        values.putAll(segmentValues);
        return this.appendKeySegment(values);
    }

    protected String noKeysWrapper() {
        return "()";
    }

    protected char getBoundOperationSeparator() {
        return '/';
    }

    protected String getOperationInvokeMarker() {
        return "()";
    }

    public URIBuilder appendSingletonSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.SINGLETON, segmentValue));
        return this;
    }

    public URIBuilder appendEntityIdSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.ENTITY, null));
        return this.addQueryOption(QueryOption.ID, segmentValue);
    }

    public URIBuilder appendRefSegment() {
        this.segments.add(new Segment(SegmentType.REF, SegmentType.REF.getValue()));
        return this;
    }

    public URIBuilder appendCrossjoinSegment(String ... segmentValues) {
        StringBuilder segValue = new StringBuilder(SegmentType.CROSS_JOIN.getValue()).append('(').append(StringUtils.join((Object[])segmentValues, (String)",")).append(')');
        this.segments.add(new Segment(SegmentType.CROSS_JOIN, segValue.toString()));
        return this;
    }

    public URIBuilder appendAllSegment() {
        this.segments.add(new Segment(SegmentType.ALL, SegmentType.ALL.getValue()));
        return this;
    }

    public URIBuilder id(String idValue) {
        return this.addQueryOption(QueryOption.ID, idValue);
    }

    public URIBuilder search(URISearch search) {
        return this.search(search.build());
    }

    public URIBuilder search(String expression) {
        return this.addQueryOption(QueryOption.SEARCH, expression);
    }

    public URIBuilder count(boolean value) {
        return this.addQueryOption(QueryOption.COUNT, Boolean.toString(value));
    }

    public URIBuilder expandWithOptions(String expandItem, Map<QueryOption, Object> options) {
        return this.expandWithOptions(expandItem, false, false, options);
    }

    public URIBuilder expandWithOptions(String expandItem, boolean pathRef, boolean pathCount, Map<QueryOption, Object> options) {
        LinkedHashMap<String, Object> _options = new LinkedHashMap<String, Object>();
        for (Map.Entry<QueryOption, Object> entry : options.entrySet()) {
            _options.put("$" + entry.getKey().toString(), entry.getValue());
        }
        String path = pathRef ? "/$ref" : (pathCount ? "/$count" : "");
        return this.expand(expandItem + this.buildMultiKeySegment(_options, false, ';') + path);
    }

    public URIBuilder expandWithSelect(String expandItem, String ... selectItems) {
        return this.expand(expandItem + "($select=" + StringUtils.join((Object[])selectItems, (String)",") + ")");
    }

    protected static class Segment {
        private final SegmentType type;
        private final String value;

        public Segment(SegmentType type, String value) {
            this.type = type;
            this.value = value;
        }

        public SegmentType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

