/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlPropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlRecord;

@JsonDeserialize(using=RecordDeserializer.class)
class ClientCsdlRecord
extends CsdlRecord
implements Serializable {
    private static final long serialVersionUID = 4275271751615410709L;

    ClientCsdlRecord() {
    }

    static class RecordDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlRecord> {
        RecordDeserializer() {
        }

        @Override
        protected ClientCsdlRecord doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlRecord record = new ClientCsdlRecord();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        record.setType(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        record.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    } else {
                        record.getPropertyValues().add(jp.readValueAs(ClientCsdlPropertyValue.class));
                    }
                }
                jp.nextToken();
            }
            return record;
        }
    }
}

