/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;

@JsonDeserialize(using=TermDeserializer.class)
class ClientCsdlTerm
extends CsdlTerm
implements Serializable {
    private static final long serialVersionUID = -8350072064720586186L;

    ClientCsdlTerm() {
    }

    static class TermDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlTerm> {
        TermDeserializer() {
        }

        @Override
        protected ClientCsdlTerm doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlTerm term = new ClientCsdlTerm();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        term.setName(jp.nextTextValue());
                    } else if ("Type".equals(jp.getCurrentName())) {
                        term.setType(jp.nextTextValue());
                    } else if ("BaseTerm".equals(jp.getCurrentName())) {
                        term.setBaseTerm(jp.nextTextValue());
                    } else if ("DefaultValue".equals(jp.getCurrentName())) {
                        term.setDefaultValue(jp.nextTextValue());
                    } else if ("Nullable".equals(jp.getCurrentName())) {
                        term.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        term.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        term.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        term.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            term.setSrid(SRID.valueOf((String)srid));
                        }
                    } else if ("AppliesTo".equals(jp.getCurrentName())) {
                        term.getAppliesTo().addAll(Arrays.asList(StringUtils.split((String)jp.nextTextValue())));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        term.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return term;
        }
    }
}

