/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.NoContentException;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchController;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchLineIteratorImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataResponse
implements ODataResponse {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataResponse.class);
    protected final ODataClient odataClient;
    protected final HttpClient httpClient;
    protected final HttpResponse res;
    protected final Map<String, Collection<String>> headers = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
    protected int statusCode = -1;
    protected String statusMessage = null;
    protected InputStream payload = null;
    protected boolean hasBeenInitialized = false;
    protected ODataBatchController batchInfo = null;

    public AbstractODataResponse(ODataClient odataClient, HttpClient httpclient, HttpResponse res) {
        this.odataClient = odataClient;
        this.httpClient = httpclient;
        this.res = res;
        if (res != null) {
            this.initFromHttpResponse(res);
        }
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeader(String name) {
        return this.headers.get(name);
    }

    public String getETag() {
        Collection<String> etag = this.getHeader("ETag");
        return etag == null || etag.isEmpty() ? null : etag.iterator().next();
    }

    public String getContentType() {
        Collection<String> contentTypes = this.getHeader("Content-Type");
        return contentTypes == null || contentTypes.isEmpty() ? null : contentTypes.iterator().next();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public final ODataResponse initFromHttpResponse(HttpResponse res) {
        try {
            this.payload = res.getEntity() == null ? null : res.getEntity().getContent();
        }
        catch (IllegalStateException e) {
            HttpClientUtils.closeQuietly((HttpResponse)res);
            LOG.error("Error retrieving payload", (Throwable)e);
            throw new ODataRuntimeException((Exception)e);
        }
        catch (IOException e) {
            HttpClientUtils.closeQuietly((HttpResponse)res);
            LOG.error("Error retrieving payload", (Throwable)e);
            throw new ODataRuntimeException((Exception)e);
        }
        for (Header header : res.getAllHeaders()) {
            Collection<Object> headerValues;
            if (this.headers.containsKey(header.getName())) {
                headerValues = this.headers.get(header.getName());
            } else {
                headerValues = new HashSet();
                this.headers.put(header.getName(), headerValues);
            }
            headerValues.add(header.getValue());
        }
        this.statusCode = res.getStatusLine().getStatusCode();
        this.statusMessage = res.getStatusLine().getReasonPhrase();
        this.hasBeenInitialized = true;
        return this;
    }

    public ODataResponse initFromBatch(Map.Entry<Integer, String> responseLine, Map<String, Collection<String>> headers, ODataBatchLineIterator batchLineIterator, String boundary) {
        if (this.hasBeenInitialized) {
            throw new IllegalStateException("Request already initialized");
        }
        this.batchInfo = new ODataBatchController(batchLineIterator, boundary);
        this.statusCode = responseLine.getKey();
        this.statusMessage = responseLine.getValue();
        this.headers.putAll(headers);
        this.hasBeenInitialized = true;
        return this;
    }

    public ODataResponse initFromEnclosedPart(InputStream part) {
        try {
            if (this.hasBeenInitialized) {
                throw new IllegalStateException("Request already initialized");
            }
            ODataBatchLineIteratorImpl batchLineIterator = new ODataBatchLineIteratorImpl(IOUtils.lineIterator((InputStream)part, (String)"UTF-8"));
            Map.Entry<Integer, String> partResponseLine = ODataBatchUtilities.readResponseLine(batchLineIterator);
            LOG.debug("Retrieved async item response {}", partResponseLine);
            this.statusCode = partResponseLine.getKey();
            this.statusMessage = partResponseLine.getValue();
            Map<String, Collection<String>> partHeaders = ODataBatchUtilities.readHeaders(batchLineIterator);
            LOG.debug("Retrieved async item headers {}", partHeaders);
            this.headers.putAll(partHeaders);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (batchLineIterator.hasNext()) {
                bos.write(batchLineIterator.nextLine().getBytes("UTF-8"));
                bos.write(ODataStreamer.CRLF);
            }
            try {
                this.payload = new ByteArrayInputStream(bos.toByteArray());
            }
            catch (Exception e) {
                LOG.error("Error retrieving payload", (Throwable)e);
                throw new IllegalStateException(e);
            }
            this.hasBeenInitialized = true;
            return this;
        }
        catch (IOException e) {
            LOG.error("Error streaming payload response", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void close() {
        this.odataClient.getConfiguration().getHttpClientFactory().close(this.httpClient);
        if (this.batchInfo != null) {
            this.batchInfo.setValidBatch(false);
        }
    }

    public InputStream getRawResponse() {
        if (204 == this.getStatusCode()) {
            throw new NoContentException();
        }
        if (this.payload == null && this.batchInfo.isValidBatch()) {
            this.payload = new PipedInputStream();
            try {
                final PipedOutputStream os = new PipedOutputStream((PipedInputStream)this.payload);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ODataBatchUtilities.readBatchPart(AbstractODataResponse.this.batchInfo, os, true);
                        }
                        catch (Exception e) {
                            LOG.error("Error streaming batch item payload", (Throwable)e);
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)os);
                        }
                    }
                }).start();
            }
            catch (IOException e) {
                LOG.error("Error streaming payload response", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        return this.payload;
    }
}

