/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsl;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XslTransformHandler {
    private static final Logger __log = LoggerFactory.getLogger(XslTransformHandler.class);
    private static XslTransformHandler __singleton;
    private TransformerFactory _transformerFactory = null;
    private final MultiKeyMap _templateCache = new MultiKeyMap();

    public static synchronized XslTransformHandler getInstance() {
        if (__singleton == null) {
            __singleton = new XslTransformHandler();
        }
        return __singleton;
    }

    private XslTransformHandler() {
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this._transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXSLSheet(QName qName, URI uRI, String string, URIResolver uRIResolver) {
        Templates templates;
        try {
            this._transformerFactory.setURIResolver(uRIResolver);
            templates = this._transformerFactory.newTemplates(new StreamSource(new StringReader(string)));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            this._templateCache.put((Object)qName, (Object)uRI, (Object)templates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheXSLSheet(QName qName, URI uRI, String string, URIResolver uRIResolver) {
        Templates templates;
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            templates = (Templates)this._templateCache.get((Object)qName, (Object)uRI);
        }
        if (templates == null) {
            this.parseXSLSheet(qName, uRI, string, uRIResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(QName qName, URI uRI, Source source, Map<QName, Object> map, URIResolver uRIResolver) {
        Templates templates;
        Object object = this._templateCache;
        synchronized (object) {
            templates = (Templates)this._templateCache.get((Object)qName, (Object)uRI);
        }
        if (templates == null) {
            throw new XslTransformException("XSL sheet" + uRI + " has not been parsed before transformation!");
        }
        try {
            Object object2;
            Object object3;
            object = templates.newTransformer();
            ((Transformer)object).setURIResolver(uRIResolver);
            if (map != null) {
                object3 = map.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    ((Transformer)object).setParameter(((QName)object2.getKey()).getLocalPart(), object2.getValue());
                }
            }
            if ((object3 = ((Transformer)object).getOutputProperties().getProperty("method")) == null || "xml".equals(object3)) {
                object2 = new DOMResult();
                ((Transformer)object).transform(source, (Result)object2);
                Node node = ((DOMResult)object2).getNode();
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                if (__log.isDebugEnabled()) {
                    __log.debug("Returned node: type=" + node.getNodeType() + ", " + DOMUtils.domToString(node));
                }
                return node;
            }
            object2 = new StringWriter();
            StreamResult streamResult = new StreamResult((Writer)object2);
            ((Transformer)object).transform(source, streamResult);
            ((StringWriter)object2).flush();
            String string = ((StringWriter)object2).toString();
            if (__log.isDebugEnabled()) {
                __log.debug("Returned string: " + string);
            }
            return string;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XslTransformException("XSL Transformation failed!", transformerException);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this._transformerFactory.setErrorListener(errorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearXSLSheets(QName qName) {
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            this._templateCache.removeAll((Object)qName);
        }
    }
}

