/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.Messages;
import org.w3c.dom.Element;

public class WsdlUtils {
    private static final Messages msgs = Messages.getMessages(Messages.class);

    public static boolean useSOAPBinding(Binding binding) {
        ExtensibilityElement extensibilityElement = WsdlUtils.getBindingExtension(binding);
        return SOAPBinding.class.isAssignableFrom(extensibilityElement.getClass());
    }

    public static boolean useHTTPBinding(Binding binding) {
        ExtensibilityElement extensibilityElement = WsdlUtils.getBindingExtension(binding);
        if (extensibilityElement == null) {
            BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperations().get(0);
            ExtensibilityElement extensibilityElement2 = WsdlUtils.getOperationExtension(bindingOperation);
            return HTTPOperation.class.isAssignableFrom(extensibilityElement2.getClass());
        }
        return HTTPBinding.class.isAssignableFrom(extensibilityElement.getClass());
    }

    public static boolean useSOAPBinding(Port port) {
        return WsdlUtils.useSOAPBinding(port.getBinding());
    }

    public static boolean useHTTPBinding(Port port) {
        return WsdlUtils.useHTTPBinding(port.getBinding());
    }

    public static boolean useSOAPBinding(Definition definition, QName qName, String string) {
        Service service = definition.getService(qName);
        if (service == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(qName));
        }
        Port port = service.getPort(string);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(qName, string));
        }
        return WsdlUtils.useSOAPBinding(port);
    }

    public static boolean useHTTPBinding(Definition definition, QName qName, String string) {
        Service service = definition.getService(qName);
        if (service == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(qName));
        }
        Port port = service.getPort(string);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(qName, string));
        }
        return WsdlUtils.useHTTPBinding(port);
    }

    public static ExtensibilityElement getBindingExtension(Binding binding) {
        ArrayList arrayList = new ArrayList();
        CollectionsX.filter(arrayList, binding.getExtensibilityElements(), HTTPBinding.class);
        CollectionsX.filter(arrayList, binding.getExtensibilityElements(), SOAPBinding.class);
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleBindings(binding.getQName()));
        }
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)arrayList.iterator().next();
        return extensibilityElement;
    }

    public static ExtensibilityElement getBindingExtension(Port port) {
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new IllegalArgumentException(msgs.msgBindingNotFound(port.getName()));
        }
        return WsdlUtils.getBindingExtension(binding);
    }

    public static ExtensibilityElement getOperationExtension(BindingOperation bindingOperation) {
        ArrayList arrayList = new ArrayList();
        CollectionsX.filter(arrayList, bindingOperation.getExtensibilityElements(), HTTPOperation.class);
        CollectionsX.filter(arrayList, bindingOperation.getExtensibilityElements(), SOAPOperation.class);
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException(msgs.msgNoBindingForOperation(bindingOperation.getName()));
        }
        if (arrayList.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleBindingsForOperation(bindingOperation.getName()));
        }
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)arrayList.iterator().next();
        return extensibilityElement;
    }

    public static boolean useUrlEncoded(BindingInput bindingInput) {
        Collection<HTTPUrlEncoded> collection = CollectionsX.filter(bindingInput.getExtensibilityElements(), HTTPUrlEncoded.class);
        return !collection.isEmpty();
    }

    public static boolean useUrlReplacement(BindingInput bindingInput) {
        Collection<HTTPUrlReplacement> collection = CollectionsX.filter(bindingInput.getExtensibilityElements(), HTTPUrlReplacement.class);
        return !collection.isEmpty();
    }

    public static boolean useMimeMultipartRelated(BindingInput bindingInput) {
        Collection<MIMEMultipartRelated> collection = CollectionsX.filter(bindingInput.getExtensibilityElements(), MIMEMultipartRelated.class);
        return !collection.isEmpty();
    }

    public static MIMEContent getMimeContent(List list) {
        Collection<MIMEContent> collection = CollectionsX.filter(list, MIMEContent.class);
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleMimeContent());
        }
        return collection.iterator().next();
    }

    public static ExtensibilityElement getAddressExtension(Port port) {
        ArrayList arrayList = new ArrayList();
        CollectionsX.filter(arrayList, port.getExtensibilityElements(), HTTPAddress.class);
        CollectionsX.filter(arrayList, port.getExtensibilityElements(), SOAPAddress.class);
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException(msgs.msgNoAddressForPort(port.getName()));
        }
        if (arrayList.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleAddressesForPort(port.getName()));
        }
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)arrayList.iterator().next();
        return extensibilityElement;
    }

    public static String getOperationVerb(BindingOperation bindingOperation) {
        Collection<UnknownExtensibilityElement> collection = CollectionsX.filter(bindingOperation.getExtensibilityElements(), UnknownExtensibilityElement.class);
        for (UnknownExtensibilityElement unknownExtensibilityElement : collection) {
            Element element = unknownExtensibilityElement.getElement();
            if (!Namespaces.ODE_HTTP_EXTENSION_NS.equalsIgnoreCase(element.getNamespaceURI()) || !"binding".equals(unknownExtensibilityElement.getElement().getLocalName()) || !element.hasAttribute("verb")) continue;
            return element.getAttribute("verb");
        }
        return null;
    }

    public static boolean isOdeFault(BindingFault bindingFault) {
        Collection<UnknownExtensibilityElement> collection = CollectionsX.filter(bindingFault.getExtensibilityElements(), UnknownExtensibilityElement.class);
        for (UnknownExtensibilityElement unknownExtensibilityElement : collection) {
            Element element = unknownExtensibilityElement.getElement();
            if (!Namespaces.ODE_HTTP_EXTENSION_NS.equalsIgnoreCase(element.getNamespaceURI()) || !"fault".equals(unknownExtensibilityElement.getElement().getLocalName())) continue;
            if (element.hasAttribute("name")) {
                return bindingFault.getName().equals(element.getAttribute("name"));
            }
            return true;
        }
        return false;
    }

    public static Collection<UnknownExtensibilityElement> getHttpHeaders(List list) {
        Collection<UnknownExtensibilityElement> collection = CollectionsX.filter(list, UnknownExtensibilityElement.class);
        Iterator<UnknownExtensibilityElement> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next().getElement();
            if (Namespaces.ODE_HTTP_EXTENSION_NS.equalsIgnoreCase(element.getNamespaceURI()) && "header".equals(element.getLocalName())) continue;
            iterator.remove();
        }
        return collection;
    }

    public static Fault inferFault(Operation operation, QName qName) {
        for (Fault fault : operation.getFaults().values()) {
            Part part;
            Collection collection;
            if (fault.getMessage() == null || (collection = fault.getMessage().getParts().values()).isEmpty() || (part = (Part)collection.iterator().next()).getElementName() == null || !part.getElementName().equals(qName)) continue;
            return fault;
        }
        return null;
    }

    public static String resolveVerb(Binding binding, BindingOperation bindingOperation) {
        HTTPBinding hTTPBinding = (HTTPBinding)WsdlUtils.getBindingExtension(binding);
        String string = hTTPBinding != null ? hTTPBinding.getVerb() : null;
        String string2 = WsdlUtils.getOperationVerb(bindingOperation);
        return string2 != null ? string2 : string;
    }
}

