/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools.bpelc.cline;

import java.io.File;
import org.apache.ode.tools.ClineCommandContext;
import org.apache.ode.tools.ExecutionException;
import org.apache.ode.tools.bpelc.BpelCompileCommand;
import org.apache.ode.utils.cli.BaseCommandlineTool;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.ConsoleFormatter;
import org.apache.ode.utils.cli.FlagWithArgument;
import org.apache.ode.utils.cli.Fragments;
import org.apache.ode.utils.cli.MultiArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpelC
extends BaseCommandlineTool {
    private static final Logger __log = LoggerFactory.getLogger(BpelC.class);
    private static FlagWithArgument OUTPUT_DIR = new FlagWithArgument("od", "directory", "output directory", true);
    private static FlagWithArgument ROOT_WSDL = new FlagWithArgument("wsdl", "uri", "URI of the WSDL for the process (used with BPEL4WS 1.1 processes, for WS-BPEL 2.0 processes, use <import>).", true);
    private static MultiArgument BPEL_URLS = new MultiArgument("bpelurl", "the URLs of BPEL processes to compile.", false);
    private static Fragments DEFAULT = new Fragments(new CommandlineFragment[]{LOGGING, ROOT_WSDL, OUTPUT_DIR, BPEL_URLS});
    private static final String SYNOPSIS = "compile one or more BPEL processes";

    protected static String getProgramName() {
        return "bpelc";
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        BpelC.setClazz(BpelC.class);
        if (stringArray.length == 0 || HELP.matches(stringArray)) {
            ConsoleFormatter.printSynopsis((String)BpelC.getProgramName(), (String)SYNOPSIS, (Fragments[])new Fragments[]{DEFAULT, HELP});
            System.exit(0);
        }
        if (!DEFAULT.matches(stringArray)) {
            BpelC.consoleErr((String)("INVALID COMMANDLINE: Try \"" + BpelC.getProgramName() + " -h\" for help."));
            System.exit(-1);
        }
        BpelC.initLogging();
        BpelCompileCommand bpelCompileCommand = new BpelCompileCommand();
        if (OUTPUT_DIR.isSet()) {
            stringArray2 = OUTPUT_DIR.getValue();
            String[] stringArray3 = new File((String)stringArray2);
            if (!stringArray3.exists() || !stringArray3.isDirectory()) {
                BpelC.consoleErr((String)((String)stringArray2 + ": no such directory or not writable."));
                System.exit(-1);
            }
            bpelCompileCommand.setOuputDirectory((File)stringArray3);
        }
        if (ROOT_WSDL.isSet()) {
            bpelCompileCommand.setWsdlImportUri(ROOT_WSDL.getValue());
        }
        if ((stringArray2 = BPEL_URLS.getValues()) == null || stringArray2.length == 0) {
            BpelC.consoleErr((String)"At least one process must be specified.");
            System.exit(-1);
        }
        for (String string : stringArray2) {
            bpelCompileCommand.addBpelProcessUrl(string);
        }
        try {
            bpelCompileCommand.execute(new ClineCommandContext(__log));
        }
        catch (ExecutionException executionException) {
            BpelC.consoleErr((String)executionException.getMessage());
            System.exit(-1);
        }
        catch (Throwable throwable) {
            BpelC.consoleErr((String)throwable.getMessage());
            __log.error("", throwable);
            System.exit(-2);
        }
        System.exit(0);
    }
}

