/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools.bpelc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.apache.ode.bpel.compiler.BpelC;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.tools.Command;
import org.apache.ode.tools.CommandContext;
import org.apache.ode.tools.ExecutionException;
import org.apache.ode.tools.bpelc.BpelCompileCommandMessages;
import org.apache.ode.utils.SystemUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.ode.utils.msg.MessageBundle;

public class BpelCompileCommand
implements Command {
    private static final BpelCompileCommandMessages __msgs = (BpelCompileCommandMessages)MessageBundle.getMessages(BpelCompileCommandMessages.class);
    private short _minSeverity = (short)2;
    private CompileListener _compileListener;
    private CommandContext _cc;
    private File _outputDir;
    private String _wsdlUri;
    private HashSet<String> _bpelFiles = new HashSet();

    public void setCompileListener(CompileListener compileListener) {
        this._compileListener = compileListener;
    }

    public void setMinimumSeverity(short s) {
        this._minSeverity = s;
    }

    public void setOuputDirectory(File file) {
        this._outputDir = file;
    }

    public void setWsdlImportUri(String string) {
        this._wsdlUri = string;
    }

    public void addBpelProcessUrl(String string) {
        this._bpelFiles.add(string);
    }

    @Override
    public void execute(CommandContext commandContext) throws ExecutionException {
        if (this._bpelFiles.size() == 0) {
            throw new ExecutionException(__msgs.msgAtLeastOneProcessRequired());
        }
        if (this._outputDir == null) {
            this._outputDir = new File(SystemUtils.userDirectory());
        }
        this._cc = commandContext;
        CompileListener compileListener = new CompileListener(){

            public void onCompilationMessage(CompilationMessage compilationMessage) {
                if (compilationMessage.severity >= BpelCompileCommand.this._minSeverity) {
                    BpelCompileCommand.this._cc.outln(compilationMessage.toErrorString());
                }
                if (BpelCompileCommand.this._compileListener != null) {
                    BpelCompileCommand.this._compileListener.onCompilationMessage(compilationMessage);
                }
            }
        };
        URI uRI = null;
        if (this._wsdlUri != null) {
            try {
                uRI = new URI(FileUtils.encodePath((String)this._wsdlUri));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ExecutionException(__msgs.msgInvalidWsdlUrl(this._wsdlUri));
            }
        }
        for (String string : this._bpelFiles) {
            BpelC bpelC = BpelC.newBpelCompiler();
            if (uRI != null) {
                bpelC.setProcessWSDL(uRI);
            }
            bpelC.setCompileListener(compileListener);
            File file = new File(string);
            if (!file.exists()) {
                this._cc.debug("File does not exist: " + file);
                throw new ExecutionException(__msgs.msgInvalidBpelUrl(string));
            }
            try {
                long l = System.currentTimeMillis();
                bpelC.compile(file, BpelCompiler.getVersion((String)this._outputDir.getAbsolutePath()));
                long l2 = System.currentTimeMillis() - l;
                this._cc.info("Compilation completed in " + l2 + "ms");
            }
            catch (IOException iOException) {
                throw new ExecutionException(__msgs.msgIoExReadingStreamWithMsg(file, iOException.getMessage()));
            }
            catch (CompilationException compilationException) {
                throw new ExecutionException(compilationException.toErrorMessage(), compilationException);
            }
        }
    }
}

