/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath10.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.SourceLocatorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XslCompilationErrorListener
implements ErrorListener {
    private static final Logger __log = LoggerFactory.getLogger(XslCompilationErrorListener.class);
    private CompilerContext _cc;

    public XslCompilationErrorListener(CompilerContext compilerContext) {
        this._cc = compilerContext;
    }

    @Override
    public void warning(TransformerException transformerException) throws TransformerException {
        if (__log.isWarnEnabled()) {
            __log.warn("", (Throwable)transformerException);
        }
        this.recover((short)1, transformerException);
    }

    @Override
    public void error(TransformerException transformerException) throws TransformerException {
        if (__log.isErrorEnabled()) {
            __log.error("", (Throwable)transformerException);
        }
        this.recover((short)2, transformerException);
        throw transformerException;
    }

    @Override
    public void fatalError(TransformerException transformerException) throws TransformerException {
        __log.error("", (Throwable)transformerException);
        this.recover((short)2, transformerException);
        throw transformerException;
    }

    private void recover(short s, TransformerException transformerException) {
        SourceLocatorWrapper sourceLocatorWrapper;
        CompilationMessage compilationMessage = new CompilationMessage();
        compilationMessage.severity = s;
        compilationMessage.code = "parseXsl";
        compilationMessage.phase = 0;
        compilationMessage.messageText = transformerException.getMessageAndLocation();
        CompilationException compilationException = new CompilationException(compilationMessage, (Throwable)transformerException);
        SourceLocatorWrapper sourceLocatorWrapper2 = sourceLocatorWrapper = transformerException.getLocator() != null ? new SourceLocatorWrapper(transformerException.getLocator()) : null;
        if (this._cc != null) {
            this._cc.recoveredFromError(sourceLocatorWrapper, compilationException);
        } else {
            __log.error("XSL stylesheet parsing error! ", (Throwable)transformerException);
        }
    }
}

