/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlFinderXMLEntityResolver
implements XMLEntityResolver {
    private static final Logger __log = LoggerFactory.getLogger(WsdlFinderXMLEntityResolver.class);
    private boolean _failIfNotFound = true;
    private ResourceFinder _wsdlFinder;
    private Map<URI, byte[]> _internalSchemas = new HashMap<URI, byte[]>();
    private URI _baseURI;

    public WsdlFinderXMLEntityResolver(ResourceFinder resourceFinder, URI uRI, Map<URI, byte[]> map, boolean bl) {
        this._wsdlFinder = resourceFinder;
        this._baseURI = uRI;
        this._internalSchemas = map;
        this._failIfNotFound = bl;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        if (__log.isDebugEnabled()) {
            __log.debug("resolveEntity(" + xMLResourceIdentifier + ")");
        }
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        if (xMLResourceIdentifier.getLiteralSystemId() == null) {
            if (__log.isDebugEnabled()) {
                __log.debug("resolveEntity: no schema location for " + xMLResourceIdentifier.getNamespace());
            }
            try {
                if (this._internalSchemas.get(new URI(xMLResourceIdentifier.getNamespace())) != null) {
                    xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(this._internalSchemas.get(new URI(xMLResourceIdentifier.getNamespace()))));
                    return xMLInputSource;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                __log.debug("resolveEntity: no schema location an no known namespace for: " + xMLResourceIdentifier.getNamespace());
            }
            return null;
        }
        URI uRI = this._wsdlFinder.resolve(URI.create(xMLResourceIdentifier.getBaseSystemId()), URI.create(xMLResourceIdentifier.getLiteralSystemId()));
        if (__log.isDebugEnabled()) {
            __log.debug("resolveEntity: Expecting to find " + xMLResourceIdentifier.getNamespace() + " at " + uRI);
        }
        if (this._internalSchemas.get(uRI) != null) {
            xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(this._internalSchemas.get(uRI)));
            return xMLInputSource;
        }
        try {
            InputStream inputStream = this._wsdlFinder.openResource(uRI);
            if (inputStream == null) {
                __log.debug("resolveEntity: resource not found: " + uRI);
                throw new IOException("Resource not found: " + uRI);
            }
            xMLInputSource.setByteStream(inputStream);
        }
        catch (IOException iOException) {
            __log.debug("resolveEntity: IOException opening " + uRI, (Throwable)iOException);
            if (this._failIfNotFound) {
                __log.debug("resolveEntity: failIfNotFound is true, rethrowing...");
                throw iOException;
            }
            __log.debug("resolveEntity: failIfNotFound is false, returning null");
            return null;
        }
        catch (Exception exception) {
            __log.debug("resolveEntity: unexpected error: " + uRI);
            throw new IOException("Unexpected error loading resource: " + uRI);
        }
        return xMLInputSource;
    }
}

