/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.SourceLocationImpl;
import org.apache.ode.bpel.compiler.WsdlFinderXMLEntityResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.XMLSchemaType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.ode.utils.xsd.SchemaModelImpl;
import org.apache.ode.utils.xsd.XSUtils;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class WSDLRegistry {
    private static final Logger __log = LoggerFactory.getLogger(WSDLRegistry.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private final HashMap<String, ArrayList<Definition4BPEL>> _definitions = new HashMap();
    private final Map<URI, byte[]> _schemas = new HashMap<URI, byte[]>();
    private final Map<URI, byte[]> _internalSchemas = new HashMap<URI, byte[]>();
    private final Map<URI, Document> _documentSchemas = new HashMap<URI, Document>();
    private SchemaModel _model;
    private CompilerContext _ctx;

    WSDLRegistry(CompilerContext compilerContext) {
        this._schemas.put(URI.create("http://fivesight.com/bogus/namespace"), "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://fivesight.com/bogus/namespace\"><xsd:simpleType name=\"__bogusType__\"><xsd:restriction base=\"xsd:normalizedString\"/></xsd:simpleType></xsd:schema>".getBytes());
        try {
            this._schemas.put(URI.create(Namespaces.WSDL_11), StreamUtils.read((URL)this.getClass().getResource("/wsdl.xsd")));
            this._schemas.put(URI.create("http://www.w3.org/2001/xml.xsd"), StreamUtils.read((URL)this.getClass().getResource("/xml.xsd")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't load default schemas.", iOException);
        }
        this._ctx = compilerContext;
    }

    public Definition4BPEL[] getDefinitions() {
        ArrayList<Definition4BPEL> arrayList = new ArrayList<Definition4BPEL>();
        for (ArrayList<Definition4BPEL> arrayList2 : this._definitions.values()) {
            for (Definition4BPEL definition4BPEL : arrayList2) {
                arrayList.add(definition4BPEL);
            }
        }
        return arrayList.toArray(new Definition4BPEL[arrayList.size()]);
    }

    public SchemaModel getSchemaModel() {
        if (this._model == null) {
            this._model = SchemaModelImpl.newModel(this._schemas);
        }
        assert (this._model != null);
        return this._model;
    }

    public void addDefinition(Definition4BPEL definition4BPEL, ResourceFinder resourceFinder, URI uRI) throws CompilationException {
        if (definition4BPEL == null) {
            throw new NullPointerException("def=null");
        }
        if (__log.isDebugEnabled()) {
            __log.debug("addDefinition(" + definition4BPEL.getTargetNamespace() + " from " + definition4BPEL.getDocumentBaseURI() + ")");
        }
        if (this._definitions.containsKey(definition4BPEL.getTargetNamespace())) {
            if (__log.isInfoEnabled()) {
                __log.info("WSDL at " + uRI + " is a duplicate import, your documents should all be in different namespaces (its's not nice but will still work).");
            }
            boolean bl = false;
            for (Definition4BPEL object : this._definitions.get(definition4BPEL.getTargetNamespace())) {
                if (!object.getDocumentBaseURI().equals(definition4BPEL.getDocumentBaseURI())) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (__log.isInfoEnabled()) {
                    __log.info("WSDL at " + uRI + " is already imported, this denotes a circular reference.");
                }
                return;
            }
        }
        ArrayList<Definition4BPEL> arrayList = null;
        arrayList = this._definitions.get(definition4BPEL.getTargetNamespace()) == null ? new ArrayList<Definition4BPEL>() : this._definitions.get(definition4BPEL.getTargetNamespace());
        arrayList.add(definition4BPEL);
        this._definitions.put(definition4BPEL.getTargetNamespace(), arrayList);
        this.captureSchemas(definition4BPEL, resourceFinder, uRI);
        if (__log.isDebugEnabled()) {
            __log.debug("Processing <imports> in " + definition4BPEL.getDocumentBaseURI());
        }
        for (List list : definition4BPEL.getImports().values()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Import import_ : list) {
                Definition4BPEL definition4BPEL2;
                if (hashSet.contains(import_.getNamespaceURI()) && __log.isInfoEnabled()) {
                    __log.info("WSDL at " + import_.getLocationURI() + " imports several documents in the same namespace (" + import_.getNamespaceURI() + "), your documents should all be in different namespaces (its's not nice but will still work).");
                }
                if ((definition4BPEL2 = (Definition4BPEL)import_.getDefinition()) == null) {
                    CompilationException compilationException = new CompilationException(__cmsgs.errWsdlImportNotFound(import_.getNamespaceURI(), import_.getLocationURI()).setSource(new SourceLocationImpl(uRI)));
                    if (this._ctx == null) {
                        throw compilationException;
                    }
                    this._ctx.recoveredFromError(new SourceLocationImpl(uRI), compilationException);
                    continue;
                }
                hashSet.add(import_.getNamespaceURI());
                this.addDefinition((Definition4BPEL)import_.getDefinition(), resourceFinder, uRI.resolve(import_.getLocationURI()));
            }
        }
    }

    public void addSchemas(Map<URI, byte[]> map) {
        this._schemas.putAll(map);
    }

    private void captureSchemas(Definition definition, ResourceFinder resourceFinder, URI uRI) throws CompilationException {
        Types types;
        assert (definition != null);
        if (__log.isDebugEnabled()) {
            __log.debug("Processing XSD schemas in " + definition.getDocumentBaseURI());
        }
        if ((types = definition.getTypes()) != null) {
            this.addAllInternalSchemas(definition);
            int n = 0;
            for (ExtensibilityElement extensibilityElement : definition.getTypes().getExtensibilityElements()) {
                Object object;
                Object object22;
                Object object3;
                if (!(extensibilityElement instanceof XMLSchemaType)) continue;
                byte[] byArray = ((XMLSchemaType)extensibilityElement).getXMLSchema();
                WsdlFinderXMLEntityResolver wsdlFinderXMLEntityResolver = new WsdlFinderXMLEntityResolver(resourceFinder, uRI, this._internalSchemas, false);
                try {
                    object3 = XSUtils.captureSchema((URI)uRI, (byte[])byArray, (XMLEntityResolver)wsdlFinderXMLEntityResolver, (int)n);
                    for (Object object22 : object3.keySet()) {
                        if (this._schemas.containsKey(object22)) continue;
                        this._schemas.put((URI)object22, (byte[])object3.get(object22));
                    }
                    try {
                        object = DOMUtils.parse((InputSource)new InputSource(new ByteArrayInputStream(byArray)));
                        object22 = object.getDocumentElement().getAttribute("targetNamespace");
                        if (object22 != null && ((String)object22).length() > 0) {
                            this._internalSchemas.put(new URI((String)object22), byArray);
                            this._documentSchemas.put(new URI((String)object22), (Document)object);
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Couldn't parse schema in " + definition.getTargetNamespace(), exception);
                    }
                }
                catch (XsdException xsdException) {
                    __log.debug("captureSchemas: capture failed for " + uRI, (Throwable)xsdException);
                    object = new LinkedList();
                    while (object3 != null) {
                        ((LinkedList)object).addFirst(object3);
                        object3 = object3.getPrevious();
                    }
                    object22 = ((AbstractSequentialList)object).iterator();
                    while (object22.hasNext()) {
                        XsdException xsdException2 = (XsdException)((Object)object22.next());
                        CompilationException compilationException = new CompilationException(__cmsgs.errSchemaError(xsdException2.getDetailMessage()).setSource(new SourceLocationImpl(uRI)));
                        if (this._ctx != null) {
                            this._ctx.recoveredFromError(new SourceLocationImpl(uRI), compilationException);
                            continue;
                        }
                        throw compilationException;
                    }
                }
                this._model = null;
                ++n;
            }
        }
    }

    private void addAllInternalSchemas(Definition definition) {
        for (ExtensibilityElement extensibilityElement : definition.getTypes().getExtensibilityElements()) {
            if (!(extensibilityElement instanceof XMLSchemaType)) continue;
            byte[] byArray = ((XMLSchemaType)extensibilityElement).getXMLSchema();
            try {
                Document document = DOMUtils.parse((InputSource)new InputSource(new ByteArrayInputStream(byArray)));
                String string = document.getDocumentElement().getAttribute("targetNamespace");
                if (string == null || string.length() <= 0) continue;
                this._internalSchemas.put(new URI(string), byArray);
                this._documentSchemas.put(new URI(string), document);
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't parse schema in " + definition.getTargetNamespace(), exception);
            }
        }
    }

    public Property getProperty(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getProperty(qName) == null) continue;
            return definition4BPEL.getProperty(qName);
        }
        return null;
    }

    public PropertyAlias getPropertyAlias(QName qName, QName qName2) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPropertyAlias(qName, qName2) == null) continue;
            return definition4BPEL.getPropertyAlias(qName, qName2);
        }
        return null;
    }

    public PartnerLinkType getPartnerLinkType(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPartnerLinkType(qName) == null) continue;
            return definition4BPEL.getPartnerLinkType(qName);
        }
        return null;
    }

    public PortType getPortType(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPortType(qName) == null) continue;
            return definition4BPEL.getPortType(qName);
        }
        return null;
    }

    public Message getMessage(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getMessage(qName) == null) continue;
            return definition4BPEL.getMessage(qName);
        }
        return null;
    }

    Map<URI, Document> getSchemaDocuments() {
        return this._documentSchemas;
    }

    Map<URI, Source> getSchemaSources() {
        HashMap<URI, Source> hashMap = new HashMap<URI, Source>();
        for (URI uRI : this._documentSchemas.keySet()) {
            Document document = this._documentSchemas.get(uRI);
            hashMap.put(uRI, new DOMSource(document));
        }
        for (URI uRI : this._schemas.keySet()) {
            hashMap.put(uRI, new StreamSource(new ByteArrayInputStream(this._schemas.get(uRI))));
        }
        return hashMap;
    }
}

