/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Collection;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.FlowGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.CompositeActivity;
import org.apache.ode.bpel.compiler.bom.FlowActivity;
import org.apache.ode.bpel.compiler.bom.Link;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OFlow;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

class FlowGenerator
extends DefaultActivityGenerator {
    private static final FlowGeneratorMessages __cmsgs = (FlowGeneratorMessages)MessageBundle.getMessages(FlowGeneratorMessages.class);

    FlowGenerator() {
    }

    @Override
    public void compile(OActivity oActivity, Activity activity) {
        FlowActivity flowActivity = (FlowActivity)activity;
        OFlow oFlow = (OFlow)oActivity;
        this.compileLinkDecls(oFlow, flowActivity);
        this.compileChildren(oFlow, flowActivity);
        for (OLink oLink : oFlow.localLinks) {
            try {
                if (oLink.source == null) {
                    throw new CompilationException(__cmsgs.errLinkMissingSourceActivity(oLink.name).setSource(flowActivity));
                }
            }
            catch (CompilationException compilationException) {
                this._context.recoveredFromError(activity, compilationException);
            }
            try {
                if (oLink.target != null) continue;
                throw new CompilationException(__cmsgs.errLinkMissingTargetActivity(oLink.name).setSource(flowActivity));
            }
            catch (CompilationException compilationException) {
                this._context.recoveredFromError(activity, compilationException);
            }
        }
    }

    @Override
    public OActivity newInstance(Activity activity) {
        return new OFlow(this._context.getOProcess(), this._context.getCurrent());
    }

    private void compileLinkDecls(OFlow oFlow, FlowActivity flowActivity) {
        for (Link link : flowActivity.getLinks()) {
            OLink oLink = new OLink(this._context.getOProcess());
            oLink.name = link.getLinkName();
            this.declareLink(oFlow, oLink);
        }
    }

    private void declareLink(OFlow oFlow, final OLink oLink) throws CompilationException {
        if (CollectionsX.find_if((Collection)oFlow.localLinks, (MemberOfFunction)new MemberOfFunction<OLink>(){

            public boolean isMember(OLink oLink2) {
                return oLink2.name.equals(oLink.name);
            }
        }) != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkDecl(oLink.name));
        }
        oLink.declaringFlow = oFlow;
        oFlow.localLinks.add(oLink);
    }

    protected void compileChildren(OFlow oFlow, CompositeActivity compositeActivity) {
        for (Activity activity : compositeActivity.getActivities()) {
            try {
                OActivity oActivity = this._context.compile(activity);
                oFlow.parallelActivities.add(oActivity);
            }
            catch (CompilationException compilationException) {
                this._context.recoveredFromError(activity, compilationException);
            }
        }
    }
}

