/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Properties;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionValidator;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.o.OVarType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionValidatorFactory {
    private static final Logger __log = LoggerFactory.getLogger(ExpressionValidatorFactory.class);
    private ExpressionValidator _validator = new EmptyValidator();

    public ExpressionValidatorFactory(Properties properties) {
        String string = "org.apache.ode.validator";
        String string2 = properties.getProperty(string, "");
        __log.debug("Trying property " + string + " got value: " + string2);
        if (!string2.equals("")) {
            try {
                this.getClass();
                this._validator = (ExpressionValidator)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                __log.warn("Cannot instantiate expression validator of class " + string2);
            }
        }
    }

    public ExpressionValidator getValidator() {
        return this._validator;
    }

    private static class EmptyValidator
    implements ExpressionValidator {
        private EmptyValidator() {
        }

        @Override
        public void bpelImportsLoaded(Process process, CompilerContext compilerContext) throws CompilationException {
        }

        @Override
        public void bpelCompilationCompleted(Process process) throws CompilationException {
        }

        @Override
        public Object validate(Expression expression, OVarType oVarType, Object object) throws CompilationException {
            return null;
        }
    }
}

