/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ode.tomee;

public interface Constants {

    public static final String TOMEE_XML = "tomee.xml";
    public static final String TOMEE_SYSTEM_CONFIG = "system.properties";
    public static final String ODE_TOMEE_CONFIG = "ode-tomee.properties";

    public static final String DIR = "dir";
    public static final String HOST = "host";
    public static final String HTTP2 = "http2";
    public static final String HTTP_PORT = "httpPort";
    public static final String HTTPS_PORT = "httpsPort";
    public static final String KEEP_SERVER_XML_AS_THIS = "keepServerXmlAsThis";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String KEY_STORE_FILE = "keystoreFile";
    public static final String KEY_STAORE_PASS = "keystorePass";
    public static final String KEY_STORE_TYPE = "keystoreType";
    public static final String QUICK_SESSION = "quickSession";
    public static final String SERVER_XML = "serverXml";
    public static final String SKIP_HTTP = "skipHttp";
    public static final String SSL = "ssl";
    public static final String SSL_PROPTOCOL = "sslProtocol";
    public static final String STOP_PORT = "stopPort";
    public static final String WEB_RESOURCE_CACHED = "webResourceCached";
    public static final String WEB_XML = "webXml";
}
